/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.IBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class RenderBlockEntity<T extends BlockEntityBase>
extends EntityRenderer<T> {
    private static BakedModel crate_model;
    static final Tesselator t;
    float pitch = 0.0f;
    float yaw = 0.0f;
    long time = 0L;
    boolean up = true;
    BufferBuilder b = t.m_85915_();
    ResourceLocation texture;

    public RenderBlockEntity(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack mat, MultiBufferSource bufferIn, int packedLightIn) {
        if (!(entity instanceof IBlockEntity)) {
            return;
        }
        try {
            mat.m_85836_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            T blockEntity = entity;
            int xMin = Mth.m_14143_((float)blockEntity.getMin().m_123341_());
            int xMax = Mth.m_14143_((float)blockEntity.getMax().m_123341_());
            int zMin = Mth.m_14143_((float)blockEntity.getMin().m_123343_());
            int zMax = Mth.m_14143_((float)blockEntity.getMax().m_123343_());
            int yMin = Mth.m_14143_((float)blockEntity.getMin().m_123342_());
            int yMax = Mth.m_14143_((float)blockEntity.getMax().m_123342_());
            mat.m_85837_((double)xMin, 0.0, (double)zMin);
            mat.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
            mat.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            mat.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            if (entity instanceof IMultiplePassengerEntity) {
                IMultiplePassengerEntity multi = (IMultiplePassengerEntity)entity;
                float yaw = -(multi.getPrevYaw() + (multi.getYaw() - multi.getPrevYaw()) * partialTicks);
                float pitch = -(multi.getPrevPitch() + (multi.getPitch() - multi.getPrevPitch()) * partialTicks);
                mat.m_85845_(new Quaternion(0.0f, yaw, pitch, true));
            }
            for (int i = xMin; i <= xMax; ++i) {
                for (int j = yMin; j <= yMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        pos.m_122178_(i - xMin, j - yMin, k - zMin);
                        if (!blockEntity.shouldHide((BlockPos)pos)) {
                            mat.m_85836_();
                            mat.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                            this.drawTileAt((BlockPos)pos, (IBlockEntity)blockEntity, partialTicks, mat, bufferIn, packedLightIn);
                            this.drawBlockAt((BlockPos)pos, (IBlockEntity)blockEntity, mat, bufferIn, packedLightIn);
                            mat.m_85849_();
                            continue;
                        }
                        this.drawCrateAt(pos, (IBlockEntity)blockEntity, mat, bufferIn, packedLightIn);
                    }
                }
            }
            mat.m_85849_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawBlockAt(BlockPos pos, IBlockEntity entity, PoseStack mat, MultiBufferSource bufferIn, int packedLightIn) {
        if (entity.getBlocks() == null) {
            return;
        }
        BlockState state = entity.getBlocks()[pos.m_123341_()][pos.m_123342_()][pos.m_123343_()];
        BlockPos mobPos = entity.getMin();
        BlockPos realpos = pos.m_121955_((Vec3i)mobPos).m_121955_((Vec3i)((Entity)entity).m_20183_());
        if (state == null) {
            state = Blocks.f_50016_.m_49966_();
        }
        if (state.m_60767_() != Material.f_76296_) {
            BlockState actualstate = state;
            this.renderBakedBlockModel(entity, actualstate, (BlockGetter)entity.getFakeWorld(), realpos, pos, mat, bufferIn, packedLightIn);
        }
    }

    private void drawCrateAt(BlockPos.MutableBlockPos pos, IBlockEntity blockEntity, PoseStack mat, MultiBufferSource bufferIn, int packedLightIn) {
        mat.m_85836_();
        mat.m_85845_(new Quaternion(-180.0f, 90.0f, 0.0f, true));
        mat.m_85837_(0.5, 0.5, 0.5);
        float f7 = 1.0f;
        mat.m_85841_(-1.0f, -1.0f, 1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        this.getCrateModel();
        mat.m_85849_();
    }

    private void drawTileAt(BlockPos pos, IBlockEntity entity, float partialTicks, PoseStack mat, MultiBufferSource bufferIn, int packedLightIn) {
        BlockEntity tile = entity.getTiles()[pos.m_123341_()][pos.m_123342_()][pos.m_123343_()];
        if (tile != null) {
            Minecraft.m_91087_().m_167982_().m_112267_(tile, (float)packedLightIn, mat, bufferIn);
        }
    }

    private BakedModel getCrateModel() {
        if (crate_model == null) {
            ModelResourceLocation loc = new ModelResourceLocation("thutcore:craft_crate");
            crate_model = Minecraft.m_91087_().m_91304_().getModel((ResourceLocation)loc);
        }
        return crate_model;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return InventoryMenu.f_39692_;
    }

    private void renderBakedBlockModel(IBlockEntity entity, BlockState state, BlockGetter world, BlockPos real_pos, BlockPos relPos, PoseStack mat, MultiBufferSource bufferIn, int packedLightIn) {
        BlockPos rpos = relPos.m_121955_((Vec3i)entity.getOriginalPos());
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        BakedModel model = dispatcher.m_110910_(state);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.m_216335_((long)state.m_60726_(rpos)), ModelData.EMPTY)) {
            dispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)world, model, state, rpos, mat, bufferIn.m_6299_(renderType), false, RandomSource.m_216327_(), state.m_60726_(rpos), OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
        }
    }

    static {
        t = new Tesselator(0x200000);
    }
}

