/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity.world;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.AABB;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.world.EntityChunk;
import thut.api.entity.blockentity.world.WorldEntity;
import thut.core.common.ThutCore;

public class BlockEntityChunkProvider
extends ChunkSource {
    private final WorldEntity world;
    private LevelLightEngine lightManager;
    private final Map<BlockPos, LevelChunk> chunks = Maps.newHashMap();
    private BlockPos lastOrigin = null;

    public BlockEntityChunkProvider(WorldEntity worldIn) {
        this.world = worldIn;
        try {
            this.lightManager = new LevelLightEngine((LightChunkGetter)this, true, worldIn.getWorld().m_6042_().f_223549_());
        }
        catch (Exception e) {
            ThutCore.LOGGER.error("Error making new light manager!");
            ThutCore.LOGGER.error((Object)e);
            this.lightManager = worldIn.m_5518_();
        }
    }

    public ChunkAccess m_7587_(int chunkX, int chunkZ, ChunkStatus status, boolean load) {
        AABB chunkBox = new AABB((double)(chunkX * 16), 0.0, (double)(chunkZ * 16), (double)(chunkX * 16 + 15), (double)this.world.getWorld().m_151558_(), (double)(chunkZ * 16 + 15));
        if (!this.intersects(chunkBox)) {
            return this.world.getWorld().m_6325_(chunkX, chunkZ);
        }
        Entity entity = (Entity)this.world.getBlockEntity();
        if (this.lastOrigin == null || !this.lastOrigin.equals((Object)entity.m_20183_())) {
            this.lastOrigin = entity.m_20183_();
            this.chunks.clear();
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.m_122178_(chunkX, 0, chunkZ);
        BlockPos immut = pos.m_7949_();
        if (this.chunks.containsKey(immut)) {
            return (ChunkAccess)this.chunks.get(immut);
        }
        ChunkPos cpos = new ChunkPos(chunkX, chunkZ);
        EntityChunk ret = new EntityChunk(this.world, cpos);
        this.chunks.put(immut, ret);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 16; ++k) {
                    int x = chunkX * 16 + i;
                    int y = j;
                    int z = chunkZ * 16 + k;
                    pos.m_122178_(x, y, z);
                    BlockState state = this.world.m_8055_((BlockPos)pos);
                    if (state.m_60734_() == Blocks.f_50016_) continue;
                    LevelChunkSection storage = ret.m_7103_()[j >> 4];
                    if (storage == null) {
                        ret.m_7103_()[j >> 4] = storage = new LevelChunkSection(j >> 4 << 4, this.world.world.m_5962_().m_175515_(Registry.f_122885_));
                    }
                    storage.m_62991_(i & 0xF, j & 0xF, k & 0xF, state, false);
                    BlockEntity tile = this.world.m_7702_((BlockPos)pos);
                    if (tile == null) continue;
                    ret.m_142169_(tile);
                }
            }
        }
        return ret;
    }

    public LevelLightEngine m_7827_() {
        return this.lightManager;
    }

    public BlockGetter m_7653_() {
        return this.world;
    }

    private boolean intersects(AABB other) {
        IBlockEntity mob = this.world.getBlockEntity();
        AABB thisBox = ((Entity)mob).m_20191_();
        return thisBox.m_82381_(other);
    }

    public String m_6754_() {
        return "BlockEntity: " + this.world + " " + this.world.getWorld();
    }

    public int m_8482_() {
        return 0;
    }

    public void m_201698_(BooleanSupplier p_202162_, boolean p_202163_) {
    }
}

