/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity.world;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import thut.api.entity.blockentity.IBlockEntity;

public interface IBlockEntityWorld
extends LevelAccessor {
    default public BlockState getBlock(BlockPos pos) {
        if (!this.inBounds(pos)) {
            return null;
        }
        IBlockEntity mob = this.getBlockEntity();
        Entity entity = (Entity)mob;
        int i = pos.m_123341_() - Mth.m_14107_((double)(entity.m_20185_() + (double)mob.getMin().m_123341_()));
        int j = pos.m_123342_() - Mth.m_14107_((double)(entity.m_20186_() + (double)mob.getMin().m_123342_()));
        int k = pos.m_123343_() - Mth.m_14107_((double)(entity.m_20189_() + (double)mob.getMin().m_123343_()));
        return mob.getBlocks()[i][j][k];
    }

    default public BlockState getBlockRelative(BlockPos pos) {
        IBlockEntity mob = this.getBlockEntity();
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        int sizeX = mob.getBlocks().length;
        int sizeY = mob.getBlocks()[0].length;
        int sizeZ = mob.getBlocks()[0][0].length;
        if (i < sizeX && j < sizeY && k < sizeZ && i >= 0 && j >= 0 && k >= 0) {
            return mob.getBlocks()[i][j][k];
        }
        return null;
    }

    default public void setBlockRelative(BlockPos pos, BlockState state) {
        IBlockEntity mob = this.getBlockEntity();
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        int sizeX = mob.getBlocks().length;
        int sizeY = mob.getBlocks()[0].length;
        int sizeZ = mob.getBlocks()[0][0].length;
        if (i < sizeX && j < sizeY && k < sizeZ && i >= 0 && j >= 0 && k >= 0) {
            mob.getBlocks()[i][j][k] = state;
        }
    }

    public IBlockEntity getBlockEntity();

    default public Level getWorld() {
        Entity entity = (Entity)this.getBlockEntity();
        return entity.m_9236_();
    }

    default public BlockEntity getTile(BlockPos pos) {
        if (!this.inBounds(pos)) {
            return null;
        }
        IBlockEntity mob = this.getBlockEntity();
        Entity entity = (Entity)mob;
        pos = pos.m_7949_();
        int i = pos.m_123341_() - Mth.m_14107_((double)(entity.m_20185_() + (double)mob.getMin().m_123341_()));
        int j = pos.m_123342_() - Mth.m_14107_((double)(entity.m_20186_() + (double)mob.getMin().m_123342_()));
        int k = pos.m_123343_() - Mth.m_14107_((double)(entity.m_20189_() + (double)mob.getMin().m_123343_()));
        BlockEntity tile = mob.getTiles()[i][j][k];
        if (tile != null && !tile.m_58899_().equals((Object)pos)) {
            CompoundTag tag = tile.serializeNBT();
            mob.getTiles()[i][j][k] = BlockEntity.m_155241_((BlockPos)pos, (BlockState)mob.getBlocks()[i][j][k], (CompoundTag)tag);
        }
        return tile;
    }

    default public boolean inBounds(BlockPos pos) {
        IBlockEntity mob = this.getBlockEntity();
        if (mob.getBlocks() == null) {
            return false;
        }
        Entity entity = (Entity)mob;
        int i = pos.m_123341_() - Mth.m_14107_((double)(entity.m_20185_() + (double)mob.getMin().m_123341_()));
        int j = pos.m_123342_() - Mth.m_14107_((double)(entity.m_20186_() + (double)mob.getMin().m_123342_()));
        int k = pos.m_123343_() - Mth.m_14107_((double)(entity.m_20189_() + (double)mob.getMin().m_123343_()));
        return i < mob.getBlocks().length && j < mob.getBlocks()[0].length && k < mob.getBlocks()[0][0].length && i >= 0 && j >= 0 && k >= 0;
    }

    default public boolean setBlock(BlockPos pos, BlockState state) {
        if (!this.inBounds(pos)) {
            return false;
        }
        IBlockEntity mob = this.getBlockEntity();
        Entity entity = (Entity)mob;
        int i = pos.m_123341_() - Mth.m_14107_((double)(entity.m_20185_() + (double)mob.getMin().m_123341_()));
        int j = pos.m_123342_() - Mth.m_14107_((double)(entity.m_20186_() + (double)mob.getMin().m_123342_()));
        int k = pos.m_123343_() - Mth.m_14107_((double)(entity.m_20189_() + (double)mob.getMin().m_123343_()));
        mob.getBlocks()[i][j][k] = state;
        return true;
    }

    default public void setBlockEntity(IBlockEntity mob) {
        Entity entity = (Entity)mob;
        int xMin = mob.getMin().m_123341_();
        int zMin = mob.getMin().m_123343_();
        int yMin = mob.getMin().m_123342_();
        if (mob.getBlocks() == null) {
            if (!entity.m_9236_().f_46443_) {
                entity.m_146870_();
            }
            return;
        }
        int sizeX = mob.getBlocks().length;
        int sizeY = mob.getBlocks()[0].length;
        int sizeZ = mob.getBlocks()[0][0].length;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    BlockEntity tile = mob.getTiles()[i][j][k];
                    if (tile == null) continue;
                    BlockPos pos = new BlockPos((double)(i + xMin) + entity.m_20185_(), (double)(j + yMin) + entity.m_20186_(), (double)(k + zMin) + entity.m_20189_());
                    BlockPos old = tile.m_58899_();
                    if (old.equals((Object)pos)) continue;
                    CompoundTag tag = tile.serializeNBT();
                    mob.getTiles()[i][j][k] = BlockEntity.m_155241_((BlockPos)pos, (BlockState)mob.getBlocks()[i][j][k], (CompoundTag)tag);
                }
            }
        }
    }

    default public boolean setTile(BlockPos pos, BlockEntity tile) {
        if (!this.inBounds(pos)) {
            return false;
        }
        IBlockEntity mob = this.getBlockEntity();
        Entity entity = (Entity)mob;
        int i = pos.m_123341_() - Mth.m_14107_((double)(entity.m_20185_() + (double)mob.getMin().m_123341_()));
        int j = pos.m_123342_() - Mth.m_14107_((double)(entity.m_20186_() + (double)mob.getMin().m_123342_()));
        int k = pos.m_123343_() - Mth.m_14107_((double)(entity.m_20189_() + (double)mob.getMin().m_123343_()));
        mob.getTiles()[i][j][k] = tile;
        if (tile != null && !tile.m_58899_().equals((Object)pos)) {
            CompoundTag tag = tile.serializeNBT();
            mob.getTiles()[i][j][k] = BlockEntity.m_155241_((BlockPos)pos, (BlockState)mob.getBlocks()[i][j][k], (CompoundTag)tag);
        }
        return true;
    }

    default public HitResult trace(ClipContext context) {
        return this.getWorld().m_45547_(context);
    }
}

