/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.genetics;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import thut.api.entity.genetics.Gene;
import thut.api.entity.genetics.GeneRegistry;
import thut.core.common.ThutCore;

public class Alleles<T, GENE extends Gene<T>> {
    final ArrayList<GENE> alleles = new ArrayList(2);
    final Random rand = ThutCore.newRandom();
    GENE expressed;

    public Alleles() {
        while (this.alleles.size() < 2) {
            this.alleles.add(null);
        }
    }

    public Alleles(GENE gene1, GENE gene2) {
        this();
        this.alleles.set(0, gene1);
        this.alleles.set(1, gene2);
        if (gene1 == null || gene2 == null) {
            throw new IllegalStateException("Genes cannot be null");
        }
    }

    public GENE getAllele(int index) {
        return (GENE)((Gene)this.alleles.get(index));
    }

    public void setAllele(int index, GENE gene) {
        this.alleles.set(index, gene);
    }

    public GENE getExpressed() {
        if (this.expressed == null) {
            this.refreshExpressed();
        }
        return this.expressed;
    }

    public void setExpressed(GENE expressed) {
        this.expressed = expressed;
    }

    public void load(CompoundTag tag) throws Exception {
        this.expressed = GeneRegistry.load(tag.m_128469_("expressed"));
        this.alleles.set(0, GeneRegistry.load(tag.m_128469_("gene1")));
        this.alleles.set(1, GeneRegistry.load(tag.m_128469_("gene2")));
    }

    public void refreshExpressed() {
        Gene a = (Gene)this.alleles.get(0);
        Gene b = (Gene)this.alleles.get(1);
        if (a == null || b == null) {
            throw new IllegalStateException("Genes cannot be null");
        }
        a = a.getMutationRate() > this.rand.nextFloat() ? a.mutate() : a;
        b = b.getMutationRate() > this.rand.nextFloat() ? b.mutate() : b;
        this.expressed = a.interpolate(b);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        try {
            tag.m_128365_("expressed", (Tag)GeneRegistry.save(this.getExpressed()));
        }
        catch (Exception e) {
            ThutCore.LOGGER.error(this.getExpressed() + " " + this.getExpressed().getKey(), (Throwable)e);
        }
        tag.m_128365_("gene1", (Tag)GeneRegistry.save(this.getAllele(0)));
        tag.m_128365_("gene2", (Tag)GeneRegistry.save(this.getAllele(1)));
        return tag;
    }
}

