/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.genetics;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import thut.api.entity.genetics.Gene;
import thut.core.common.ThutCore;

public class GeneRegistry {
    static Map<ResourceLocation, Class<? extends Gene<?>>> geneMap = Maps.newHashMap();

    public static Class<? extends Gene<?>> getClass(ResourceLocation location) {
        return geneMap.get(location);
    }

    public static Collection<Class<? extends Gene<?>>> getGenes() {
        return geneMap.values();
    }

    public static Gene<?> load(CompoundTag tag) throws Exception {
        Gene<?> ret = null;
        ResourceLocation resource = new ResourceLocation(tag.m_128461_("K"));
        ret = geneMap.get(resource).getConstructor(new Class[0]).newInstance(new Object[0]);
        ret.load(tag);
        return ret;
    }

    public static void register(Class<? extends Gene<?>> gene) {
        try {
            Gene<?> temp = gene.getConstructor(new Class[0]).newInstance(new Object[0]);
            geneMap.put(temp.getKey(), gene);
        }
        catch (Exception e) {
            ThutCore.LOGGER.error("Error with registry of " + gene, (Throwable)e);
        }
    }

    public static CompoundTag save(Gene<?> gene) {
        CompoundTag tag = gene.save();
        tag.m_128359_("K", gene.getKey().toString());
        return tag;
    }
}

