/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.multipart;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import thut.api.maths.vecmath.Mat3f;
import thut.api.maths.vecmath.Vec3f;
import thut.core.common.ThutCore;
import thut.core.common.network.PacketPartInteract;

public abstract class GenericPartEntity<E extends Entity>
extends PartEntity<E> {
    public Vec3f r0;
    public float width;
    public float height;
    public Vec3f r;
    public final String f_19848_;

    public GenericPartEntity(E parent, float width, float height, float x, float y, float z, String id) {
        super(parent);
        this.f_19848_ = id;
        this.width = width;
        this.height = height;
        this.f_19815_ = EntityDimensions.m_20395_((float)width, (float)height);
        this.r0 = new Vec3f(x + width / 2.0f, y, z + width / 2.0f);
        this.r = new Vec3f(x, y, z);
    }

    public void update(Mat3f rot, Vec3f r, Vec3 dr) {
        this.r.set(this.r0.getX(), this.r0.getY(), this.r0.getZ());
        rot.transform(this.r);
        this.r.add(r);
        this.m_6034_(this.r.getX(), this.r.getY(), this.r.getZ());
        this.f_19790_ = this.m_20185_() + dr.f_82479_;
        this.f_19791_ = this.m_20186_() + dr.f_82480_;
        this.f_19792_ = this.m_20189_() + dr.f_82481_;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().f_46443_ && source.m_7640_() instanceof Player) {
            PacketPartInteract packet = new PacketPartInteract(this.f_19848_, this.getParent(), source.m_7640_().m_6144_());
            ThutCore.packets.sendToServer(packet);
        }
        return this.getParent().m_6469_(source, amount);
    }

    public boolean m_7306_(Entity entityIn) {
        return this == entityIn || this.getParent() == entityIn;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.f_19815_;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            PacketPartInteract packet = new PacketPartInteract(this.f_19848_, this.getParent(), hand, vec, player.m_6144_());
            ThutCore.packets.sendToServer(packet);
        }
        return this.getParent().m_7111_(player, vec, hand);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            PacketPartInteract packet = new PacketPartInteract(this.f_19848_, this.getParent(), hand, player.m_6144_());
            ThutCore.packets.sendToServer(packet);
        }
        return this.getParent().m_6096_(player, hand);
    }

    public boolean canRiderInteract() {
        return this.getParent().canRiderInteract();
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
    }

    public boolean m_7337_(Entity entity) {
        return super.m_7337_(entity);
    }

    public void m_6210_() {
        EntityDimensions entitysize1;
        EntityDimensions entitysize = this.f_19815_;
        Pose pose = this.m_20089_();
        EntityEvent.Size sizeEvent = ForgeEventFactory.getEntitySizeForge((Entity)this, (Pose)pose, (EntityDimensions)this.m_6972_(pose), (float)this.m_6380_(pose, entitysize));
        this.f_19815_ = entitysize1 = sizeEvent.getNewSize();
        if (entitysize1.f_20377_ < entitysize.f_20377_) {
            double d0 = (double)entitysize1.f_20377_ / 2.0;
            this.m_20011_(new AABB(this.m_20185_() - d0, this.m_20186_(), this.m_20189_() - d0, this.m_20185_() + d0, this.m_20186_() + (double)entitysize1.f_20378_, this.m_20189_() + d0));
        } else {
            AABB axisalignedbb = this.m_20191_();
            this.m_20011_(new AABB(axisalignedbb.f_82288_, axisalignedbb.f_82289_, axisalignedbb.f_82290_, axisalignedbb.f_82288_ + (double)entitysize1.f_20377_, axisalignedbb.f_82289_ + (double)entitysize1.f_20378_, axisalignedbb.f_82290_ + (double)entitysize1.f_20377_));
            if (entitysize1.f_20377_ > entitysize.f_20377_ && !this.f_19803_ && !this.f_19853_.f_46443_) {
                float f = entitysize.f_20377_ - entitysize1.f_20377_;
                this.m_6478_(MoverType.SELF, new Vec3((double)f, 0.0, (double)f));
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.getParent() == null) {
            return super.getCapability(cap, side);
        }
        return this.getParent().getCapability(cap, side);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (this.getParent() == null) {
            return super.getCapability(cap);
        }
        return this.getParent().getCapability(cap);
    }

    public static interface Factory<T extends GenericPartEntity<E>, E extends Entity> {
        public T create(E var1, float var2, float var3, float var4, float var5, float var6, String var7);
    }

    public static class BodyPart {
        public String name;
        public String offset;
        public String size;
        public String ride;
        public Vec3 __pos__;
        public Vec3 __size__;
        public Vec3 __ride__;

        public void onLoad() {
            String[] args = this.offset.split(",");
            this.__pos__ = new Vec3(Double.parseDouble(args[0]), Double.parseDouble(args[1]), Double.parseDouble(args[2]));
            args = this.size.split(",");
            this.__size__ = new Vec3(Double.parseDouble(args[0]), Double.parseDouble(args[1]), Double.parseDouble(args[2]));
            if (this.ride != null) {
                args = this.ride.split(",");
                this.__ride__ = new Vec3(Double.parseDouble(args[0]), Double.parseDouble(args[1]), Double.parseDouble(args[2]));
            }
        }
    }

    public static class BodyNode {
        public List<BodyPart> parts = Lists.newArrayList();

        public void onLoad() {
            this.parts.forEach(p -> p.onLoad());
        }
    }
}

