/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.multipart;

import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import thut.api.AnimatedCaps;
import thut.api.entity.IAnimated;
import thut.api.entity.multipart.GenericPartEntity;
import thut.api.maths.vecmath.Mat3f;
import thut.api.maths.vecmath.Vec3f;
import thut.core.common.ThutCore;
import thut.core.common.network.PartSync;

public interface IMultpart<T extends GenericPartEntity<E>, E extends Entity> {
    public PartHolder<T> getHolder();

    public void initParts();

    public GenericPartEntity.Factory<T, E> getFactory();

    public Class<T> getPartClass();

    default public E weSelf() {
        return (E)((Entity)this);
    }

    default public void checkUpdateParts() {
        if (this.getHolder().holder.tick != ((Entity)this.weSelf()).f_19797_) {
            this.getHolder().holder.tick = ((Entity)this.weSelf()).f_19797_;
            this.initParts();
        }
    }

    default public boolean sameMob(Entity entityIn) {
        PartEntity part;
        return this == entityIn || entityIn instanceof PartEntity && (part = (PartEntity)entityIn).getParent() == this;
    }

    default public T makePart(GenericPartEntity.BodyPart part, float size, Set<String> names) {
        float dx = (float)(part.__pos__.f_82479_ * (double)size);
        float dy = (float)(part.__pos__.f_82480_ * (double)size);
        float dz = (float)(part.__pos__.f_82481_ * (double)size);
        float sx = (float)(part.__size__.f_82479_ * (double)size);
        float sy = (float)(part.__size__.f_82480_ * (double)size);
        float sz = (float)(part.__size__.f_82481_ * (double)size);
        float dw = Math.max(sx, sz);
        float dh = sy;
        Object name = part.name;
        int n = 0;
        while (names.contains(name)) {
            name = part.name + n++;
        }
        return this.getFactory().create(this.weSelf(), dw, dh, dx, dy, dz, (String)name);
    }

    default public void addPart(String key, float size, GenericPartEntity.BodyNode node) {
        try {
            GenericPartEntity[] parts = (GenericPartEntity[])Array.newInstance(this.getPartClass(), node.parts.size());
            HashSet names = Sets.newHashSet();
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = this.makePart(node.parts.get(i), size, names);
                this.getHolder().allParts.add(parts[i]);
            }
            this.getHolder().partMap.put(key, (E[])parts);
        }
        catch (NegativeArraySizeException e) {
            ThutCore.LOGGER.error((Object)e);
        }
    }

    default public void updatePartsPos() {
        float f;
        this.initParts();
        IAnimated animHolder = AnimatedCaps.getAnimated(this.weSelf());
        if (animHolder != null) {
            List<String> anims = animHolder.getChoices();
            String old_pose = this.getHolder().holder.effective_pose;
            this.getHolder().holder().effective_pose = "idle";
            for (String s : anims) {
                if (!this.getHolder().partMap().containsKey(s)) continue;
                this.getHolder().holder().effective_pose = s;
                break;
            }
            if (!old_pose.equals(this.getHolder().holder().effective_pose) && this.getHolder().partMap().containsKey(this.getHolder().holder().effective_pose)) {
                this.getHolder().setParts((GenericPartEntity[])this.getHolder().partMap().get(this.getHolder().holder().effective_pose));
                PartSync.sendUpdate(this.weSelf());
            }
        }
        if (this.getHolder().holder().parts.length == 0 && this.getHolder().allParts().isEmpty()) {
            return;
        }
        Mat3f rot = this.getHolder().holder().rot;
        Vec3f r = this.getHolder().holder().r;
        Vec3 v = this.weSelf().m_20182_();
        r.set((float)v.m_7096_(), (float)v.m_7098_(), (float)v.m_7094_());
        Vec3 dr = new Vec3((double)r.x - ((Entity)this.weSelf()).f_19790_, (double)r.y - ((Entity)this.weSelf()).f_19791_, (double)r.z - ((Entity)this.weSelf()).f_19792_);
        E e = this.weSelf();
        if (e instanceof LivingEntity) {
            LivingEntity e2 = (LivingEntity)e;
            f = e2.f_20883_;
        } else {
            f = ((Entity)this.weSelf()).f_19857_;
        }
        float rotY = f;
        rot.rotY((float)Math.toRadians(180.0f - rotY));
        if (this.weSelf().isAddedToWorld()) {
            for (Object p : this.getHolder().holder().parts) {
                ((GenericPartEntity)((Object)p)).update(rot, r, dr);
            }
            if (((Entity)this.weSelf()).f_19797_ % 20 == 0) {
                PartSync.sendUpdate(this.weSelf());
            }
        } else {
            for (GenericPartEntity p : this.getHolder().allParts()) {
                p.update(rot, r, dr);
            }
        }
    }

    public record PartHolder<E extends GenericPartEntity<?>>(List<E> allParts, Map<String, E[]> partMap, Holder<E> holder) {
        public E[] makeAllParts(Class<E> partClass) {
            if (this.holder.allParts == null || this.holder.allParts.length != this.allParts.size()) {
                this.holder.allParts = (GenericPartEntity[])Array.newInstance(partClass, this.allParts.size());
                this.holder.allParts = (GenericPartEntity[])this.allParts.toArray(this.holder.allParts);
            }
            return this.holder.allParts;
        }

        public E[] getParts() {
            return this.holder.parts;
        }

        public void setParts(E[] parts) {
            this.holder.parts = parts;
        }

        public void clear() {
            this.allParts.clear();
            this.partMap.clear();
            this.holder.clear();
        }
    }

    public static class Holder<T extends GenericPartEntity<?>> {
        public float colWidth = 0.0f;
        public float colHeight = 0.0f;
        public float last_size = 0.0f;
        public T[] allParts;
        public T[] parts;
        public Mat3f rot = new Mat3f();
        public Vec3f r = new Vec3f();
        public String effective_pose = "";
        int tick = -1;

        public void clear() {
            this.allParts = null;
            this.parts = null;
        }
    }
}

