/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.multipart;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import thut.api.entity.multipart.GenericPartEntity;
import thut.api.entity.multipart.IMultpart;

public abstract class MultipartEntity<T extends GenericPartEntity<E>, E extends MultipartEntity<?, ?>>
extends Entity
implements IMultpart<T, E> {
    protected GenericPartEntity.Factory<T, E> factory;
    private IMultpart.PartHolder<T> holder;

    public MultipartEntity(EntityType<?> type, Level level) {
        super(type, level);
        ArrayList allParts = Lists.newArrayList();
        HashMap partMap = Maps.newHashMap();
        this.holder = new IMultpart.PartHolder(allParts, partMap, new IMultpart.Holder());
    }

    public boolean isMultipartEntity() {
        if (this.getHolder().getParts() == null) {
            this.initParts();
        }
        return this.getHolder().getParts().length > 0;
    }

    public T[] getParts() {
        this.checkUpdateParts();
        if (!this.isAddedToWorld()) {
            return this.getHolder().makeAllParts(this.getPartClass());
        }
        return this.getHolder().getParts();
    }

    public void setFactory(GenericPartEntity.Factory<T, E> factory) {
        this.factory = factory;
    }

    @Override
    public GenericPartEntity.Factory<T, E> getFactory() {
        return this.factory;
    }

    @Override
    public IMultpart.PartHolder<T> getHolder() {
        return this.holder;
    }
}

