/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.teleporting;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import thut.api.entity.teleporting.TeleLoadEvent;
import thut.api.maths.Vector3;
import thut.core.common.ThutCore;
import thut.lib.TComponent;

public class TeleDest {
    public GlobalPos loc;
    private Vector3 subLoc;
    private Vector3 teleLoc = new Vector3();
    private String name;
    public int index;
    public int version = 0;

    public static TeleDest readFromNBT(CompoundTag nbt) {
        Vector3 loc = Vector3.readFromNBT(nbt, "v");
        String name = nbt.m_128461_("name");
        int index = nbt.m_128451_("i");
        int version = nbt.m_128451_("_v_");
        GlobalPos pos = null;
        try {
            pos = (GlobalPos)((Pair)GlobalPos.f_122633_.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("pos")).result().get()).getFirst();
        }
        catch (Exception e) {
            ThutCore.LOGGER.error("Error loading value", (Throwable)e);
            return null;
        }
        TeleDest dest = new TeleDest().setLoc(pos, loc).setName(name).setIndex(index).setVersion(version);
        TeleLoadEvent event = new TeleLoadEvent(dest);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        return event.getOverride();
    }

    public TeleDest setLoc(GlobalPos loc, Vector3 subLoc) {
        this.loc = loc;
        this.subLoc = subLoc;
        this.name = "";
        return this;
    }

    public TeleDest setPos(GlobalPos pos) {
        if (pos != null) {
            this.loc = pos;
            this.subLoc = new Vector3().set((double)this.loc.m_122646_().m_123341_() + 0.5, this.loc.m_122646_().m_123342_(), (double)this.loc.m_122646_().m_123343_() + 0.5);
            this.name = "";
        }
        return this;
    }

    public TeleDest setVersion(int version) {
        this.version = version;
        return this;
    }

    public GlobalPos getPos() {
        return this.loc;
    }

    public Vector3 getLoc() {
        return this.subLoc;
    }

    public Vector3 getTeleLoc() {
        double dx = this.subLoc.x > 0.0 ? this.subLoc.x % 1.0 : -this.subLoc.x % 1.0;
        double dy = this.subLoc.y > 0.0 ? this.subLoc.y % 1.0 : -this.subLoc.y % 1.0;
        double dz = this.subLoc.z > 0.0 ? this.subLoc.z % 1.0 : -this.subLoc.z % 1.0;
        return this.teleLoc.set(this.getPos().m_122646_()).add(dx, dy, dz);
    }

    public String getName() {
        return this.name;
    }

    public TeleDest setIndex(int index) {
        this.index = index;
        return this;
    }

    public TeleDest setName(String name) {
        this.name = name;
        return this;
    }

    public void writeToNBT(CompoundTag nbt) {
        if (this.subLoc == null) {
            this.subLoc = new Vector3().set(this.loc.m_122646_()).add(0.5, 0.0, 0.5);
        }
        this.subLoc.writeToNBT(nbt, "v");
        nbt.m_128365_("pos", (Tag)GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.loc).get().left().get());
        nbt.m_128359_("name", this.name);
        nbt.m_128405_("i", this.index);
        nbt.m_128405_("_v_", this.version);
    }

    public void shift(double dx, int dy, double dz) {
        this.subLoc.x += dx;
        this.subLoc.y += (double)dy;
        this.subLoc.z += dz;
    }

    public Component getInfoName() {
        return TComponent.translatable("teledest.location", this.loc.m_122646_().m_123341_(), this.loc.m_122646_().m_123342_(), this.loc.m_122646_().m_123343_(), this.loc.m_122640_().m_135782_());
    }

    public boolean withinDist(TeleDest other, double dist) {
        if (other.loc.m_122640_() == this.loc.m_122640_()) {
            return other.loc.m_122646_().m_123314_((Vec3i)this.loc.m_122646_(), dist);
        }
        return false;
    }
}

