/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.teleporting;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.entity.teleporting.TeleDest;
import thut.api.entity.teleporting.TeleEvent;
import thut.api.maths.Vector3;

public class ThutTeleporter {
    public static void transferTo(Entity entity, TeleDest dest) {
        ThutTeleporter.transferTo(entity, dest, false);
    }

    public static void transferTo(Entity entity, TeleDest dest, boolean sound) {
        if (entity.m_9236_() instanceof ServerLevel) {
            new InvulnTicker(entity);
            if (dest.loc.m_122640_() == entity.f_19853_.m_46472_()) {
                ThutTeleporter.moveMob(entity, dest);
                return;
            }
            ServerLevel destWorld = entity.m_20194_().m_129880_(dest.loc.m_122640_());
            if (destWorld != null) {
                new TransferTicker(destWorld, entity, dest, sound);
            }
        }
    }

    private static void transferMob(ServerLevel destWorld, TeleDest dest, Entity entity) {
        ServerPlayer player = null;
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            player.f_8927_ = true;
        }
        ServerLevel serverworld = (ServerLevel)entity.m_9236_();
        List passengers = entity.m_20197_();
        entity.m_20153_();
        for (int i = 0; i < passengers.size(); ++i) {
            Entity e = (Entity)passengers.get(i);
            e.getPersistentData().m_128379_("thutcore:dimtp", true);
            ThutTeleporter.transferTo(e, dest);
            e.getPersistentData().m_128473_("thutcore:dimtp");
            new RemountTicker(entity.m_20148_(), e.m_20148_(), i, destWorld);
        }
        ThutTeleporter.removeMob(serverworld, entity, true);
        entity.revive();
        entity.m_7678_(dest.getTeleLoc().x, dest.getTeleLoc().y, dest.getTeleLoc().z, entity.f_19857_, entity.f_19858_);
        entity.f_19853_ = destWorld;
        ThutTeleporter.addMob(destWorld, entity);
        if (player != null) {
            player.f_8927_ = false;
            player.f_8906_.m_9953_();
            player.f_8906_.m_9774_(dest.getTeleLoc().x, dest.getTeleLoc().y, dest.getTeleLoc().z, entity.f_19857_, entity.f_19858_);
        }
    }

    private static void addMob(ServerLevel world, Entity entity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinLevelEvent(entity, (Level)world))) {
            return;
        }
        ChunkAccess ichunk = world.m_6522_(Mth.m_14107_((double)(entity.m_20185_() / 16.0)), Mth.m_14107_((double)(entity.m_20189_() / 16.0)), ChunkStatus.f_62326_, true);
        if (ichunk instanceof LevelChunk) {
            ichunk.m_6286_(entity);
        }
        world.m_143334_(entity);
    }

    private static void removeMob(ServerLevel world, Entity entity, boolean keepData) {
        entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
    }

    private static void moveMob(Entity entity, TeleDest dest) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            double targetX = dest.getTeleLoc().x;
            double targetY = dest.getTeleLoc().y;
            double targetZ = dest.getTeleLoc().z;
            TeleEvent event = TeleEvent.onUseTeleport(living, targetX, targetY, targetZ);
            if (event.isCanceled()) {
                return;
            }
            targetX = event.getTargetX();
            targetY = event.getTargetY();
            targetZ = event.getTargetZ();
            dest = new TeleDest().setLoc(GlobalPos.m_122643_((ResourceKey)dest.getPos().m_122640_(), (BlockPos)new BlockPos(targetX, targetY, targetZ)), new Vector3().set(targetX, targetY, targetZ));
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.f_8927_ = true;
            player.f_8906_.m_9774_(dest.getTeleLoc().x, dest.getTeleLoc().y, dest.getTeleLoc().z, entity.f_19857_, entity.f_19858_);
            player.f_8906_.m_9953_();
            player.f_8927_ = false;
        } else {
            entity.m_6021_(dest.getTeleLoc().x, dest.getTeleLoc().y, dest.getTeleLoc().z);
        }
    }

    private static class InvulnTicker {
        private final ServerLevel overworld;
        private final Entity entity;
        private final long start;

        public InvulnTicker(Entity entity) {
            this.entity = entity;
            this.overworld = entity.m_20194_().m_129880_(Level.f_46428_);
            this.start = this.overworld.m_46467_();
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void damage(LivingHurtEvent event) {
            if (!event.getEntity().m_20148_().equals(this.entity.m_20148_())) {
                return;
            }
            long time = this.overworld.m_46467_();
            if (time - this.start > 20L) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                return;
            }
            event.setCanceled(true);
        }
    }

    private static class TransferTicker {
        private final Entity entity;
        private final ServerLevel destWorld;
        private final TeleDest dest;
        private final boolean sound;

        public TransferTicker(ServerLevel destWorld, Entity entity, TeleDest dest, boolean sound) {
            this.entity = entity;
            this.dest = dest;
            this.sound = sound;
            this.destWorld = destWorld;
            boolean inTick = destWorld.m_8874_();
            if (inTick) {
                MinecraftForge.EVENT_BUS.register((Object)this);
            } else if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8927_ = true;
                player.m_8999_(destWorld, dest.getTeleLoc().x, dest.getTeleLoc().y, dest.getTeleLoc().z, entity.f_19857_, entity.f_19858_);
                if (sound) {
                    destWorld.m_7785_(dest.getTeleLoc().x, dest.getTeleLoc().y, dest.getTeleLoc().z, SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
                player.f_8927_ = false;
            } else {
                ThutTeleporter.transferMob(this.destWorld, this.dest, this.entity);
                if (this.sound) {
                    this.destWorld.m_7785_(this.dest.getTeleLoc().x, this.dest.getTeleLoc().y, this.dest.getTeleLoc().z, SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    this.entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
        }

        @SubscribeEvent
        public void tickEvent(TickEvent.LevelTickEvent event) {
            if (event.level == this.entity.m_9236_() && event.phase == TickEvent.Phase.END) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                Entity entity = this.entity;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.f_8927_ = true;
                    player.m_8999_(this.destWorld, this.dest.getTeleLoc().x, this.dest.getTeleLoc().y, this.dest.getTeleLoc().z, this.entity.f_19857_, this.entity.f_19858_);
                    if (this.sound) {
                        this.destWorld.m_7785_(this.dest.getTeleLoc().x, this.dest.getTeleLoc().y, this.dest.getTeleLoc().z, SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                        player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    }
                    player.f_8927_ = false;
                } else {
                    ThutTeleporter.transferMob(this.destWorld, this.dest, this.entity);
                    if (this.sound) {
                        this.destWorld.m_7785_(this.dest.getTeleLoc().x, this.dest.getTeleLoc().y, this.dest.getTeleLoc().z, SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                        this.entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private static class RemountTicker {
        private final UUID mount;
        private final UUID rider;
        final int index;
        private final ServerLevel world;
        int n = 0;

        public RemountTicker(UUID mount, UUID rider, int index, ServerLevel world) {
            this.mount = mount;
            this.rider = rider;
            this.world = world;
            this.index = index;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void TickEvent(TickEvent.LevelTickEvent event) {
            if (event.level != this.world) {
                return;
            }
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (this.n++ > 20) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
            Entity mount = this.world.m_8791_(this.mount);
            Entity rider = this.world.m_8791_(this.rider);
            if (mount != null && rider != null) {
                --this.n;
                int num = mount.m_20197_().size();
                if (num == this.index) {
                    rider.m_7998_(mount, true);
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                }
            }
        }
    }
}

