/*
 * Decompiled with CFR 0.152.
 */
package thut.api.inventory;

import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import thut.api.ThutCaps;
import thut.api.item.ItemList;

public class InvHelper {
    public static void load(Container inven, CompoundTag tag) {
        ListTag listnbt = tag.m_128437_("Items", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= inven.m_6643_()) continue;
            inven.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
    }

    public static void save(Container inven, CompoundTag tag) {
        ListTag listnbt = new ListTag();
        for (int i = 0; i < inven.m_6643_(); ++i) {
            ItemStack itemstack = inven.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        tag.m_128365_("Items", (Tag)listnbt);
    }

    public static class ItemCap
    extends ItemStackHandler
    implements ICapabilitySerializable<CompoundTag> {
        private final int stackSize;
        private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this);
        private final ResourceLocation mask;
        public Predicate<ItemStack> stackCheck = s -> true;

        public ItemCap(int slotCount, int stackSize) {
            this(slotCount, stackSize, null);
        }

        public ItemCap(int slotCount, int stackSize, ResourceLocation mask) {
            super(slotCount);
            this.stackSize = stackSize;
            this.mask = mask;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (this.mask != null) {
                return ItemList.is(this.mask, stack) && this.stackCheck.test(stack);
            }
            return super.isItemValid(slot, stack) && this.stackCheck.test(stack);
        }

        public int getSlotLimit(int slot) {
            return this.stackSize;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            return ThutCaps.ITEM_HANDLER.orEmpty(capability, this.holder);
        }
    }
}

