/*
 * Decompiled with CFR 0.152.
 */
package thut.api.inventory.big;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import thut.api.inventory.big.Manager;

public abstract class BigInventory
implements Container,
INBTSerializable<CompoundTag> {
    UUID id;
    int page = 0;
    private final boolean isReal;
    private boolean loading = false;
    public boolean dirty = false;
    public boolean[] opened;
    public String[] boxes;
    Manager<? extends BigInventory> manager;
    private final Int2ObjectOpenHashMap<ItemStack> contents = new Int2ObjectOpenHashMap();

    public BigInventory(Manager<? extends BigInventory> manager, UUID id) {
        this.boxes = new String[this.boxCount()];
        for (int i = 0; i < this.boxCount(); ++i) {
            this.boxes[i] = "Box " + String.valueOf(i + 1);
        }
        this.opened = new boolean[this.boxCount()];
        this.id = id;
        this.contents.defaultReturnValue((Object)ItemStack.f_41583_);
        this.manager = manager;
        this.isReal = true;
    }

    public BigInventory(Manager<? extends BigInventory> manager, CompoundTag tag) {
        this.boxes = new String[this.boxCount()];
        for (int i = 0; i < this.boxCount(); ++i) {
            this.boxes[i] = "Box " + String.valueOf(i + 1);
        }
        this.opened = new boolean[this.boxCount()];
        this.contents.defaultReturnValue((Object)ItemStack.f_41583_);
        this.manager = manager;
        this.deserializeNBT(tag);
        this.isReal = true;
    }

    public BigInventory(Manager<? extends BigInventory> manager, FriendlyByteBuf buffer) {
        this.boxes = new String[this.boxCount()];
        for (int i = 0; i < this.boxCount(); ++i) {
            this.boxes[i] = "Box " + String.valueOf(i + 1);
        }
        this.opened = new boolean[this.boxCount()];
        this.contents.defaultReturnValue((Object)ItemStack.f_41583_);
        this.manager = manager;
        if (buffer != null) {
            this.deserializeNBT(buffer.m_130260_());
        }
        this.isReal = false;
    }

    public FriendlyByteBuf makeBuffer() {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer((int)0));
        CompoundTag boxInfo = new CompoundTag();
        this.serializeBoxInfo(boxInfo);
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("boxes", (Tag)boxInfo);
        tag.m_128379_("Real", false);
        buffer.m_130079_(tag);
        return buffer;
    }

    public void addItem(ItemStack stack) {
        int i;
        for (i = this.getPage() * 54; i < this.m_6643_(); ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            this.m_6836_(i, stack);
            return;
        }
        for (i = 0; i < this.getPage() * 54; ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            this.m_6836_(i, stack);
            return;
        }
    }

    public abstract int boxCount();

    public void m_6211_() {
        this.contents.clear();
    }

    public void m_5785_(Player player) {
        if (this.isReal) {
            this.manager.save(this.id);
        }
    }

    public ItemStack m_7407_(int i, int j) {
        if (!((ItemStack)this.contents.get(i)).m_41619_()) {
            ItemStack itemstack = ((ItemStack)this.contents.get(i)).m_41620_(j);
            if (((ItemStack)this.contents.get(i)).m_41619_()) {
                this.contents.remove(i);
            }
            if (this.isReal && !this.loading) {
                this.dirty = true;
                this.manager.save(this.id);
                this.dirty = false;
            }
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void deserializeBox(CompoundTag nbt) {
        int start;
        this.loading = true;
        for (int i = start = nbt.m_128451_("box") * 54; i < start + 54; ++i) {
            CompoundTag CompoundNBT;
            short j;
            this.m_6836_(i, ItemStack.f_41583_);
            if (!nbt.m_128441_("item" + i) || (j = (CompoundNBT = nbt.m_128469_("item" + i)).m_128448_("Slot")) < start || j >= start + 54) continue;
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)CompoundNBT);
            this.m_6836_(j, itemstack);
        }
        this.loading = false;
    }

    public void deserializeBoxInfo(CompoundTag boxes) {
        String id = boxes.m_128461_("UUID");
        this.id = UUID.fromString(id);
        for (int k = 0; k < this.boxCount(); ++k) {
            if (k == 0) {
                this.setPage(boxes.m_128451_("page"));
            }
            if (boxes.m_128461_("name" + k) == null) continue;
            this.boxes[k] = boxes.m_128461_("name" + k);
        }
    }

    public void deserializeItems(CompoundTag nbt) {
        this.contents.clear();
        for (String key : nbt.m_128431_()) {
            if (!key.startsWith("item")) continue;
            CompoundTag CompoundNBT = nbt.m_128469_(key);
            short j = CompoundNBT.m_128448_("Slot");
            this.loading = true;
            if (j >= 0 && j < this.m_6643_()) {
                if (this.contents.containsKey((int)j)) continue;
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)CompoundNBT);
                this.m_6836_(j, itemstack);
            }
            this.loading = false;
        }
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag boxes = nbt.m_128469_("boxes");
        this.deserializeBoxInfo(boxes);
        this.deserializeItems(nbt);
    }

    public ItemStack m_8020_(int i) {
        ItemStack stack = (ItemStack)this.contents.get(i);
        if (stack.m_41619_()) {
            stack = ItemStack.f_41583_;
        }
        return stack;
    }

    public boolean m_7983_() {
        return true;
    }

    public UUID getOwner() {
        return this.id;
    }

    public boolean m_7013_(int par1, ItemStack stack) {
        return this.manager.isItemValid(stack);
    }

    public boolean m_6542_(Player PlayerEntity) {
        return true;
    }

    public void m_6596_() {
    }

    public void m_5856_(Player player) {
    }

    public ItemStack m_8016_(int i) {
        ItemStack stack = (ItemStack)this.contents.remove(i);
        if (stack.m_41619_()) {
            stack = ItemStack.f_41583_;
        }
        return stack;
    }

    public CompoundTag serializeBox(int box) {
        int start;
        CompoundTag items = new CompoundTag();
        items.m_128405_("box", box);
        for (int i = start = box * 54; i < start + 54; ++i) {
            ItemStack itemstack = this.m_8020_(i);
            CompoundTag CompoundNBT = new CompoundTag();
            if (itemstack.m_41619_()) continue;
            CompoundNBT.m_128376_("Slot", (short)i);
            itemstack.m_41739_(CompoundNBT);
            items.m_128365_("item" + i, (Tag)CompoundNBT);
        }
        return items;
    }

    public void serializeBoxInfo(CompoundTag boxes) {
        boxes.m_128359_("UUID", this.id.toString());
        boxes.m_128405_("page", this.page);
        for (int i = 0; i < this.boxCount(); ++i) {
            boxes.m_128359_("name" + i, this.boxes[i]);
        }
    }

    public void serializeItems(CompoundTag items) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            CompoundTag CompoundNBT = new CompoundTag();
            if (itemstack.m_41619_()) continue;
            CompoundNBT.m_128376_("Slot", (short)i);
            itemstack.m_41739_(CompoundNBT);
            items.m_128365_("item" + i, (Tag)CompoundNBT);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag items = new CompoundTag();
        CompoundTag boxes = new CompoundTag();
        this.serializeBoxInfo(boxes);
        this.serializeItems(items);
        items.m_128365_("boxes", (Tag)boxes);
        return items;
    }

    public int m_6643_() {
        return this.boxCount() * 54;
    }

    public int getPage() {
        return this.page;
    }

    public void m_6836_(int i, ItemStack itemstack) {
        ItemStack old = (ItemStack)this.contents.get(i);
        if (!itemstack.m_41619_()) {
            this.contents.put(i, (Object)itemstack);
        } else {
            this.contents.remove(i);
        }
        if (!old.equals(itemstack) && this.isReal && !this.loading) {
            this.dirty = true;
            this.manager.save(this.id);
            this.dirty = false;
        }
    }

    public void setPage(int page) {
        this.page = page;
    }

    public static interface LoadFactory<T> {
        public T create(Manager<?> var1, CompoundTag var2);
    }

    public static interface NewFactory<T> {
        public T create(Manager<?> var1, UUID var2);
    }
}

