/*
 * Decompiled with CFR 0.152.
 */
package thut.api.inventory.big;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.inventory.big.BigInventory;
import thut.core.common.ThutCore;
import thut.core.common.handlers.PlayerDataHandler;

public abstract class Manager<T extends BigInventory> {
    protected Map<UUID, T> _map = Maps.newHashMap();
    private final Predicate<ItemStack> valid;
    private final BigInventory.NewFactory<T> new_factory;
    private final BigInventory.LoadFactory<T> load_factory;

    public Manager(Predicate<ItemStack> valid, BigInventory.NewFactory<T> new_factory, BigInventory.LoadFactory<T> load_factory) {
        this.valid = valid;
        this.new_factory = new_factory;
        this.load_factory = load_factory;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public abstract String fileName();

    public abstract String tagID();

    protected void load(UUID uuid) {
        if (ThutCore.proxy.isClientSide()) {
            return;
        }
        try {
            File file = PlayerDataHandler.getFileForUUID(uuid.toString(), this.fileName());
            if (file != null && file.exists()) {
                FileInputStream fileinputstream = new FileInputStream(file);
                CompoundTag CompoundNBT = NbtIo.m_128939_((InputStream)fileinputstream);
                fileinputstream.close();
                this.loadNBT(CompoundNBT.m_128469_("Data"));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadNBT(CompoundTag nbt) {
        Tag temp = nbt.m_128423_(this.tagID());
        if (temp instanceof ListTag) {
            ListTag tagListPC = (ListTag)temp;
            for (int i = 0; i < tagListPC.size(); ++i) {
                CompoundTag items = tagListPC.m_128728_(i);
                BigInventory load = (BigInventory)this.load_factory.create(this, items);
                this._map.put(load.id, load);
            }
        }
    }

    protected void save(UUID uuid) {
        if (ThutCore.proxy.isClientSide()) {
            return;
        }
        T save = this.get(uuid, false);
        if (save == null || !((BigInventory)save).dirty) {
            return;
        }
        MinecraftServer server = ThutCore.proxy.getServer();
        try {
            File file = PlayerDataHandler.getFileForUUID(uuid.toString(), this.fileName());
            if (file != null) {
                CompoundTag CompoundNBT = new CompoundTag();
                this.writeToNBT(CompoundNBT, save);
                CompoundTag CompoundNBT1 = new CompoundTag();
                CompoundNBT1.m_128365_("Data", (Tag)CompoundNBT);
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                NbtIo.m_128947_((CompoundTag)CompoundNBT1, (OutputStream)fileoutputstream);
                fileoutputstream.close();
                if (server.m_6846_().m_11259_(uuid) == null) {
                    this._map.remove(uuid);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToNBT(CompoundTag nbt, T save) {
        ListTag nbttag = new ListTag();
        CompoundTag items = ((BigInventory)save).serializeNBT();
        nbttag.add((Object)items);
        nbt.m_128365_(this.tagID(), (Tag)nbttag);
    }

    public T get(Entity mob) {
        return this.get(mob.m_20148_());
    }

    public T get(UUID id, boolean create) {
        if (!this._map.containsKey(id) && create) {
            this.load(id);
            if (!this._map.containsKey(id)) {
                this._map.put(id, (BigInventory)this.new_factory.create(this, id));
            }
        }
        return (T)((BigInventory)this._map.get(id));
    }

    public T get(UUID id) {
        return this.get(id, true);
    }

    public void clear() {
        this._map.clear();
    }

    @SubscribeEvent
    protected void serverStarting(ServerAboutToStartEvent event) {
        this.clear();
    }

    boolean isItemValid(ItemStack stack) {
        return this.valid.test(stack);
    }
}

