/*
 * Decompiled with CFR 0.152.
 */
package thut.api.item;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import thut.lib.RegHelper;

public class ItemList
extends Items {
    public static Map<ResourceLocation, Set<Item>> pendingTags = Maps.newHashMap();
    private static Map<ResourceLocation, TagKey<EntityType<?>>> E_TAGS = Maps.newConcurrentMap();
    private static Map<ResourceLocation, TagKey<Item>> I_TAGS = Maps.newConcurrentMap();
    private static Map<ResourceLocation, TagKey<Block>> B_TAGS = Maps.newConcurrentMap();

    public static boolean is(ResourceLocation tag, EntityType<?> type) {
        TagKey tagkey = E_TAGS.computeIfAbsent(tag, l -> TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)l));
        boolean tagged = type.m_204039_(tagkey);
        if (!tagged) {
            return RegHelper.getKey(type).equals((Object)tag);
        }
        return tagged;
    }

    public static boolean is(ResourceLocation tag, Entity toCheck) {
        return ItemList.is(tag, toCheck.m_6095_());
    }

    public static boolean is(ResourceLocation tag, BlockState toCheck) {
        TagKey tagkey = B_TAGS.computeIfAbsent(tag, l -> TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)l));
        boolean tagged = toCheck.m_204336_(tagkey);
        if (!tagged) {
            return RegHelper.getKey(toCheck.m_60734_()).equals((Object)tag);
        }
        return tagged;
    }

    public static boolean is(ResourceLocation tag, Block toCheck) {
        return ItemList.is(tag, toCheck.m_49966_());
    }

    public static boolean is(ResourceLocation tag, ItemStack stack) {
        TagKey tagkey = I_TAGS.computeIfAbsent(tag, l -> TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)l));
        boolean tagged = stack.m_204117_(tagkey);
        boolean bl = tagged = tagged || pendingTags.getOrDefault(tag, Collections.emptySet()).contains(stack.m_41720_());
        if (!tagged) {
            return RegHelper.getKey(stack).equals((Object)tag);
        }
        return tagged;
    }

    public static boolean is(ResourceLocation tag, Item toCheck) {
        return ItemList.is(tag, new ItemStack((ItemLike)toCheck));
    }
}

