/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import thut.api.maths.Vector3;

public class Cruncher {
    private static short[][] CUBECACHE;
    private static short[][] SPHERECACHE;
    public static int[][] RADII;
    public static int maxSphereR;
    public static boolean useCache;

    public static void init() {
        if (useCache) {
            return;
        }
        CUBECACHE = new short[0x200000][];
        Vector3 temp = new Vector3();
        for (int i = 0; i < CUBECACHE.length; ++i) {
            short[] var = new short[3];
            Cruncher.indexToVals(i, temp, true);
            var[0] = (short)temp.intX();
            var[1] = (short)temp.intY();
            var[2] = (short)temp.intZ();
            Cruncher.CUBECACHE[i] = var;
        }
        SPHERECACHE = new short[0x1000000][];
        IntOpenHashSet added = new IntOpenHashSet(0x1000000);
        double radius = 0.25;
        double C = 3.809;
        double area = Math.PI * 4 * radius * radius;
        float grid = 0.5f;
        float N = (float)Math.ceil(area / 0.5);
        int n = 0;
        while (n < SPHERECACHE.length) {
            int[] rads = RADII[(int)radius];
            if (rads[0] == 0 && n != 0) {
                rads[0] = n;
            }
            float phi_k_1 = 0.0f;
            int k = 1;
            while ((float)k <= N) {
                float phi_k;
                float h_k = -1.0f + (float)(2 * (k - 1)) / (N - 1.0f);
                float sin_theta = (float)Math.sqrt(1.0f - h_k * h_k);
                phi_k_1 = phi_k = (float)(k > 1 && (float)k < N ? ((double)phi_k_1 + 3.809 / Math.sqrt(N * (1.0f - h_k * h_k))) % (Math.PI * 2) : 0.0);
                double x = (double)(sin_theta * Mth.m_14089_((float)phi_k)) * radius;
                double y = (double)h_k * radius;
                double z = (double)(sin_theta * Mth.m_14031_((float)phi_k)) * radius;
                temp.set(x, y, z);
                int index = Cruncher.getVectorInt(temp);
                if (added.add(index)) {
                    temp.set(x, y, z);
                    short[] var = new short[3];
                    Cruncher.SPHERECACHE[n++] = var;
                    var[0] = (short)temp.intX();
                    var[1] = (short)temp.intY();
                    var[2] = (short)temp.intZ();
                    maxSphereR = (int)radius;
                    if (n >= SPHERECACHE.length) break;
                }
                ++k;
            }
            rads[1] = n - 1;
            area = Math.PI * 4 * (radius += 0.5) * radius;
            N = (float)Math.ceil(area / 0.5);
        }
        useCache = true;
    }

    public static double cubeRoot(double num) {
        return Math.pow(num, 0.3333333333333333);
    }

    public static int getVectorInt(Vector3 rHat) {
        if (rHat.magSq() > 261121.0) {
            new Exception().printStackTrace();
            return 0;
        }
        int i = rHat.intX() + 512;
        int j = rHat.intY() + 512;
        int k = rHat.intZ() + 512;
        return i + (j << 10) + (k << 20);
    }

    public static long getVectorLong(Vector3 rHat) {
        return rHat.getPos().m_121878_();
    }

    public static void indexToVals(int radius, int index, int diffSq, int diffCb, Vector3 toFill) {
        int temp;
        toFill.x = 0.0;
        toFill.y = 0.0;
        toFill.z = 0.0;
        int layerSize = (2 * radius + 1) * (2 * radius + 1);
        if (index == 0) {
            toFill.x = -radius;
            toFill.y = radius;
            toFill.z = -radius;
            return;
        }
        if (index >= layerSize && index < diffCb - layerSize) {
            temp = (index - layerSize) / diffSq + 1;
            temp = (temp -= radius) > radius ? radius : (temp < -radius ? -radius : temp);
            toFill.y = temp;
        } else {
            toFill.y = index > layerSize ? (double)(-radius) : (double)radius;
        }
        if (toFill.y != (double)radius && toFill.y != (double)(-radius)) {
            temp = index % diffSq;
            if (temp < diffSq / 2) {
                toFill.x = temp < radius ? (double)temp : (temp > diffSq / 2 - radius ? (double)(-(temp - diffSq / 2)) : (double)radius);
            } else if (temp > diffSq / 2) {
                toFill.x = (temp -= diffSq / 2) < radius ? (double)(-temp) : (temp > diffSq / 2 - radius ? (double)(temp - diffSq / 2) : (double)(-radius));
            }
        } else {
            temp = index % layerSize;
            temp %= 2 * radius + 1;
            toFill.x = temp -= radius;
        }
        if (toFill.y != (double)radius && toFill.y != (double)(-radius)) {
            temp = index % diffSq;
            if ((temp = (temp + 2 * radius - 1) % diffSq + 1) < diffSq / 2) {
                toFill.z = temp < radius ? (double)temp : (temp > diffSq / 2 - radius ? (double)(-(temp - diffSq / 2)) : (double)radius);
            } else if (temp > diffSq / 2) {
                toFill.z = (temp -= diffSq / 2) < radius ? (double)(-temp) : (temp > diffSq / 2 - radius ? (double)(temp - diffSq / 2) : (double)(-radius));
            }
        } else {
            temp = index % layerSize / (2 * radius + 1);
            toFill.z = temp -= radius;
        }
    }

    public static void indexToVals(int index, Vector3 toFill) {
        if (index > 0) {
            if (useCache && index < CUBECACHE.length) {
                toFill.set((Object)CUBECACHE[index]);
                return;
            }
            int cr = (int)Math.floor(Cruncher.cubeRoot(index));
            int temp = 2 * (cr = (cr - 1) / 2 + 1) - 1;
            int crc = temp * temp * temp;
            if (crc > 2) {
                ++crc;
            }
            int si = index - crc;
            int crs = temp * temp;
            temp = 2 * (cr + 1) - 1;
            int nrs = temp * temp;
            int rsd = nrs - crs;
            int rcd = 24 * cr * cr + 2;
            Cruncher.indexToVals(cr, si, rsd, rcd, toFill);
        } else {
            toFill.z = 0.0;
            toFill.y = 0.0;
            toFill.x = 0.0;
        }
    }

    public static void indexToVals(int index, Vector3 toFill, boolean cube) {
        if (cube || !useCache || index >= SPHERECACHE.length) {
            Cruncher.indexToVals(index, toFill);
        } else if (index < SPHERECACHE.length) {
            toFill.set((Object)SPHERECACHE[index]);
        }
    }

    static {
        RADII = new int[1024][2];
        maxSphereR = 0;
        useCache = false;
    }

    public static class SquareLoopCruncher {
        public int _radius = 0;
        int _side = 0;
        int _q = 0;
        boolean started = false;

        private void initNext(int radius) {
            this._side %= 4;
            switch (this._side) {
                case 0: {
                    this._radius = radius;
                    this._q = -this._radius + 1;
                    break;
                }
                case 1: {
                    this._radius = radius;
                    this._q = this._radius - 1;
                    break;
                }
                case 2: {
                    this._radius = radius;
                    this._q = this._radius - 1;
                    break;
                }
                case 3: {
                    this._radius = radius;
                    this._q = -this._radius + 1;
                }
            }
        }

        public void reset() {
            this._radius = 0;
            this._side = 0;
            this._q = 0;
            this.started = false;
        }

        public BlockPos getNext(BlockPos mid, int dr) {
            if (!this.started) {
                this.started = true;
                return mid;
            }
            switch (this._side) {
                case 0: {
                    mid = mid.m_7918_(this._radius * dr, 0, this._q * dr);
                    ++this._q;
                    if (this._q <= this._radius) break;
                    ++this._side;
                    this.initNext(this._radius);
                    break;
                }
                case 1: {
                    mid = mid.m_7918_(this._q * dr, 0, this._radius * dr);
                    --this._q;
                    if (this._q >= -this._radius) break;
                    ++this._side;
                    this.initNext(this._radius);
                    break;
                }
                case 2: {
                    mid = mid.m_7918_(-this._radius * dr, 0, this._q * dr);
                    --this._q;
                    if (this._q >= -this._radius) break;
                    ++this._side;
                    this.initNext(this._radius);
                    break;
                }
                case 3: {
                    mid = mid.m_7918_(this._q * dr, 0, -this._radius * dr);
                    ++this._q;
                    if (this._q <= this._radius) break;
                    ++this._side;
                    ++this._radius;
                    this.initNext(this._radius);
                }
            }
            return mid;
        }
    }
}

