/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction8;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.entity.PartEntity;
import thut.core.common.ThutCore;
import thut.lib.RegHelper;

public class Vector3 {
    public static final Vector3 secondAxis = new Vector3().set(0.0, 1.0, 0.0);
    public static final Vector3 secondAxisNeg = new Vector3().set(0.0, -1.0, 0.0);
    public static final Vector3 firstAxis = new Vector3().set(1.0, 0.0, 0.0);
    public static final Vector3 firstAxisNeg = new Vector3().set(-1.0, 0.0, 0.0);
    public static final Vector3 thirdAxis = new Vector3().set(0.0, 0.0, 1.0);
    public static final Vector3 thirdAxisNeg = new Vector3().set(0.0, 0.0, -1.0);
    public static final Vector3 empty = new Vector3();
    public static final int length = 3;
    public static Vector3 vecMult = new Vector3();
    public static double[][] rotBox = new double[3][3];
    static Vector3 move1 = new Vector3();
    static Vector3 move2 = new Vector3();
    private static FakePlayer USEDFORRAYTRACECONTEXT = null;
    private static final UUID PLAYERID = new UUID(1234567L, 7324156L);
    private static final GameProfile FAKEPLAYER = new GameProfile(PLAYERID, "raytrace-context");
    public double x;
    public double y;
    public double z;
    BlockPos.MutableBlockPos pos;

    public static Vector3 entity(Entity e) {
        if (e != null) {
            return new Vector3().set(e.m_20185_(), e.m_20186_() + (double)e.m_20192_(), e.m_20189_());
        }
        return null;
    }

    public static Vector3 findMidPoint(List<Vector3> points) {
        Vector3 mid = new Vector3();
        for (Vector3 point : points) {
            mid.addTo(point);
        }
        if (points.size() > 0) {
            mid.scalarMultBy(1.0 / (double)points.size());
        }
        return mid;
    }

    public static Vector3 findNextSolidBlock(BlockGetter world, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        double xprev = source.x;
        double yprev = source.y;
        double zprev = source.z;
        Vector3 test = new Vector3();
        for (double i = 0.0; i < range; i += 1.0) {
            double dx = i * direction.x;
            double dy = i * direction.y;
            double dz = i * direction.z;
            double xtest = source.x + dx;
            double ytest = source.y + dy;
            double ztest = source.z + dz;
            if (ytest > (double)world.m_151558_() || ytest < (double)world.m_141937_()) {
                return null;
            }
            if (Vector3.Int(xtest) != Vector3.Int(xprev) || Vector3.Int(ytest) != Vector3.Int(yprev) || Vector3.Int(ztest) != Vector3.Int(zprev)) {
                test.set(xtest, ytest, ztest);
                boolean clear = test.isClearOfBlocks(world);
                if (!clear) {
                    return new Vector3().set(Vector3.Int(xtest), Vector3.Int(ytest), Vector3.Int(ztest));
                }
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    public static Vector3 getNextSurfacePoint(BlockGetter world, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (double i = 0.0; i < range; i += 0.0625) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isPointClearBlocks_internal(xtest, ytest - dy, ztest - dz, world, pos);
            check = check && Vector3.isPointClearBlocks_internal(xtest - dx, ytest, ztest - dz, world, pos);
            boolean bl = check = check && Vector3.isPointClearBlocks_internal(xtest - dx, ytest - dy, ztest, world, pos);
            if (check) continue;
            return new Vector3().set(xtest, ytest, ztest);
        }
        return null;
    }

    public static boolean isPointClearBlocks_internal(double x, double y, double z, BlockGetter world, BlockPos.MutableBlockPos pos) {
        int x0 = Mth.m_14107_((double)x);
        int y0 = Mth.m_14107_((double)y);
        int z0 = Mth.m_14107_((double)z);
        pos.m_122178_(x0, y0, z0);
        BlockState state = world.m_8055_((BlockPos)pos);
        if (state == null) {
            return true;
        }
        VoxelShape shape = state.m_60812_(world, (BlockPos)pos);
        List aabbs = shape.m_83299_();
        for (AABB aabb : aabbs) {
            if (aabb == null || !aabb.m_82393_(x - (double)x0, y - (double)y0, z - (double)z0)) continue;
            return false;
        }
        return true;
    }

    public static int Int(double x) {
        return Mth.m_14107_((double)x);
    }

    public static boolean isPointClearBlocks(double x, double y, double z, BlockGetter world) {
        int z0;
        int y0;
        int x0 = Mth.m_14107_((double)x);
        BlockPos pos = new BlockPos(x0, y0 = Mth.m_14107_((double)y), z0 = Mth.m_14107_((double)z));
        BlockState state = world.m_8055_(pos);
        if (state == null) {
            return true;
        }
        VoxelShape shape = state.m_60812_(world, pos);
        List aabbs = shape.m_83299_();
        for (AABB aabb : aabbs) {
            if (aabb == null || !aabb.m_82393_(x - (double)x0, y - (double)y0, z - (double)z0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVisibleRange(BlockGetter world, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            Vec3 start = source.toVec3d();
            Vec3 end = direction.scalarMultBy(range).addTo(source).toVec3d();
            if (USEDFORRAYTRACECONTEXT == null) {
                USEDFORRAYTRACECONTEXT = FakePlayerFactory.get((ServerLevel)level, (GameProfile)FAKEPLAYER);
            } else {
                USEDFORRAYTRACECONTEXT.m_143425_(level);
            }
            ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)USEDFORRAYTRACECONTEXT);
            BlockHitResult result = world.m_45547_(context);
            return result.m_6662_() == HitResult.Type.MISS;
        }
        for (double i = 0.0; i < range; i += 0.0625) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isPointClearBlocks(xtest, ytest, ztest, world);
            if (check) continue;
            return false;
        }
        return true;
    }

    public static Vector3 readFromBuff(ByteBuf dat) {
        Vector3 ret = new Vector3();
        ret.x = dat.readDouble();
        ret.y = dat.readDouble();
        ret.z = dat.readDouble();
        return ret;
    }

    public static Vector3 readFromNBT(CompoundTag nbt, String tag) {
        if (!nbt.m_128441_(tag + "x")) {
            return null;
        }
        Vector3 ret = new Vector3();
        ret.x = nbt.m_128459_(tag + "x");
        ret.y = nbt.m_128459_(tag + "y");
        ret.z = nbt.m_128459_(tag + "z");
        return ret;
    }

    public Vector3() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vector3(double pitch, double yaw) {
        this.x = 1.0;
        this.y = Math.toRadians(pitch);
        this.z = Math.toRadians(yaw);
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(Entity e, boolean bool) {
        if (e != null && bool) {
            this.x = e.m_20185_();
            this.y = e.m_20186_() + (double)(e.m_20206_() / 2.0f);
            this.z = e.m_20189_();
        } else if (e != null) {
            this.x = e.m_20185_();
            this.y = e.m_20186_() + (double)e.m_20192_();
            this.z = e.m_20189_();
        }
    }

    public Vector3(Object a) {
        this();
        this.set(a);
    }

    public Vector3(Object a, Object b) {
        this();
        Vector3 A = new Vector3().set(a);
        Vector3 B = new Vector3().set(b);
        this.set(B.subtract(A));
    }

    public Vector3(Vec3 vec) {
        this.x = vec.f_82479_;
        this.y = vec.f_82480_;
        this.z = vec.f_82481_;
    }

    public Vector3 add(double i, double j, double k) {
        return new Vector3().set(this.x + i, j + this.y, k + this.z);
    }

    public void add(int i, double j) {
        if (i == 0) {
            this.x += j;
        } else if (i == 1) {
            this.y += j;
        } else if (i == 2) {
            this.z += j;
        }
    }

    public Vector3 add(Vector3 vectorB) {
        Vector3 vectorC = new Vector3();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) + vectorB.get(i));
        }
        return vectorC;
    }

    public Vector3 addTo(double i, double j, double k) {
        this.x += i;
        this.y += j;
        this.z += k;
        return this;
    }

    public Vector3 addTo(Vector3 b) {
        if (b == null) {
            return this;
        }
        this.x += b.x;
        this.y += b.y;
        this.z += b.z;
        return this;
    }

    public void addVelocities(Entity e) {
        e.m_5997_(this.x, this.y, this.z);
    }

    public List<Entity> allEntityLocationExcluding(int range, double size, Vector3 direction, Vector3 source, Level world, Entity excluded) {
        direction = direction.normalize();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        Predicate<Entity> predicate = e -> e != excluded;
        predicate = predicate.and(EntitySelector.f_20408_);
        double ds = range;
        Vec3 vec3 = source.toVec3d();
        Vec3 vec31 = direction.toVec3d();
        Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * ds, vec31.f_82480_ * ds, vec31.f_82481_ * ds);
        float f = 0.5f;
        AABB aabb = this.getAABB().m_82363_(vec31.f_82479_ * ds, vec31.f_82480_ * ds, vec31.f_82481_ * ds).m_82377_(0.5, 0.5, 0.5);
        List mobs = world.m_6249_(excluded, aabb, predicate);
        PartEntity[] parts = null;
        block0: for (Entity entity1 : mobs) {
            parts = entity1.getParts();
            if (parts != null && parts.length > 0) {
                for (PartEntity part : parts) {
                    AABB axisalignedbb = part.m_20191_().m_82400_((double)0.3f);
                    Optional optional = axisalignedbb.m_82371_(vec3, vec32);
                    if (!optional.isPresent()) continue;
                    ret.add(entity1);
                    continue block0;
                }
                continue;
            }
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)0.3f);
            Optional optional = axisalignedbb.m_82371_(vec3, vec32);
            if (!optional.isPresent()) continue;
            ret.add(entity1);
        }
        return ret;
    }

    public List<Entity> allEntityLocationExcluding(int range, double size, Vector3 direction, Vector3 source, Level world, Entity excluded, Predicate<Entity> predicate) {
        direction = direction.normalize();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        if (predicate == null) {
            predicate = EntitySelector.f_20408_;
        }
        double ds = range;
        Vec3 vec3 = source.toVec3d();
        Vec3 vec31 = direction.toVec3d();
        Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * ds, vec31.f_82480_ * ds, vec31.f_82481_ * ds);
        float f = 1.0f;
        AABB aabb = this.getAABB().m_82363_(vec31.f_82479_ * ds, vec31.f_82480_ * ds, vec31.f_82481_ * ds).m_82377_(1.0, 1.0, 1.0);
        List mobs = world.m_6249_(excluded, aabb, predicate);
        PartEntity[] parts = null;
        block0: for (Entity entity1 : mobs) {
            parts = entity1.getParts();
            if (parts != null && parts.length > 0) {
                for (PartEntity part : parts) {
                    AABB axisalignedbb = part.m_20191_().m_82400_(size);
                    Optional optional = axisalignedbb.m_82371_(vec3, vec32);
                    if (!optional.isPresent()) continue;
                    ret.add(entity1);
                    continue block0;
                }
                continue;
            }
            AABB axisalignedbb = entity1.m_20191_().m_82400_(size);
            Optional optional = axisalignedbb.m_82371_(vec3, vec32);
            if (!optional.isPresent()) continue;
            ret.add(entity1);
        }
        return ret;
    }

    public void breakBlock(Level world, boolean drops) {
        world.m_46961_(this.getPos(), drops);
    }

    public boolean canSeeSky(LevelAccessor world) {
        if (world.m_45527_(this.getPos())) {
            return true;
        }
        return (double)world.m_6924_(Heightmap.Types.OCEAN_FLOOR, this.intX(), this.intZ()) <= this.y;
    }

    public Vector3 clear() {
        return this.set(0.0, 0.0, 0.0);
    }

    public Vector3 copy() {
        Vector3 newVector = new Vector3().set(this.x, this.y, this.z);
        return newVector;
    }

    public double distanceTo(Vector3 vec) {
        return this.subtract(vec).mag();
    }

    public double distTo(Vector3 pointB) {
        return this.subtract(pointB).mag();
    }

    public double distToEntity(Entity e) {
        return this.distanceTo(Vector3.entity(e));
    }

    public double distToSq(Vector3 pointB) {
        return this.subtract(pointB).magSq();
    }

    public double dot(Vector3 vector2) {
        double dot = 0.0;
        for (int i = 0; i < 3; ++i) {
            dot += this.get(i) * vector2.get(i);
        }
        return dot;
    }

    public boolean equals(Object vec) {
        if (!(vec instanceof Vector3)) {
            return false;
        }
        Vector3 v = (Vector3)vec;
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public Vector3 findNextSolidBlock(BlockGetter world, Vector3 direction, double range) {
        return Vector3.findNextSolidBlock(world, this, direction, range);
    }

    public Entity firstEntityExcluding(double range, Vec3 vec31, Level world, Entity entity, Predicate<Entity> predicate) {
        Entity pointedEntity = null;
        if (predicate == null) {
            predicate = EntitySelector.f_20408_;
        }
        double ds = range;
        Vec3 vec3 = this.toVec3d();
        Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * ds, vec31.f_82480_ * ds, vec31.f_82481_ * ds);
        float f = 2.5f;
        AABB aabb = this.getAABB().m_82363_(vec31.f_82479_ * ds, vec31.f_82480_ * ds, vec31.f_82481_ * ds).m_82377_(2.5, 2.5, 2.5);
        List mobs = world.m_6249_(entity, aabb, predicate);
        ds *= ds;
        PartEntity[] parts = null;
        block0: for (Entity entity1 : mobs) {
            double d1;
            parts = entity1.getParts();
            if (parts != null && parts.length > 0) {
                for (PartEntity part : parts) {
                    double d12;
                    AABB axisalignedbb = part.m_20191_().m_82400_((double)0.01f);
                    Optional optional = axisalignedbb.m_82371_(vec3, vec32);
                    if (!optional.isPresent() || !((d12 = vec3.m_82557_((Vec3)optional.get())) < ds)) continue;
                    pointedEntity = entity1;
                    ds = d12;
                    continue block0;
                }
                continue;
            }
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)0.01f);
            Optional optional = axisalignedbb.m_82371_(vec3, vec32);
            if (!optional.isPresent() || !((d1 = vec3.m_82557_((Vec3)optional.get())) < ds)) continue;
            pointedEntity = entity1;
            ds = d1;
        }
        return pointedEntity;
    }

    public Vec3 toVec3d() {
        return new Vec3(this.x, this.y, this.z);
    }

    public double get(int i) {
        assert (i < 3);
        return i == 0 ? this.x : (i == 1 ? this.y : this.z);
    }

    public AABB getAABB() {
        return new AABB(this.x, this.y, this.z, this.x, this.y, this.z);
    }

    public Holder<Biome> getBiomeHolder(LevelAccessor world) {
        return world.m_204166_(this.getPos());
    }

    public Biome getBiome(LevelAccessor world) {
        return (Biome)this.getBiomeHolder(world).m_203334_();
    }

    public Block getBlock(BlockGetter worldMap) {
        BlockState state = worldMap.m_8055_(this.getPos());
        if (state == null) {
            return Blocks.f_50016_;
        }
        return state.m_60734_();
    }

    public Block getBlock(BlockGetter world, Direction side) {
        Vector3 other = this.offset(side);
        Block ret = other.getBlock(world);
        return ret;
    }

    public Material getBlockMaterial(BlockGetter world) {
        BlockState state = world.m_8055_(this.getPos());
        if (state == null || state.m_60734_() == null) {
            return Material.f_76296_;
        }
        return state.m_60767_();
    }

    public BlockState getBlockState(BlockGetter world) {
        return world.m_8055_(this.getPos());
    }

    public float getExplosionResistance(Explosion boom, LevelReader world) {
        BlockState state = this.getBlockState((BlockGetter)world);
        if (state == null || state.m_60795_()) {
            return 0.0f;
        }
        float res = state.getExplosionResistance((BlockGetter)world, (BlockPos)this.pos, boom);
        return res;
    }

    public int getLightValue(Level world) {
        return world.m_46803_(this.getPos());
    }

    public int getMaxY(LevelAccessor world) {
        return this.getMaxY(world, this.intX(), this.intZ());
    }

    public int getMaxY(LevelAccessor world, int x, int z) {
        ChunkAccess chunk = world.m_46865_(this.getPos());
        int y1 = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR, this.intX() & 0xF, this.intZ() & 0xF);
        int y2 = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.intX() & 0xF, this.intZ() & 0xF);
        return Math.min(y1, y2);
    }

    public BlockPos getPos() {
        if (this.pos == null) {
            this.pos = new BlockPos.MutableBlockPos(this.intX(), this.intY(), this.intZ());
        } else {
            this.pos.m_122178_(this.intX(), this.intY(), this.intZ());
        }
        return this.pos;
    }

    public BlockEntity getTileEntity(BlockGetter world) {
        return world.m_7702_(this.getPos());
    }

    public BlockEntity getTileEntity(BlockGetter world, Direction side) {
        Vector3 other = this.offset(side);
        BlockEntity ret = other.getTileEntity(world);
        return ret;
    }

    public Vector3 getTopBlockPos(Level world) {
        int y = this.getTopBlockY((BlockGetter)world);
        return new Vector3().set(this.intX(), y, this.intZ());
    }

    public int getTopBlockY(BlockGetter world) {
        int ret = world.m_151558_();
        for (ret = world.m_151558_(); ret > world.m_141937_(); --ret) {
            BlockState state = world.m_8055_(new BlockPos(this.intX(), ret, this.intZ()));
            if (state == null || !state.m_60767_().m_76333_()) continue;
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Vector3 horizonalPerp() {
        Vector3 vectorH = new Vector3().set(-this.z, 0.0, this.x);
        return vectorH.norm();
    }

    public int intX() {
        return Mth.m_14107_((double)this.x);
    }

    public int intY() {
        return Mth.m_14107_((double)this.y);
    }

    public int intZ() {
        return Mth.m_14107_((double)this.z);
    }

    public boolean isAir(BlockGetter world) {
        if (world instanceof Level) {
            Material m;
            BlockState state = world.m_8055_(this.getPos());
            return state.m_60734_() == null || (m = this.getBlockMaterial(world)) == null || m == Material.f_76296_ || state.m_60795_();
        }
        Material m = this.getBlockMaterial(world);
        return m == null || m == Material.f_76296_;
    }

    public boolean isClearOfBlocks(BlockGetter world) {
        boolean ret = false;
        BlockState state = world.m_8055_(this.getPos());
        if (state == null) {
            return true;
        }
        ret = this.isAir(world);
        if (!ret) {
            boolean bl = ret = ret || this.getBlockMaterial(world).m_76332_();
        }
        if (!ret) {
            boolean bl = ret = ret || this.getBlockMaterial(world).m_76336_();
        }
        if (!ret) {
            boolean bl = ret = ret || !this.getBlockMaterial(world).m_76334_();
        }
        if (!ret) {
            VoxelShape shape = state.m_60812_(world, this.getPos());
            List aabbs = shape.m_83299_();
            if (aabbs.size() == 0) {
                return true;
            }
            for (AABB aabb : aabbs) {
                if (aabb == null || !aabb.m_82393_(this.x - (double)this.intX(), this.y - (double)this.intY(), this.z - (double)this.intZ())) continue;
                return false;
            }
            return true;
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.x == 0.0 && this.z == 0.0 && this.y == 0.0;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.z) || Double.isNaN(this.y);
    }

    public boolean isVisible(BlockGetter world, Vector3 location) {
        Vector3 direction = location.subtract(this);
        double range = direction.mag();
        return Vector3.isVisibleRange(world, this, direction, range);
    }

    public double mag() {
        double vmag = Math.sqrt(this.magSq());
        return vmag;
    }

    public double magSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void moveEntity(Entity e) {
        e.m_6034_(this.x, this.y, this.z);
    }

    public Vector3 norm() {
        double vmag = this.mag();
        if (vmag == 0.0) {
            return this.clear();
        }
        this.scalarMultBy(1.0 / vmag);
        return this;
    }

    public Vector3 normalize() {
        double vmag = this.mag();
        Vector3 vHat = new Vector3();
        if (vmag == 0.0) {
            return vHat.clear();
        }
        vHat.set(this).scalarMultBy(1.0 / vmag);
        return vHat;
    }

    public Vector3 offset(Direction side) {
        return this.add(new Vector3().set(side));
    }

    public Vector3 offsetBy(Direction side) {
        return this.addTo(side.m_122429_(), side.m_122430_(), side.m_122431_());
    }

    public Vector3 reverse() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 rotateAboutAngles(double pitch, double yaw, Vector3 temp, Vector3 temp1) {
        if (this.isEmpty() || pitch == 0.0 && yaw == 0.0) {
            return this;
        }
        temp.set(this);
        if (yaw != 0.0) {
            this.rotateAboutLine(secondAxis, yaw, temp);
        }
        if (pitch != 0.0) {
            this.rotateAboutLine(this.horizonalPerp(), pitch, temp);
        }
        if (temp.isNaN()) {
            return temp.clear();
        }
        return temp;
    }

    public Vector3 rotateAboutLine(Vector3 line, double angle, Vector3 ret) {
        if (line.magSq() != 1.0) {
            line = line.normalize();
        }
        if (ret == null) {
            ret = new Vector3();
        }
        double[][] mat = rotBox;
        mat[0][0] = line.get(0) * line.get(0) * (double)(1.0f - Mth.m_14089_((float)((float)angle))) + (double)Mth.m_14089_((float)((float)angle));
        mat[0][1] = line.get(0) * line.get(1) * (double)(1.0f - Mth.m_14089_((float)((float)angle))) - line.get(2) * (double)Mth.m_14031_((float)((float)angle));
        mat[0][2] = line.get(0) * line.get(2) * (double)(1.0f - Mth.m_14089_((float)((float)angle))) + line.get(1) * (double)Mth.m_14031_((float)((float)angle));
        mat[1][0] = line.get(1) * line.get(0) * (double)(1.0f - Mth.m_14089_((float)((float)angle))) + line.get(2) * (double)Mth.m_14031_((float)((float)angle));
        mat[1][1] = line.get(1) * line.get(1) * (double)(1.0f - Mth.m_14089_((float)((float)angle))) + (double)Mth.m_14089_((float)((float)angle));
        mat[1][2] = line.get(1) * line.get(2) * (double)(1.0f - Mth.m_14089_((float)((float)angle))) - line.get(0) * (double)Mth.m_14031_((float)((float)angle));
        mat[2][0] = line.get(2) * line.get(0) * (double)(1.0f - Mth.m_14089_((float)((float)angle))) - line.get(1) * (double)Mth.m_14031_((float)((float)angle));
        mat[2][1] = line.get(2) * line.get(1) * (double)(1.0f - Mth.m_14089_((float)((float)angle))) + line.get(0) * (double)Mth.m_14031_((float)((float)angle));
        mat[2][2] = line.get(2) * line.get(2) * (double)(1.0f - Mth.m_14089_((float)((float)angle))) + (double)Mth.m_14089_((float)((float)angle));
        ret.x = mat[0][0] * this.x + mat[0][1] * this.y + mat[0][2] * this.z;
        ret.y = mat[1][0] * this.x + mat[1][1] * this.y + mat[1][2] * this.z;
        ret.z = mat[2][0] * this.x + mat[2][1] * this.y + mat[2][2] * this.z;
        return ret;
    }

    public boolean sameBlock(Vector3 vec) {
        return this.intX() == vec.intX() && this.intY() == vec.intY() && this.intZ() == vec.intZ();
    }

    public Vector3 scalarMult(double constant) {
        Vector3 newVector = new Vector3();
        for (int i = 0; i < 3; ++i) {
            newVector.set(i, constant * this.get(i));
        }
        return newVector;
    }

    public Vector3 scalarMultBy(double i) {
        this.x *= i;
        this.y *= i;
        this.z *= i;
        return this;
    }

    public Vector3 set(Direction dir) {
        this.x = dir.m_122429_();
        this.y = dir.m_122430_();
        this.z = dir.m_122431_();
        return this;
    }

    public Vector3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3 set(double[] vec) {
        this.x = vec[0];
        this.y = vec[1];
        this.z = vec[2];
        return this;
    }

    public Vector3 set(Entity e, boolean b) {
        if (e != null && b) {
            this.x = e.m_20185_();
            this.y = e.m_20186_() + (double)(e.m_20206_() / 2.0f);
            this.z = e.m_20189_();
        } else if (e != null) {
            this.x = e.m_20185_();
            this.y = e.m_20186_() + (double)e.m_20192_();
            this.z = e.m_20189_();
        }
        return this;
    }

    public void set(int i, double j) {
        if (i == 0) {
            this.x = j;
        } else if (i == 1) {
            this.y = j;
        } else if (i == 2) {
            this.z = j;
        }
    }

    public Vector3 set(Object o) {
        if (o instanceof Entity) {
            Entity e = (Entity)o;
            this.set(e.m_20185_(), e.m_20186_(), e.m_20189_());
        } else if (o instanceof BlockEntity) {
            BlockEntity te = (BlockEntity)o;
            this.set(te.m_58899_());
        } else if (o instanceof double[]) {
            double[] d = (double[])o;
            this.set(d[0], d[1], d[2]);
        } else if (o instanceof Direction) {
            Direction side = (Direction)o;
            this.set(side);
        } else if (o instanceof Direction8) {
            Direction8 dir = (Direction8)o;
            this.clear();
            for (Direction side : dir.m_122593_()) {
                this.addTo(side.m_122429_(), side.m_122430_(), side.m_122431_());
            }
        } else if (o instanceof Vector3) {
            Vector3 v = (Vector3)o;
            this.set(v);
        } else if (o instanceof BlockPos) {
            BlockPos c = (BlockPos)o;
            this.set(c.m_123341_(), c.m_123342_(), c.m_123343_());
        } else if (o instanceof GlobalPos) {
            GlobalPos g = (GlobalPos)o;
            BlockPos c = g.m_122646_();
            this.set(c.m_123341_(), c.m_123342_(), c.m_123343_());
        } else if (o instanceof Node) {
            Node p = (Node)o;
            this.set(p.f_77271_, p.f_77272_, p.f_77273_);
        } else if (o instanceof Vec3) {
            Vec3 p = (Vec3)o;
            this.set(p.f_82479_, p.f_82480_, p.f_82481_);
        } else if (o instanceof int[]) {
            int[] p = (int[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof byte[]) {
            byte[] p = (byte[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof short[]) {
            short[] p = (short[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof float[]) {
            float[] p = (float[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof Double) {
            Double d = (Double)o;
            this.y = this.z = d.doubleValue();
            this.x = this.z;
        }
        return this;
    }

    public Vector3 set(Vector3 vec) {
        if (vec != null) {
            this.x = vec.x;
            this.y = vec.y;
            this.z = vec.z;
        }
        return this;
    }

    public void setAir(Level world) {
        world.m_46597_(this.getPos(), Blocks.f_50016_.m_49966_());
    }

    public void setBiome(Biome biome, Level world) {
        if (!(world instanceof ServerLevel)) {
            ThutCore.LOGGER.error("Called on wrong side, this is server only!");
            return;
        }
        ServerLevel level = (ServerLevel)world;
        int x = this.intX();
        int y = this.intY();
        int z = this.intZ();
        int qx = QuartPos.m_175400_((int)x);
        int qy = QuartPos.m_175400_((int)y);
        int qz = QuartPos.m_175400_((int)z);
        ChunkAccess chunk = level.m_46865_(this.getPos());
        int i = QuartPos.m_175400_((int)chunk.m_141937_());
        int k = i + QuartPos.m_175400_((int)chunk.m_141928_()) - 1;
        int l = Mth.m_14045_((int)qy, (int)i, (int)k);
        int j = chunk.m_151564_(QuartPos.m_175402_((int)l));
        LevelChunkSection section = chunk.m_7103_()[j];
        PalettedContainer biomes = (PalettedContainer)section.m_187996_();
        Biome old = (Biome)((Holder)biomes.m_63087_(qx & 3, l & 3, qz & 3)).m_203334_();
        if (old == biome) {
            return;
        }
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)RegHelper.getKey(biome));
        Registry registry = level.m_5962_().m_175515_(Registry.f_122885_);
        Holder.Reference holder = Holder.Reference.m_205766_((Registry)registry, (ResourceKey)key);
        holder.m_205775_(key, (Object)biome);
        biomes.m_156470_(qx & 3, l & 3, qz & 3, (Object)holder);
        if (chunk instanceof LevelChunk) {
            LevelChunk lchunk = (LevelChunk)chunk;
            ChunkMap map = level.m_7726_().f_8325_;
            LevelLightEngine lights = level.m_5518_();
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(lchunk, lights, null, null, true);
            map.m_183262_(chunk.m_7697_(), false).forEach(e -> e.f_8906_.m_9829_((Packet)packet));
        }
    }

    public void setBlock(Level world, BlockState defaultState) {
        world.m_46597_(this.getPos(), defaultState);
    }

    public Vector3 setToVelocity(Entity e) {
        this.set(e.m_20184_());
        return this;
    }

    public void setVelocities(Entity e) {
        e.m_20334_(this.x, this.y, this.z);
    }

    public Vector3 subtract(Vector3 vectorB) {
        Vector3 vectorC = new Vector3();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) - vectorB.get(i));
        }
        return vectorC;
    }

    public Vector3 subtractFrom(Vector3 b) {
        if (b == null) {
            return this;
        }
        this.x -= b.x;
        this.y -= b.y;
        this.z -= b.z;
        return this;
    }

    public Vector3 toSpherical() {
        Vector3 vectorSpher = new Vector3();
        vectorSpher.x = this.mag();
        vectorSpher.y = Math.acos(this.get(1) / vectorSpher.x) - 1.5707963267948966;
        vectorSpher.z = Math.atan2(this.get(2), this.x);
        return vectorSpher;
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " z:" + this.z;
    }

    public void writeToBuff(ByteBuf data) {
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.z);
    }

    public void writeToNBT(CompoundTag nbt, String tag) {
        nbt.m_128347_(tag + "x", this.x);
        nbt.m_128347_(tag + "y", this.y);
        nbt.m_128347_(tag + "z", this.z);
    }
}

