/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths.vecmath;

import java.io.Serializable;
import java.nio.FloatBuffer;
import thut.api.maths.vecmath.Vector;

public class Vec2f
extends Vector
implements Serializable {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vec2f() {
    }

    public Vec2f(float x, float y) {
        this.set(x, y);
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vec2f translate(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    @Override
    public Vector negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vec2f negate(Vec2f dest) {
        if (dest == null) {
            dest = new Vec2f();
        }
        dest.x = -this.x;
        dest.y = -this.y;
        return dest;
    }

    public Vec2f normalise(Vec2f dest) {
        float l = this.length();
        if (dest == null) {
            dest = new Vec2f(this.x / l, this.y / l);
        } else {
            dest.set(this.x / l, this.y / l);
        }
        return dest;
    }

    public static float dot(Vec2f left, Vec2f right) {
        return left.x * right.x + left.y * right.y;
    }

    public static float angle(Vec2f a, Vec2f b) {
        float dls = Vec2f.dot(a, b) / (a.length() * b.length());
        if (dls < -1.0f) {
            dls = -1.0f;
        } else if (dls > 1.0f) {
            dls = 1.0f;
        }
        return (float)Math.acos(dls);
    }

    public static Vec2f add(Vec2f left, Vec2f right, Vec2f dest) {
        if (dest == null) {
            return new Vec2f(left.x + right.x, left.y + right.y);
        }
        dest.set(left.x + right.x, left.y + right.y);
        return dest;
    }

    public static Vec2f sub(Vec2f left, Vec2f right, Vec2f dest) {
        if (dest == null) {
            return new Vec2f(left.x - right.x, left.y - right.y);
        }
        dest.set(left.x - right.x, left.y - right.y);
        return dest;
    }

    @Override
    public Vector store(FloatBuffer buf) {
        buf.put(this.x);
        buf.put(this.y);
        return this;
    }

    @Override
    public Vector load(FloatBuffer buf) {
        this.x = buf.get();
        this.y = buf.get();
        return this;
    }

    @Override
    public Vector scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Vector2f[");
        sb.append(this.x);
        sb.append(", ");
        sb.append(this.y);
        sb.append(']');
        return sb.toString();
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final void setX(float x) {
        this.x = x;
    }

    public final void setY(float y) {
        this.y = y;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec2f other = (Vec2f)obj;
        return this.x == other.x && this.y == other.y;
    }
}

