/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths.vecmath;

import com.mojang.math.Vector3f;
import java.io.Serializable;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Quat4f;
import thut.api.maths.vecmath.Tuple3d;
import thut.api.maths.vecmath.Tuple3f;
import thut.api.maths.vecmath.Vector3d;

public class Vec3f
extends Tuple3f
implements Serializable {
    public static Vec3f XN = new Vec3f(-1.0f, 0.0f, 0.0f);
    public static Vec3f XP = new Vec3f(1.0f, 0.0f, 0.0f);
    public static Vec3f YN = new Vec3f(0.0f, -1.0f, 0.0f);
    public static Vec3f YP = new Vec3f(0.0f, 1.0f, 0.0f);
    public static Vec3f ZN = new Vec3f(0.0f, 0.0f, -1.0f);
    public static Vec3f ZP = new Vec3f(0.0f, 0.0f, 1.0f);
    static final long serialVersionUID = -7031930069184524614L;

    public Vec3f(float x, float y, float z) {
        super(x, y, z);
    }

    public Vec3f(float[] v) {
        super(v);
    }

    public Vec3f(Vec3f v1) {
        super(v1);
    }

    public Vec3f(Vector3d v1) {
        super(v1);
    }

    public Vec3f(Tuple3f t1) {
        super(t1);
    }

    public Vec3f(Tuple3d t1) {
        super(t1);
    }

    public Vec3f() {
    }

    public Quat4f rotation(float valueIn) {
        return new Quat4f(this, valueIn, false);
    }

    public Quat4f rotationDegrees(float valueIn) {
        return new Quat4f(this, valueIn, true);
    }

    public Vector3f toMC() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public Vec3f(Vector3 rHat) {
        this((float)rHat.x, (float)rHat.y, (float)rHat.z);
    }

    public final void set(Vector3 rHat) {
        this.x = (float)rHat.x;
        this.y = (float)rHat.y;
        this.z = (float)rHat.z;
    }

    public final float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final void cross(Vec3f v1, Vec3f v2) {
        float x = v1.y * v2.z - v1.z * v2.y;
        float y = v2.x * v1.z - v2.z * v1.x;
        this.z = v1.x * v2.y - v1.y * v2.x;
        this.x = x;
        this.y = y;
    }

    public final float dot(Vec3f v1) {
        return this.x * v1.x + this.y * v1.y + this.z * v1.z;
    }

    public final void normalize(Vec3f v1) {
        float norm = (float)(1.0 / Math.sqrt(v1.x * v1.x + v1.y * v1.y + v1.z * v1.z));
        this.x = v1.x * norm;
        this.y = v1.y * norm;
        this.z = v1.z * norm;
    }

    public final void normalize() {
        float norm = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        this.x *= norm;
        this.y *= norm;
        this.z *= norm;
    }

    public final float angle(Vec3f v1) {
        double vDot = this.dot(v1) / (this.length() * v1.length());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return (float)Math.acos(vDot);
    }
}

