/*
 * Decompiled with CFR 0.152.
 */
package thut.api.particle;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.maths.Vector3;
import thut.api.particle.IParticle;

public class ParticleHandler {
    static List<ParticlePacket> particles = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParticle(Vector3 location, IParticle particle) {
        if (particle == null || location == null || Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) {
            return;
        }
        List<ParticlePacket> list = particles;
        synchronized (list) {
            particles.add(new ParticlePacket(location.copy(), particle));
        }
    }

    public static void clear() {
        particles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderWorldPost(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        try {
            List<ParticlePacket> list = particles;
            synchronized (list) {
                int i;
                PoseStack mat = event.getPoseStack();
                mat.m_85836_();
                ArrayList list2 = Lists.newArrayList();
                for (i = 0; i < particles.size(); ++i) {
                    ParticlePacket packet = particles.get(i);
                    IParticle particle = packet.particle;
                    Vector3 target = packet.location;
                    if (particle.getDuration() < 0) {
                        packet.kill();
                        list2.add(packet);
                        continue;
                    }
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    Vector3 source = new Vector3().set(player.f_19790_, player.f_19791_, player.f_19792_);
                    mat.m_85836_();
                    source.set(target.subtract(source));
                    mat.m_85837_(source.x, source.y, source.z);
                    double d0 = (-player.m_20185_() + player.f_19790_) * (double)event.getPartialTick();
                    double d1 = (-player.m_20186_() + player.f_19791_) * (double)event.getPartialTick();
                    double d2 = (-player.m_20189_() + player.f_19792_) * (double)event.getPartialTick();
                    source.set(d0, d1, d2);
                    mat.m_85837_(source.x, source.y, source.z);
                    mat.m_85849_();
                    if (particle.lastTick() != player.m_9236_().m_46467_()) {
                        particle.setDuration(particle.getDuration() - 1);
                        particle.setLastTick(player.m_9236_().m_46467_());
                    }
                    if (particle.getDuration() >= 0) continue;
                    packet.kill();
                    list2.add(packet);
                }
                mat.m_85849_();
                for (i = 0; i < list2.size(); ++i) {
                    particles.remove(list2.get(i));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void WorldUnloadEvent(LevelEvent.Unload evt) {
        ParticleHandler.clear();
    }

    private static class ParticlePacket {
        final Vector3 location;
        final IParticle particle;

        public ParticlePacket(Vector3 v, IParticle p) {
            this.location = v;
            this.particle = p;
        }

        public void kill() {
            this.particle.kill();
        }
    }
}

