/*
 * Decompiled with CFR 0.152.
 */
package thut.api.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Quaternion;
import net.minecraft.client.Camera;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thut.api.maths.Vector4;
import thut.api.maths.vecmath.Vec3f;
import thut.api.particle.ParticleBase;

public class ParticleOrientable
extends ParticleBase {
    public Vector4 orientation;

    public ParticleOrientable(int x, int y) {
        super(x, y);
        this.billboard = false;
    }

    @Override
    protected ParticleBase read(StringReader reader) {
        super.read(reader);
        try {
            this.orientation = new Vector4(reader.readFloat(), reader.readFloat(), reader.readFloat(), reader.readFloat());
        }
        catch (CommandSyntaxException e) {
            this.orientation = new Vector4();
        }
        return this;
    }

    @Override
    public ParticleBase read(FriendlyByteBuf buffer) {
        super.read(buffer);
        this.orientation = new Vector4(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderParticle(VertexConsumer buffer, Camera renderInfo, float partialTicks, Vec3f offset) {
        Quaternion quaternion = new Quaternion(renderInfo.m_90591_());
        quaternion.m_80148_(this.orientation.toMCQ());
        this.render(buffer, quaternion, offset);
    }

    public ParticleOrientable setOrientation(Vector4 orientation) {
        this.orientation = orientation;
        return this;
    }

    @Override
    public void m_7711_(FriendlyByteBuf buffer) {
        super.m_7711_(buffer);
        buffer.writeFloat(this.orientation.x);
        buffer.writeFloat(this.orientation.y);
        buffer.writeFloat(this.orientation.z);
        buffer.writeFloat(this.orientation.w);
    }
}

