/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import thut.core.common.ThutCore;

public class BiomeType {
    private static final Map<Integer, BiomeType> typeMap = Maps.newHashMap();
    private static final Map<Integer, BiomeType> typeMapClient = Maps.newHashMap();
    private static int MAXID = 256;
    public static final BiomeType NONE = new BiomeType("none").setNoSave();
    public static final BiomeType SKY = new BiomeType("sky").setNoSave();
    public static final BiomeType FLOWER = new BiomeType("flower").setNoSave();
    public static final BiomeType LAKE = new BiomeType("lake");
    public static final BiomeType INDUSTRIAL = new BiomeType("industrial");
    public static final BiomeType METEOR = new BiomeType("meteor");
    public static final BiomeType RUIN = new BiomeType("ruin");
    public static final BiomeType CAVE = new BiomeType("cave").setNoSave();
    public static final BiomeType CAVE_WATER = new BiomeType("cavewater").setNoSave();
    public static final BiomeType VILLAGE = new BiomeType("village");
    public static final BiomeType ALL = new BiomeType("all").setNoSave();
    public final String name;
    private int id;
    public final String readableName;
    private boolean save = true;
    private List<String> subTypes = Lists.newArrayList();

    public static BiomeType getBiome(String name) {
        return BiomeType.getBiome(name, true);
    }

    public static BiomeType getBiome(String name, boolean generate) {
        name = ThutCore.trim(name);
        for (BiomeType b : BiomeType.values()) {
            if (!b.name.equalsIgnoreCase(name)) continue;
            return b;
        }
        if (generate) {
            BiomeType ret = new BiomeType(name);
            return ret;
        }
        return NONE;
    }

    public static BiomeType getType(int id) {
        if (ThutCore.proxy.isClientSide()) {
            return typeMapClient.containsKey(id) ? typeMapClient.get(id) : NONE;
        }
        return typeMap.containsKey(id) ? typeMap.get(id) : NONE;
    }

    public static BiomeType merge(BiomeType typeA, BiomeType typeB) {
        HashSet noDupes = Sets.newHashSet();
        if (typeA.subTypes.isEmpty()) {
            noDupes.add(typeA.name);
        } else {
            noDupes.addAll(typeA.subTypes);
        }
        if (typeB.subTypes.isEmpty()) {
            noDupes.add(typeB.name);
        } else {
            noDupes.addAll(typeB.subTypes);
        }
        ArrayList names = Lists.newArrayList((Iterable)noDupes);
        Collections.sort(names);
        BiomeType type = BiomeType.getBiome(((Object)names).toString(), true);
        if (type.subTypes.isEmpty()) {
            type.setSubTypes(names);
        }
        return type;
    }

    public static BiomeType remove(BiomeType container, BiomeType toRemove) {
        ArrayList names = Lists.newArrayList(container.subTypes);
        names.remove(toRemove.name);
        BiomeType type = BiomeType.getBiome(((Object)names).toString(), true);
        if (type.subTypes.isEmpty()) {
            type.setSubTypes(names);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<BiomeType> values() {
        Collection<BiomeType> values;
        if (ThutCore.proxy.isClientSide()) {
            Collection<BiomeType> values2;
            ArrayList types = Lists.newArrayList();
            Collection<BiomeType> collection = values2 = typeMapClient.values();
            synchronized (collection) {
                types.addAll(values2);
            }
            return types;
        }
        ArrayList types = Lists.newArrayList();
        Collection<BiomeType> collection = values = typeMap.values();
        synchronized (collection) {
            types.addAll(values);
        }
        return types;
    }

    private BiomeType(String name) {
        this.name = name;
        this.readableName = "thutcore.biometype." + name;
        this.id = -1;
        for (BiomeType type : typeMap.values()) {
            if (!type.name.equals(name)) continue;
            this.id = type.id;
        }
        if (this.id == -1) {
            this.id = MAXID++;
        }
        typeMap.put(this.id, this);
        typeMapClient.put(this.id, this);
    }

    public BiomeType setNoSave() {
        this.save = false;
        return this;
    }

    private BiomeType setSubTypes(List<String> names) {
        this.subTypes = names;
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof BiomeType) {
            BiomeType t = (BiomeType)o;
            return t.id == this.id;
        }
        return false;
    }

    public int getType() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean contains(BiomeType other) {
        if (this == ALL) {
            return true;
        }
        return other == this || this.subTypes.contains(other.name);
    }

    public boolean anyMatch(Set<BiomeType> biomes) {
        for (BiomeType b : biomes) {
            if (!this.contains(b)) continue;
            return true;
        }
        return this == ALL;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean shouldSave() {
        return this.save;
    }

    public String toString() {
        return this.name;
    }
}

