/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import thut.api.ThutCaps;
import thut.api.terrain.BiomeType;
import thut.api.terrain.TerrainSegment;

public class CapabilityTerrain {

    public static interface ITerrainProvider
    extends INBTSerializable<CompoundTag> {
        public BlockPos getChunkPos();

        public TerrainSegment getTerrainSegment(BlockPos var1);

        public TerrainSegment getTerrainSegment(int var1);

        public void setTerrainSegment(TerrainSegment var1, int var2);

        public ITerrainProvider setChunk(ChunkAccess var1);
    }

    public static class DefaultProvider
    implements ITerrainProvider,
    ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final LazyOptional<ITerrainProvider> holder = LazyOptional.of(() -> this);
        private BlockPos pos;
        private ChunkAccess chunk;
        Int2ObjectArrayMap<TerrainSegment> segMap = new Int2ObjectArrayMap();
        Int2BooleanArrayMap reals = new Int2BooleanArrayMap();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();

        public DefaultProvider(ChunkAccess chunk) {
            this.chunk = chunk;
        }

        @Override
        public ITerrainProvider setChunk(ChunkAccess chunk) {
            if (this.chunk == null && chunk != null) {
                this.chunk = chunk;
            }
            return this;
        }

        public void deserializeNBT(CompoundTag nbt) {
            boolean hasReplacements;
            BlockPos pos = this.getChunkPos();
            int x = pos.m_123341_();
            int z = pos.m_123343_();
            Int2IntOpenHashMap toUpdate = new Int2IntOpenHashMap();
            ListTag tags = (ListTag)nbt.m_128423_("ids");
            for (int i = 0; i < tags.size(); ++i) {
                CompoundTag tag = tags.m_128728_(i);
                String name = tag.m_128461_("name");
                int id = tag.m_128451_("id");
                BiomeType type = BiomeType.getBiome(name, true);
                int newId = type.getType();
                if (newId == id) continue;
                toUpdate.put(id, type.getType());
            }
            boolean bl = hasReplacements = !toUpdate.isEmpty();
            if (nbt.m_128441_("segs")) {
                tags = (ListTag)nbt.m_128423_("segs");
                for (int i = 0; i < tags.size(); ++i) {
                    TerrainSegment t = null;
                    CompoundTag terrainTag = tags.m_128728_(i);
                    if (terrainTag.m_128456_() || TerrainSegment.noLoad) continue;
                    int y = terrainTag.m_128451_("y");
                    t = new TerrainSegment(x, y, z);
                    if (hasReplacements) {
                        t.idReplacements = toUpdate;
                    }
                    TerrainSegment.readFromNBT(t, terrainTag);
                    this.setTerrainSegment(t, y);
                    t.idReplacements = null;
                    this.reals.put(i, true);
                }
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.TERRAIN_PROVIDER.orEmpty(cap, this.holder);
        }

        @Override
        public BlockPos getChunkPos() {
            if (this.pos == null) {
                this.pos = new BlockPos(this.chunk.m_7697_().f_45578_, 0, this.chunk.m_7697_().f_45579_);
            }
            return this.pos;
        }

        @Override
        public TerrainSegment getTerrainSegment(BlockPos blockLocation) {
            int chunkY = SectionPos.m_123171_((int)blockLocation.m_123342_());
            TerrainSegment segment = this.getTerrainSegment(chunkY);
            return segment;
        }

        @Override
        public TerrainSegment getTerrainSegment(int chunkY) {
            if (this.reals.get(chunkY) && this.segMap.containsKey(chunkY)) {
                TerrainSegment ret = (TerrainSegment)this.segMap.get(chunkY);
                ret.real = true;
                ret.chunk = this.chunk;
                return ret;
            }
            this.mutable.m_122178_(this.chunk.m_7697_().f_45578_, chunkY, this.chunk.m_7697_().f_45579_);
            BlockPos.MutableBlockPos pos = this.mutable;
            TerrainSegment ret = (TerrainSegment)this.segMap.get(chunkY);
            TerrainSegment cached = thut.api.terrain.ITerrainProvider.removeCached((ResourceKey<Level>)((Level)this.chunk.getWorldForge()).m_46472_(), this.chunk.m_7697_(), chunkY);
            if (ret == null) {
                ret = cached != null ? cached : new TerrainSegment(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            } else if (cached != null) {
                for (int i = 0; i < cached.biomes.length; ++i) {
                    if (ret.biomes[i] != -1) continue;
                    ret.biomes[i] = cached.biomes[i];
                }
            }
            ret.chunk = this.chunk;
            ret.real = true;
            this.reals.put(chunkY, true);
            this.segMap.put(chunkY, (Object)ret);
            return ret;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            IntOpenHashSet ids = new IntOpenHashSet();
            ListTag segs = new ListTag();
            IntIterator intIterator = this.segMap.keySet().iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                TerrainSegment terrainSegment = this.getTerrainSegment(i);
                if (terrainSegment == null || !terrainSegment.toSave) continue;
                for (int id : terrainSegment.biomes) {
                    ids.add(id);
                }
                CompoundTag terrainTag = new CompoundTag();
                terrainSegment.saveToNBT(terrainTag);
                segs.add((Object)terrainTag);
            }
            nbt.m_128365_("segs", (Tag)segs);
            ListTag biomeList = new ListTag();
            for (BiomeType biomeType : BiomeType.values()) {
                if (!ids.contains(biomeType.getType())) continue;
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("name", biomeType.name);
                tag.m_128405_("id", biomeType.getType());
                biomeList.add((Object)tag);
            }
            nbt.m_128365_("ids", (Tag)biomeList);
            return nbt;
        }

        @Override
        public void setTerrainSegment(TerrainSegment segment, int chunkY) {
            this.segMap.put(chunkY, (Object)segment);
        }
    }
}

