/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thut.api.ThutCaps;
import thut.api.terrain.CapabilityTerrain;
import thut.api.terrain.TerrainSegment;

public interface ITerrainProvider {
    public static final Map<ResourceKey<Level>, Map<ChunkPos, TerrainCache>> pendingCache = new ConcurrentHashMap<ResourceKey<Level>, Map<ChunkPos, TerrainCache>>();
    public static final Map<ResourceKey<Level>, Map<ChunkPos, ChunkAccess>> loadedChunks = new ConcurrentHashMap<ResourceKey<Level>, Map<ChunkPos, ChunkAccess>>();

    public static void addChunk(ResourceKey<Level> dim, ChunkAccess chunk) {
        ConcurrentHashMap<ChunkPos, ChunkAccess> chunks = loadedChunks.getOrDefault(dim, null);
        if (chunks == null) {
            chunks = new ConcurrentHashMap<ChunkPos, ChunkAccess>();
            loadedChunks.put(dim, chunks);
        }
        chunks.put(chunk.m_7697_(), chunk);
    }

    public static void removeChunk(ResourceKey<Level> dim, ChunkPos cpos) {
        Map<ChunkPos, ChunkAccess> chunks = loadedChunks.get(dim);
        if (chunks != null) {
            chunks.remove(cpos);
        }
    }

    public static ChunkAccess getChunk(ResourceKey<Level> dim, ChunkPos cpos) {
        Map<ChunkPos, ChunkAccess> chunks = loadedChunks.get(dim);
        if (chunks == null) {
            return null;
        }
        return chunks.get(cpos);
    }

    public static TerrainSegment removeCached(ResourceKey<Level> dim, BlockPos pos) {
        ChunkPos cpos = new ChunkPos(pos.m_123341_(), pos.m_123343_());
        return ITerrainProvider.removeCached(dim, cpos, pos.m_123342_());
    }

    public static TerrainSegment removeCached(ResourceKey<Level> dim, ChunkPos cpos, int y) {
        Map<ChunkPos, TerrainCache> chunks = pendingCache.get(dim);
        if (chunks == null) {
            return null;
        }
        TerrainCache segs = chunks.get(cpos);
        if (segs == null) {
            return null;
        }
        TerrainSegment var = segs.remove(y);
        if (!segs.isValid()) {
            chunks.remove(cpos);
        }
        return var;
    }

    default public TerrainSegment getTerrain(LevelAccessor world, BlockPos p) {
        ChunkAccess chunkAccess;
        if (!(world instanceof Level)) {
            return new TerrainSegment(p);
        }
        Level level = (Level)world;
        ChunkPos temp = null;
        ResourceKey dim = level.m_46472_();
        if (world.m_5776_()) {
            chunkAccess = world.m_46865_(p);
        } else {
            temp = new ChunkPos(p);
            chunkAccess = ITerrainProvider.getChunk((ResourceKey<Level>)dim, temp);
        }
        ChunkAccess chunk = chunkAccess;
        boolean real = chunk != null && chunk instanceof ICapabilityProvider;
        int y = SectionPos.m_123171_((int)p.m_123342_());
        if (y < world.m_151560_()) {
            y = world.m_151560_();
        }
        if (y > world.m_151561_()) {
            y = world.m_151561_();
        }
        if (!real) {
            TerrainCache segs;
            Map<ChunkPos, TerrainCache> chunks = pendingCache.get(dim);
            if (chunks == null) {
                chunks = new ConcurrentHashMap<ChunkPos, TerrainCache>();
                pendingCache.put((ResourceKey<Level>)dim, chunks);
            }
            if ((segs = chunks.get(temp)) == null) {
                segs = new TerrainCache(temp, chunk, world);
                chunks.put(temp, segs);
            }
            return segs.get(y);
        }
        CapabilityTerrain.ITerrainProvider provider = (CapabilityTerrain.ITerrainProvider)((ICapabilityProvider)chunk).getCapability(ThutCaps.TERRAIN_PROVIDER).orElse(null);
        provider.setChunk(chunk);
        return provider.getTerrainSegment(y);
    }

    public static class TerrainCache {
        Int2ObjectArrayMap<TerrainSegment> segMap = new Int2ObjectArrayMap();
        int num;
        ChunkPos pos;
        ChunkAccess chunk;

        public TerrainCache(ChunkPos temp, ChunkAccess chunk, LevelAccessor world) {
            this.pos = temp;
            this.chunk = chunk;
        }

        public TerrainSegment remove(int y) {
            TerrainSegment seg = (TerrainSegment)this.segMap.get(y);
            if (seg == null) {
                return null;
            }
            --this.num;
            return seg;
        }

        public boolean isValid() {
            return this.num > 0;
        }

        private TerrainSegment make(int y) {
            TerrainSegment seg = new TerrainSegment(this.pos.f_45578_, y, this.pos.f_45579_);
            seg.chunk = this.chunk;
            seg.real = false;
            ++this.num;
            return seg;
        }

        public TerrainSegment get(int y) {
            return (TerrainSegment)this.segMap.computeIfAbsent(y, this::make);
        }
    }
}

