/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.terrain.GlobalChunkPos;
import thut.api.terrain.ITerrainProvider;
import thut.core.common.ThutCore;

public class StructureManager {
    public static Map<GlobalChunkPos, Set<StructureInfo>> map_by_pos = Maps.newHashMap();

    private static Set<StructureInfo> getOrMake(GlobalChunkPos pos) {
        HashSet set = map_by_pos.get(pos);
        if (set == null) {
            set = Sets.newHashSet();
            map_by_pos.put(pos, set);
        }
        return set;
    }

    public static Set<StructureInfo> getFor(ResourceKey<Level> dim, BlockPos loc) {
        GlobalChunkPos pos = new GlobalChunkPos(dim, new ChunkPos(loc));
        Set<StructureInfo> forPos = map_by_pos.getOrDefault(pos, Collections.emptySet());
        if (forPos.isEmpty()) {
            return forPos;
        }
        HashSet matches = Sets.newHashSet();
        for (StructureInfo i : forPos) {
            if (!i.isIn(loc)) continue;
            matches.add(i);
        }
        return matches;
    }

    public static Set<StructureInfo> getFor(ServerLevel dim, BlockPos loc) {
        return StructureManager.getFor((ResourceKey<Level>)dim.m_46472_(), loc);
    }

    public static Set<StructureInfo> getNear(ServerLevel dim, BlockPos loc, int distance) {
        return StructureManager.getNear((ResourceKey<Level>)dim.m_46472_(), loc, distance);
    }

    private static Set<StructureInfo> getNearInt(ResourceKey<Level> dim, BlockPos loc, ChunkPos pos, int distance) {
        GlobalChunkPos gpos = new GlobalChunkPos(dim, pos);
        Set<StructureInfo> forPos = map_by_pos.getOrDefault(gpos, Collections.emptySet());
        if (forPos.isEmpty()) {
            return forPos;
        }
        HashSet matches = Sets.newHashSet();
        for (StructureInfo i : forPos) {
            if (!i.isNear(loc, distance)) continue;
            matches.add(i);
        }
        return matches;
    }

    public static Set<StructureInfo> getNear(ResourceKey<Level> dim, BlockPos loc, int distance) {
        HashSet matches = Sets.newHashSet();
        ChunkPos origin = new ChunkPos(loc);
        int dr = SectionPos.m_123171_((int)distance);
        dr = Math.max(dr, 1);
        for (int x = origin.f_45578_ - dr; x <= origin.f_45578_ + dr; ++x) {
            for (int z = origin.f_45579_ - dr; z <= origin.f_45579_ + dr; ++z) {
                matches.addAll(StructureManager.getNearInt(dim, loc, new ChunkPos(x, z), distance));
            }
        }
        return matches;
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load evt) {
        Level w;
        block8: {
            block7: {
                LevelAccessor levelAccessor = evt.getLevel();
                if (!(levelAccessor instanceof Level)) break block7;
                w = (Level)levelAccessor;
                if (!evt.getLevel().m_5776_()) break block8;
            }
            return;
        }
        ResourceKey dim = w.m_46472_();
        Registry reg = w.m_5962_().m_175515_(Registry.f_235725_);
        for (Map.Entry<Structure, StructureStart> entry : evt.getChunk().m_6633_().entrySet()) {
            String name = reg.m_7981_((Object)((Structure)entry.getKey())).toString();
            StructureInfo info = new StructureInfo(name, entry);
            if (!info.start.m_73603_()) continue;
            BoundingBox b = info.start.m_73601_();
            if (b.m_71056_() > 2560 || b.m_71058_() > 2560) {
                ThutCore.LOGGER.warn("Warning, too big box for {}: {}", (Object)info.getName(), (Object)b);
                continue;
            }
            for (int x = b.f_162356_ >> 4; x <= b.f_162359_ >> 4; ++x) {
                for (int z = b.f_162358_ >> 4; z <= b.f_162361_ >> 4; ++z) {
                    ChunkPos p = new ChunkPos(x, z);
                    GlobalChunkPos pos = new GlobalChunkPos((ResourceKey<Level>)dim, p);
                    Set<StructureInfo> set = StructureManager.getOrMake(pos);
                    set.add(info);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload evt) {
        if (!(evt.getLevel() instanceof Level) || evt.getLevel().m_5776_()) {
            return;
        }
        Level w = (Level)evt.getLevel();
        ResourceKey dim = w.m_46472_();
        GlobalChunkPos pos = new GlobalChunkPos((ResourceKey<Level>)dim, evt.getChunk().m_7697_());
        map_by_pos.remove(pos);
    }

    public static void clear() {
        map_by_pos.clear();
        ITerrainProvider.loadedChunks.clear();
        ITerrainProvider.pendingCache.clear();
    }

    public static class StructureInfo {
        private String name = null;
        public Structure feature;
        public StructureStart start;
        private int hash = -1;
        private String key;

        public StructureInfo(String name, Map.Entry<Structure, StructureStart> entry) {
            this.feature = entry.getKey();
            this.name = name;
            this.start = entry.getValue();
        }

        public StructureInfo(String name, Structure feature, StructureStart start) {
            this.feature = feature;
            this.name = name;
            this.start = start;
        }

        private BoundingBox inflate(BoundingBox other, int amt) {
            return new BoundingBox(other.m_162395_(), other.m_162396_(), other.m_162398_(), other.m_162399_(), other.m_162400_(), other.m_162401_()).m_191961_(amt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isNear(BlockPos pos, int distance) {
            if (this.start.m_73602_().isEmpty()) {
                return false;
            }
            if (!this.inflate(this.start.m_73601_(), distance).m_71051_((Vec3i)pos)) {
                return false;
            }
            List list = this.start.m_73602_();
            synchronized (list) {
                for (StructurePiece p1 : this.start.m_73602_()) {
                    if (!this.isIn(this.inflate(p1.m_73547_(), distance), pos)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isIn(BlockPos pos) {
            if (this.start.m_73602_().isEmpty()) {
                return false;
            }
            if (!this.start.m_73601_().m_71051_((Vec3i)pos)) {
                return false;
            }
            List list = this.start.m_73602_();
            synchronized (list) {
                for (StructurePiece p1 : this.start.m_73602_()) {
                    if (!this.isIn(p1.m_73547_(), pos)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isIn(BoundingBox b, BlockPos pos) {
            int x1 = pos.m_123341_();
            int y1 = pos.m_123342_();
            int z1 = pos.m_123343_();
            BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
            for (int x = x1; x < x1 + 4; ++x) {
                for (int y = y1; y < y1 + 4; ++y) {
                    for (int z = z1; z < z1 + 4; ++z) {
                        mpos.m_122178_(x, y, z);
                        if (!b.m_71051_((Vec3i)mpos)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == -1) {
                this.toString();
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StructureInfo)) {
                return false;
            }
            return obj.toString().equals(this.toString());
        }

        public String toString() {
            if (this.start.m_73602_().isEmpty()) {
                return this.getName();
            }
            if (this.key == null) {
                this.key = this.getName() + " " + this.start.m_73601_();
            }
            this.hash = this.key.hashCode();
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public boolean matches(@Nullable RegistryAccess reg, String key) {
            if (reg == null) {
                return key.equals(this.getName());
            }
            Registry regi = reg.m_175515_(Registry.f_235725_);
            List tags = regi.m_206081_((ResourceKey)regi.m_7854_((Object)this.feature).get()).m_203616_().toList();
            for (TagKey tag : tags) {
                if (!tag.f_203868_().toString().equals(key)) continue;
                return true;
            }
            return key.equals(this.getName());
        }
    }
}

