/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Material;
import thut.api.item.ItemList;
import thut.api.terrain.BiomeType;
import thut.api.util.JsonUtil;
import thut.core.common.ThutCore;

public class TerrainChecker {
    public static BiomeType INSIDE = BiomeType.getBiome("inside", true).setNoSave();
    public static ResourceLocation CAVETAG = new ResourceLocation("thutcore", "cave");
    public static ResourceLocation FRUITTAG = new ResourceLocation("thutcore", "fruit");
    public static ResourceLocation GROUNDTAG = new ResourceLocation("thutcore", "ground");
    public static ResourceLocation INDUSTRIALTAG = new ResourceLocation("thutcore", "industrial");
    public static ResourceLocation PLANTEATTAG = new ResourceLocation("thutcore", "plants_edible");
    public static ResourceLocation PLANTCUTTAG = new ResourceLocation("thutcore", "plants_cutable");
    public static ResourceLocation ROCKTAG = new ResourceLocation("thutcore", "rocks");
    public static ResourceLocation SURFACETAG = new ResourceLocation("thutcore", "surface");
    public static ResourceLocation TERRAINTAG = new ResourceLocation("thutcore", "terrain");
    public static ResourceLocation WOODTAG = new ResourceLocation("thutcore", "wood");
    public static ResourceLocation LEAVES = new ResourceLocation("minecraft:leaves");
    public static ResourceLocation FLOWERS = new ResourceLocation("minecraft:small_flowers");
    public static List<String> manualStructureSubbiomes = new ArrayList<String>();
    public static Map<String, List<TagKey<Structure>>> struct_config_map = Maps.newHashMap();

    public static void initStructMap() {
        Object key;
        StructInfo info;
        struct_config_map.clear();
        for (String s : ThutCore.getConfig().structure_subbiomes) {
            info = (StructInfo)JsonUtil.gson.fromJson(s, StructInfo.class);
            key = info.struct.replace("#", "");
            if (((String)key).contains(":")) {
                String[] args = ((String)key).split(":");
                key = ThutCore.trim(args[0]) + ":" + ThutCore.trim(args[1]);
            } else {
                key = ThutCore.trim((String)key);
            }
            ResourceLocation loc = new ResourceLocation((String)key);
            TagKey tagkey = TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)loc);
            struct_config_map.compute(info.subbiome, (name, list) -> {
                if (list == null) {
                    list = new ArrayList<TagKey>();
                }
                list.add(tagkey);
                return list;
            });
        }
        for (String s : manualStructureSubbiomes) {
            info = (StructInfo)JsonUtil.gson.fromJson(s, StructInfo.class);
            key = info.struct.replace("#", "");
            TagKey tagkey = TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation((String)key));
            struct_config_map.compute(info.subbiome, (name, list) -> {
                if (list == null) {
                    list = new ArrayList<TagKey>();
                }
                list.add(tagkey);
                return list;
            });
        }
    }

    public static boolean isCave(BlockState state) {
        return ItemList.is(CAVETAG, state);
    }

    public static boolean isGround(BlockState state) {
        return ItemList.is(GROUNDTAG, state);
    }

    public static boolean isFruit(BlockState state) {
        return ItemList.is(FRUITTAG, state);
    }

    public static boolean isIndustrial(BlockState state) {
        return ItemList.is(INDUSTRIALTAG, state);
    }

    private static boolean isPlant(Material m) {
        return m == Material.f_76300_ || m == Material.f_76302_ || m == Material.f_76304_ || m == Material.f_76301_;
    }

    public static boolean isEdiblePlant(BlockState state) {
        return ItemList.is(PLANTEATTAG, state) || ThutCore.getConfig().autoPopulateLists && TerrainChecker.isPlant(state.m_60767_());
    }

    public static boolean isCutablePlant(BlockState state) {
        return ItemList.is(PLANTEATTAG, state) || ItemList.is(BlockTags.f_13035_.f_203868_(), state) || ThutCore.getConfig().autoPopulateLists && TerrainChecker.isPlant(state.m_60767_());
    }

    public static boolean isRock(BlockState state) {
        return ItemList.is(ROCKTAG, state);
    }

    public static boolean isSurface(BlockState state) {
        return ItemList.is(SURFACETAG, state);
    }

    public static boolean isTerrain(BlockState state) {
        return ItemList.is(TERRAINTAG, state);
    }

    public static boolean isWood(BlockState state) {
        return ItemList.is(WOODTAG, state);
    }

    public static boolean isLeaves(BlockState state) {
        return ItemList.is(LEAVES, state);
    }

    public static boolean isFlower(BlockState state) {
        return ItemList.is(FLOWERS, state);
    }

    private static class StructInfo {
        public String struct;
        public String subbiome;

        private StructInfo() {
        }
    }
}

