/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import thut.api.maths.Vector3;
import thut.api.terrain.CapabilityTerrain;
import thut.api.terrain.ITerrainProvider;
import thut.api.terrain.TerrainSegment;
import thut.api.util.PermNodes;
import thut.core.common.network.TerrainUpdate;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TerrainManager {
    public static final String EDIT_SUBBIOMES_PERM = "subbiome.can_edit";
    public static final ResourceLocation TERRAINCAP = new ResourceLocation("thutcore", "terrain");
    private static TerrainManager terrain;
    public ITerrainProvider provider = new ITerrainProvider(){};

    public static void init() {
        PermNodes.registerBooleanNode("thutcore", EDIT_SUBBIOMES_PERM, PermNodes.DefaultPermissionLevel.OP, "Is the player allowed to edit subbiomes");
    }

    public static void clear() {
    }

    public static TerrainManager getInstance() {
        if (terrain == null) {
            terrain = new TerrainManager();
        }
        return terrain;
    }

    public static boolean isAreaLoaded(LevelAccessor world, Vector3 centre, double distance) {
        return TerrainManager.isAreaLoaded(world, centre.getPos(), distance);
    }

    public static boolean isAreaLoaded(LevelAccessor world, BlockPos blockPos, double distance) {
        if (world.m_7726_() == null) {
            return false;
        }
        ChunkSource source = world.m_7726_();
        int r = (int)distance >> 4;
        int x = blockPos.m_123341_() >> 4;
        int z = blockPos.m_123343_() >> 4;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                if (source.m_7131_(x + i, z + j) != null) continue;
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load evt) {
        ResourceKey dim = null;
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (!evt.getLevel().m_5776_()) {
                dim = level.m_46472_();
            }
        }
        if (dim != null) {
            ITerrainProvider.addChunk(dim, evt.getChunk());
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload evt) {
        ResourceKey dim = null;
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (!evt.getLevel().m_5776_()) {
                dim = level.m_46472_();
            }
        }
        if (dim != null) {
            ITerrainProvider.removeChunk(dim, evt.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        ServerPlayer player = event.getPlayer();
        TerrainUpdate.sendTerrainToClient(event.getPos(), player);
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload evt) {
    }

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<LevelChunk> event) {
        if (event.getCapabilities().containsKey(TERRAINCAP)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)event.getObject();
        CapabilityTerrain.DefaultProvider terrain = new CapabilityTerrain.DefaultProvider((ChunkAccess)chunk);
        event.addCapability(TERRAINCAP, (ICapabilityProvider)terrain);
    }

    public TerrainSegment getTerrain(LevelAccessor world, BlockPos p) {
        return this.provider.getTerrain(world, p);
    }

    public TerrainSegment getTerrain(LevelAccessor world, double x, double y, double z) {
        BlockPos pos = new BlockPos(x, y, z);
        TerrainSegment ret = this.getTerrain(world, pos);
        if (world instanceof ServerLevel) {
            ret.initBiomes(world);
        }
        return ret;
    }

    public TerrainSegment getTerrainForEntity(Entity e) {
        if (e == null) {
            return null;
        }
        return this.getTerrain((LevelAccessor)e.m_9236_(), e.m_20185_(), e.m_20186_(), e.m_20189_());
    }

    public TerrainSegment getTerrian(LevelAccessor world, Vector3 v) {
        return this.getTerrain(world, v.x, v.y, v.z);
    }
}

