/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeType;
import thut.core.common.ThutCore;

public class TerrainSegment {
    public static final int GRIDSIZE = 4;
    public static final int YSHIFT = 4;
    public static final int ZSHIFT = 16;
    public static final int TOTAL = 64;
    public static ISubBiomeChecker defaultChecker = new DefaultChecker();
    public static List<ISubBiomeChecker> biomeCheckers = Lists.newArrayList();
    private static Set<Class<? extends ITerrainEffect>> terrainEffectClasses = Sets.newHashSet();
    public static boolean noLoad = false;
    public static Predicate<BiomeType> saveChecker = i -> i.shouldSave();
    public Int2IntMap idReplacements;
    public final int chunkX;
    public final int chunkY;
    public final int chunkZ;
    public final BlockPos pos;
    public ChunkAccess chunk;
    public boolean toSave = false;
    public boolean isSky = false;
    public boolean init = true;
    public boolean real = false;
    Vector3 temp = new Vector3();
    Vector3 temp1 = new Vector3();
    Vector3 mid = new Vector3();
    protected int[] biomes = new int[64];
    HashMap<String, ITerrainEffect> effects = new HashMap();
    public final ITerrainEffect[] effectArr;

    public static void registerTerrainEffect(Class<? extends ITerrainEffect> effect) {
        terrainEffectClasses.add(effect);
    }

    public static int count(LevelAccessor world, Block b, Vector3 v, int range) {
        Vector3 temp = new Vector3();
        temp.set(v);
        int ret = 0;
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    boolean bool = true;
                    int i1 = Mth.m_14143_((float)(v.intX() + i)) >> 4;
                    int k1 = Mth.m_14143_((float)(v.intZ() + i)) >> 4;
                    boolean bl = bool = i1 == v.intX() >> 4 && k1 == v.intZ() >> 4;
                    if (!bool) continue;
                    temp.set(v).addTo(i, j, k);
                    BlockState state = world.m_8055_(temp.getPos());
                    if (state.m_60734_() != b && (b != null || state.m_60734_() != null)) continue;
                    ++ret;
                }
            }
        }
        return ret;
    }

    public static int toLocal(int globalPos) {
        return (globalPos & 0xF) / 4;
    }

    public static int toGlobal(int localPos, int chunkPos) {
        return (chunkPos << 4) + (localPos << 4) / 4;
    }

    public static int globalToIndex(int x, int y, int z) {
        int relX = TerrainSegment.toLocal(x);
        int relY = TerrainSegment.toLocal(y);
        int relZ = TerrainSegment.toLocal(z);
        return TerrainSegment.localToIndex(relX, relY, relZ);
    }

    public static int localToIndex(int x, int y, int z) {
        return x + 4 * y + 16 * z;
    }

    public static boolean isInTerrainColumn(Vector3 t, Vector3 point) {
        boolean ret = true;
        int i = point.intX() >> 4;
        int k = point.intZ() >> 4;
        ret = i == t.intX() && k == t.intZ();
        return ret;
    }

    public static void readFromNBT(TerrainSegment t, CompoundTag nbt) {
        if (noLoad) {
            return;
        }
        int[] biomes = nbt.m_128465_("biomes");
        t.init = t.toSave = nbt.m_128471_("toSave");
        boolean replacements = false;
        if (t.idReplacements != null) {
            for (int i = 0; i < biomes.length; ++i) {
                if (!t.idReplacements.containsKey(biomes[i])) continue;
                biomes[i] = t.idReplacements.get(biomes[i]);
                replacements = true;
            }
        }
        if (nbt.m_128441_("effects")) {
            CompoundTag effects = nbt.m_128469_("effects");
            for (String key : effects.m_128431_()) {
                CompoundTag load = effects.m_128469_(key);
                ITerrainEffect effect = t.effects.get(key);
                if (effect == null) continue;
                effect.readFromNBT(load);
            }
        }
        if (replacements && ThutCore.conf.debug) {
            ThutCore.LOGGER.info("Replacement subbiomes found for " + t.chunkX + " " + t.chunkY + " " + t.chunkZ);
        }
        t.setBiomes(biomes);
    }

    public TerrainSegment(BlockPos pos) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public TerrainSegment(int x, int y, int z) {
        this.chunkX = x;
        this.chunkY = y;
        this.chunkZ = z;
        this.pos = new BlockPos(x, y, z);
        Arrays.fill(this.biomes, -1);
        this.mid.set(this.chunkX * 16 + 8, this.chunkY * 16 + 8, this.chunkZ * 16 + 8);
        for (Class<? extends ITerrainEffect> clas : terrainEffectClasses) {
            try {
                ITerrainEffect effect = clas.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.addEffect(effect, effect.getIdentifier());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList toSort = Lists.newArrayList(this.effects.values());
        toSort.sort(Comparator.comparing(ITerrainEffect::getIdentifier));
        this.effectArr = toSort.toArray(new ITerrainEffect[0]);
    }

    private void addEffect(ITerrainEffect effect, String name) {
        effect.bindToTerrain(this.chunkX, this.chunkY, this.chunkZ);
        this.effects.put(name, effect);
    }

    public BiomeType adjustedCaveBiome(LevelAccessor world, Vector3 v) {
        return this.getBiome(world, v, true);
    }

    public BiomeType adjustedNonCaveBiome(LevelAccessor world, Vector3 v) {
        return this.getBiome(world, v, false);
    }

    void checkToSave() {
        for (int i : this.biomes) {
            if (!saveChecker.test(BiomeType.getType(i))) continue;
            this.toSave = true;
            return;
        }
        this.toSave = false;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof TerrainSegment) {
            TerrainSegment seg = (TerrainSegment)o;
            ret = seg.chunkX == this.chunkX && seg.chunkY == this.chunkY && seg.chunkZ == this.chunkZ;
        }
        return ret;
    }

    public double getAverageSlope(Level world, Vector3 point, int range) {
        double slope = 0.0;
        double prevY = point.getMaxY((LevelAccessor)world);
        double dy = 0.0;
        double dz = 0.0;
        this.temp1.set(this.temp);
        this.temp.set(point);
        int count = 0;
        for (int i = -range; i <= range; ++i) {
            dz = 0.0;
            for (int j = -range; j <= range; ++j) {
                if (TerrainSegment.isInTerrainColumn(point, this.temp.addTo(i, 0.0, j))) {
                    dy += Math.abs((double)point.getMaxY((LevelAccessor)world, point.intX() + i, point.intZ() + j) - prevY);
                }
                dz += 1.0;
                ++count;
                this.temp.set(point);
            }
            slope += dy / dz;
        }
        this.temp.set(this.temp1);
        return slope / (double)count;
    }

    public BiomeType getBiome(int x, int y, int z) {
        int ret = 0;
        int index = TerrainSegment.globalToIndex(x, y, z);
        if (index < 64) {
            ret = this.biomes[index];
        }
        return BiomeType.getType(ret);
    }

    public BiomeType getBiome(Vector3 v) {
        return this.getBiome(v.intX(), v.intY(), v.intZ());
    }

    private BiomeType getBiome(LevelAccessor world, Vector3 v, boolean caveAdjust) {
        if (!this.real) {
            return BiomeType.NONE;
        }
        if (this.chunk == null) {
            Thread.dumpStack();
            return BiomeType.NONE;
        }
        if (!biomeCheckers.isEmpty()) {
            for (ISubBiomeChecker checker : biomeCheckers) {
                BiomeType biome = checker.getSubBiome(world, v, this, caveAdjust);
                if (biome.isNone()) continue;
                return biome;
            }
        }
        return defaultChecker.getSubBiome(world, v, this, caveAdjust);
    }

    public Vector3 getCentre() {
        return this.mid;
    }

    public BlockPos getChunkCoords() {
        return this.pos;
    }

    public Collection<ITerrainEffect> getEffects() {
        return this.effects.values();
    }

    public ITerrainEffect geTerrainEffect(String name) {
        return this.effects.get(name);
    }

    public int hashCode() {
        return this.chunkX + this.chunkZ << 8 << 8 + this.chunkY;
    }

    public void initBiomes(LevelAccessor world) {
        if (this.init && world instanceof ServerLevel) {
            this.init = false;
            this.refresh(world);
        }
    }

    public boolean isInTerrainSegment(double x, double y, double z) {
        boolean ret = true;
        int i = Mth.m_14107_((double)x) >> 4;
        int j = Mth.m_14107_((double)y) >> 4;
        int k = Mth.m_14107_((double)z) >> 4;
        ret = i == this.chunkX && k == this.chunkZ && j == this.chunkY;
        return ret;
    }

    public void refresh(LevelAccessor world) {
        long time = System.nanoTime();
        if (!this.real) {
            this.init = true;
            return;
        }
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    int index = TerrainSegment.localToIndex(x, y, z);
                    if (saveChecker.test(BiomeType.getType(this.biomes[index])) && !noLoad) continue;
                    this.temp.set(TerrainSegment.toGlobal(x, this.chunkX), TerrainSegment.toGlobal(y, this.chunkY), TerrainSegment.toGlobal(z, this.chunkZ));
                    BiomeType biome = this.adjustedCaveBiome(world, this.temp);
                    if (biome.isNone()) {
                        biome = this.adjustedNonCaveBiome(world, this.temp);
                    }
                    if (biome.isNone()) continue;
                    if (saveChecker.test(biome)) {
                        this.toSave = true;
                    }
                    this.biomes[index] = biome.getType();
                }
            }
        }
        double dt = (double)(System.nanoTime() - time) / 1.0E10;
        if (dt > 0.001) {
            ThutCore.LOGGER.debug("subBiome refresh took " + dt);
        }
    }

    public void saveToNBT(CompoundTag nbt) {
        if (!this.toSave) {
            return;
        }
        nbt.m_128385_("biomes", this.biomes);
        nbt.m_128405_("x", this.chunkX);
        nbt.m_128405_("y", this.chunkY);
        nbt.m_128405_("z", this.chunkZ);
        nbt.m_128379_("toSave", this.toSave);
        if (!this.effects.isEmpty()) {
            CompoundTag effects = new CompoundTag();
            for (Map.Entry<String, ITerrainEffect> entry : this.effects.entrySet()) {
                CompoundTag tag = new CompoundTag();
                entry.getValue().writeToNBT(tag);
                if (tag.m_128456_()) continue;
                effects.m_128365_(entry.getKey(), (Tag)tag);
            }
            if (!effects.m_128456_()) {
                nbt.m_128365_("effects", (Tag)effects);
            }
        }
    }

    public void setBiome(BlockPos p, BiomeType type) {
        this.setBiome(p.m_123341_(), p.m_123342_(), p.m_123343_(), type);
    }

    public void setBiome(int x, int y, int z, BiomeType biome) {
        int index = TerrainSegment.globalToIndex(x, y, z);
        this.biomes[index] = biome.getType();
        if (saveChecker.test(biome)) {
            this.toSave = true;
        }
    }

    public void setBiomes(int[] biomes) {
        if (biomes.length == this.biomes.length) {
            this.biomes = biomes;
        } else {
            for (int i = 0; i < biomes.length; ++i) {
                if (i >= this.biomes.length) {
                    return;
                }
                this.biomes[i] = biomes[i];
            }
        }
    }

    public void setBiome(Vector3 v, BiomeType i) {
        this.setBiome(v.intX(), v.intY(), v.intZ(), i);
    }

    public String toString() {
        String ret = "Terrian Segment " + this.chunkX + "," + this.chunkY + "," + this.chunkZ + " Centre:" + this.getCentre();
        String eol = System.getProperty("line.separator");
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                Object line = "[";
                for (int z = 0; z < 4; ++z) {
                    line = (String)line + this.biomes[TerrainSegment.localToIndex(x, y, z)];
                    if (z == 3) continue;
                    line = (String)line + ", ";
                }
                line = (String)line + "]";
                ret = ret + eol + (String)line;
            }
        }
        return ret;
    }

    public static interface ITerrainEffect {
        public void bindToTerrain(int var1, int var2, int var3);

        public void doEffect(LivingEntity var1, boolean var2);

        public String getIdentifier();

        public void readFromNBT(CompoundTag var1);

        public void writeToNBT(CompoundTag var1);
    }

    public static interface ISubBiomeChecker {
        public static final TagKey<Biome> WATERY = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("thutcore:is_watery"));

        public BiomeType getSubBiome(LevelAccessor var1, Vector3 var2, TerrainSegment var3, boolean var4);

        default public boolean isWatery(Holder<Biome> b) {
            return b.m_203656_(WATERY);
        }
    }

    public static class DefaultChecker
    implements ISubBiomeChecker {
        @Override
        public BiomeType getSubBiome(LevelAccessor world, Vector3 v, TerrainSegment segment, boolean caveAdjusted) {
            if (caveAdjusted) {
                if (world.m_6042_().f_63856_()) {
                    return BiomeType.NONE;
                }
                boolean sky = false;
                Vector3 temp1 = new Vector3();
                int x0 = segment.chunkX * 16;
                int y0 = segment.chunkY * 16;
                int z0 = segment.chunkZ * 16;
                int dx = (v.intX() - x0) / 4 * 4;
                int dy = (v.intY() - y0) / 4 * 4;
                int dz = (v.intZ() - z0) / 4 * 4;
                int x1 = x0 + dx;
                int y1 = y0 + dy;
                int z1 = z0 + dz;
                block0: for (int i = x1; i < x1 + 4; ++i) {
                    for (int j = y1; j < y1 + 4; ++j) {
                        for (int k = z1; k < z1 + 4; ++k) {
                            temp1.set(i, j, k);
                            if (segment.isInTerrainSegment(temp1.x, temp1.y, temp1.z)) {
                                double y = temp1.getMaxY(world);
                                boolean bl = sky = y <= temp1.y;
                            }
                            if (sky) break block0;
                        }
                    }
                }
                if (sky) {
                    return BiomeType.NONE;
                }
                if (!sky && TerrainSegment.count(world, Blocks.f_49990_, v, 1) > 2) {
                    return BiomeType.CAVE_WATER;
                }
                if (!sky) {
                    return BiomeType.CAVE;
                }
            } else {
                BlockPos pos;
                ServerLevel level;
                int water;
                BiomeType biome = BiomeType.NONE;
                Holder<Biome> b = v.getBiomeHolder(world);
                boolean notLake = this.isWatery(b);
                if (!notLake && (water = TerrainSegment.count(world, Blocks.f_49990_, v, 3)) > 4) {
                    biome = BiomeType.LAKE;
                    return biome;
                }
                if (world instanceof ServerLevel && (level = (ServerLevel)world).m_8802_(pos = v.getPos())) {
                    biome = BiomeType.VILLAGE;
                }
                return biome;
            }
            return BiomeType.NONE;
        }
    }
}

