/*
 * Decompiled with CFR 0.152.
 */
package thut.api.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import thut.lib.TComponent;

public class PermNodes {
    public static final GameProfile testProfile = new GameProfile(new UUID(1234567987L, 123545787L), "_permtest_");
    public static ServerPlayer testPlayer;
    private static final Map<String, PermissionNode<?>> NODES;
    private static final Map<String, StringSetPermCache> STRINGS;

    public static PermissionNode<Boolean> getBooleanNode(String name) {
        return NODES.get(name);
    }

    public static PermissionNode<String> getStringNode(String name) {
        return NODES.get(name);
    }

    public static StringSetPermCache getStringCache(String name) {
        return STRINGS.get(name);
    }

    public static boolean hasStringInList(ServerPlayer player, String perm, String value) {
        StringSetPermCache cache = PermNodes.getStringCache(perm);
        return cache.contains(player, value);
    }

    public static boolean getBooleanPerm(ServerPlayer player, String name) {
        PermissionNode<Boolean> node = PermNodes.getBooleanNode(name);
        return (Boolean)PermissionAPI.getPermission((ServerPlayer)player, node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
    }

    public static void registerBooleanNode(String modid, String name, DefaultPermissionLevel level, String message) {
        PermissionNode node = new PermissionNode(modid, name, PermissionTypes.BOOLEAN, (player, playerUUID, context) -> level.matches(playerUUID), new PermissionDynamicContextKey[0]);
        node.setInformation((Component)TComponent.literal(node.getNodeName()), (Component)TComponent.literal(message));
        NODES.put(name, node);
        NODES.put(node.getNodeName(), node);
    }

    public static void registerStringNode(String modid, String name, DefaultPermissionLevel level, String message, String _default) {
        PermissionNode node = new PermissionNode(modid, name, PermissionTypes.STRING, (player, playerUUID, context) -> _default, new PermissionDynamicContextKey[0]);
        node.setInformation((Component)TComponent.literal(node.getNodeName()), (Component)TComponent.literal(message));
        NODES.put(name, node);
        NODES.put(node.getNodeName(), node);
        STRINGS.put(name, new StringSetPermCache(name));
        STRINGS.put(node.getNodeName(), new StringSetPermCache(node.getNodeName()));
    }

    public static void registerIntegerNode(String modid, String name, DefaultPermissionLevel level, String message, Integer _default) {
        PermissionNode node = new PermissionNode(modid, name, PermissionTypes.INTEGER, (player, playerUUID, context) -> _default, new PermissionDynamicContextKey[0]);
        node.setInformation((Component)TComponent.literal(node.getNodeName()), (Component)TComponent.literal(message));
        NODES.put(name, node);
        NODES.put(node.getNodeName(), node);
    }

    public static void registerNode(PermissionNode<?> node) {
        NODES.put(node.getNodeName(), node);
    }

    public static void gatherPerms(PermissionGatherEvent.Nodes event) {
        StringSetPermCache.CACHES.forEach(e -> e.invalidateAll());
        HashSet nodes = Sets.newHashSet();
        nodes.addAll(NODES.values());
        nodes.forEach(node -> {
            if (!event.getNodes().contains(node)) {
                event.addNodes(new PermissionNode[]{node});
            }
        });
    }

    static {
        NODES = Maps.newHashMap();
        STRINGS = Maps.newHashMap();
    }

    public static class StringSetPermCache {
        private static final Set<LoadingCache<?, ?>> CACHES = Sets.newHashSet();
        private final LoadingCache<ServerPlayer, StringSetCache> cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<ServerPlayer, StringSetCache>(){

            public StringSetCache load(ServerPlayer key) throws Exception {
                PermissionNode<String> node = PermNodes.getStringNode(key);
                StringSetCache ret = new StringSetCache();
                ret.setValue((String)PermissionAPI.getPermission((ServerPlayer)key, node, (PermissionDynamicContext[])new PermissionDynamicContext[0]));
                return ret;
            }
        });
        private final String key;

        public StringSetPermCache(String key) {
            CACHES.add(this.cache);
            this.key = key;
        }

        public boolean contains(ServerPlayer player, String input) {
            try {
                StringSetCache cache = (StringSetCache)this.cache.get((Object)player);
                PermissionNode<String> node = PermNodes.getStringNode(this.key);
                cache.setValue((String)PermissionAPI.getPermission((ServerPlayer)player, node, (PermissionDynamicContext[])new PermissionDynamicContext[0]));
                return cache.contains(input);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        private static class StringSetCache {
            private String value = "";
            private Set<String> values = Sets.newHashSet();

            private StringSetCache() {
            }

            public boolean contains(String input) {
                return this.values.contains(input);
            }

            private void setValue(String permission) {
                String[] split;
                if (this.value.equals(permission)) {
                    return;
                }
                this.value = permission;
                this.values.clear();
                for (String s : split = this.value.split(",")) {
                    this.values.add(s.strip());
                }
            }
        }
    }

    public static enum DefaultPermissionLevel {
        ALL,
        OP,
        NONE;


        public boolean matches(UUID player) {
            if (this == NONE) {
                return false;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            Optional profile = server != null ? server.m_129927_().m_11002_(player) : Optional.empty();
            boolean op = false;
            op = profile.isPresent() ? server.m_6846_().m_11303_((GameProfile)profile.get()) : server.m_6846_().m_11303_(testProfile);
            return op ? true : this == ALL;
        }
    }
}

