/*
 * Decompiled with CFR 0.152.
 */
package thut.api.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureTemplateTools {
    private static final BlockPlacer DEFAULT = new BlockPlacer(){};
    public static Map<Block, BlockPlacer> placers = Maps.newHashMap();

    public static BlockPlacer getPlacer(BlockState toPlace) {
        if (toPlace == null) {
            return DEFAULT;
        }
        return placers.getOrDefault(toPlace.m_60734_(), DEFAULT);
    }

    public static ItemStack getForInfo(StructureTemplate.StructureBlockInfo info) {
        return StructureTemplateTools.getPlacer(info.f_74676_).getForBlock(info.f_74676_);
    }

    public static Map<BlockPos, ItemStack> getNeededMaterials(ServerLevel level, List<StructureTemplate.StructureBlockInfo> infos, int startIndex, int endIndex) {
        endIndex = Math.min(endIndex, infos.size() - 1);
        HashMap tmp = Maps.newHashMap();
        HashMap neededItems = Maps.newHashMap();
        for (int i = startIndex; i <= endIndex; ++i) {
            ItemStack newStack;
            StructureTemplate.StructureBlockInfo info = infos.get(i);
            if (info.f_74676_ == null || info.f_74676_.m_60795_()) continue;
            BlockPlacer placer = StructureTemplateTools.getPlacer(info.f_74676_);
            BlockState old = level.m_8055_(info.f_74675_);
            if (old.m_60734_() == info.f_74676_.m_60734_() || (newStack = placer.getForBlock(info.f_74676_)).m_41619_()) continue;
            Item item = newStack.m_41720_();
            ItemStack stack = (ItemStack)tmp.get(item);
            if (stack == null) {
                stack = newStack;
            } else {
                stack.m_41764_(stack.m_41613_() + 1);
            }
            tmp.put(item, stack);
            neededItems.put(info.f_74675_, stack);
        }
        return neededItems;
    }

    public static Map<BlockPos, ItemStack> getNeededMaterials(ServerLevel level, List<StructureTemplate.StructureBlockInfo> infos) {
        return StructureTemplateTools.getNeededMaterials(level, infos, 0, infos.size() - 1);
    }

    public static List<BlockPos> getNeedsRemoval(ServerLevel level, StructurePlaceSettings settings, List<StructureTemplate.StructureBlockInfo> infos) {
        ArrayList remove = Lists.newArrayList();
        for (StructureTemplate.StructureBlockInfo info : infos) {
            BlockState old;
            if (info.f_74676_ == null || (old = level.m_8055_(info.f_74675_)).m_60795_() || old.m_60734_() == info.f_74676_.m_60734_()) continue;
            remove.add(info.f_74675_);
        }
        return remove;
    }

    public static interface BlockPlacer {
        default public ItemStack getForBlock(BlockState state) {
            if (state == null) {
                return ItemStack.f_41583_;
            }
            if (state.m_61138_((Property)BedBlock.f_49440_) && state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
                return ItemStack.f_41583_;
            }
            if (state.m_61138_((Property)DoorBlock.f_52730_) && state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
                return ItemStack.f_41583_;
            }
            Item item = state.m_60734_().m_5456_();
            if (item != null) {
                return new ItemStack((ItemLike)item);
            }
            return ItemStack.f_41583_;
        }

        default public void placeBlock(BlockState state, BlockPos pos, ServerLevel level) {
            level.m_46597_(pos, state);
            if (state.m_61138_((Property)BedBlock.f_49440_) && state.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
                level.m_46597_(pos.m_121945_((Direction)state.m_61143_((Property)BedBlock.f_54117_)), (BlockState)state.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD));
            }
            if (state.m_61138_((Property)DoorBlock.f_52730_) && state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
                level.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER));
            }
        }
    }
}

