/*
 * Decompiled with CFR 0.152.
 */
package thut.api.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import thut.api.world.IPathHelper;
import thut.api.world.IWorldTickListener;
import thut.core.common.ThutCore;

public class WorldTickManager {
    public static List<StaticData> staticData = Lists.newArrayList();
    static Map<ResourceKey<Level>, WorldData> dataMap = Maps.newHashMap();
    public static Map<ResourceKey<Level>, List<IPathHelper>> pathHelpers = Maps.newHashMap();

    public static void registerStaticData(Supplier<IWorldTickListener> data, Predicate<ResourceKey<Level>> valid) {
        staticData.add(new StaticData(data, valid));
    }

    public static void addWorldData(ResourceKey<Level> key, IWorldTickListener data) {
        WorldData holder = dataMap.get(key);
        if (holder == null) {
            ThutCore.LOGGER.error("Adding Data before load???");
            return;
        }
        holder.addData(data);
    }

    public static void removeWorldData(ResourceKey<Level> key, IWorldTickListener data) {
        WorldData holder = dataMap.get(key);
        if (holder == null) {
            ThutCore.LOGGER.error("Removing Data before load???");
            return;
        }
        holder.removeData(data);
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ResourceKey key = level.m_46472_();
        if (dataMap.containsKey(key)) {
            dataMap.get(key).detach();
        }
        WorldData data = new WorldData(level);
        dataMap.put((ResourceKey<Level>)key, data);
        staticData.forEach(s -> {
            if (s.valid.test((ResourceKey<Level>)key)) {
                data.addData(s.data.get());
            }
        });
        pathHelpers.put((ResourceKey<Level>)key, Lists.newArrayList());
    }

    public static void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ResourceKey key = level.m_46472_();
        if (dataMap.containsKey(key)) {
            dataMap.remove(key).detach();
        }
        pathHelpers.remove(key);
    }

    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.level instanceof ServerLevel) {
            ResourceKey key = event.level.m_46472_();
            WorldData data = dataMap.get(key);
            if (data == null) {
                ThutCore.LOGGER.error("Ticking world before load???");
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                data.onWorldTickEnd();
            } else {
                data.onWorldTickStart();
            }
        }
    }

    public static class StaticData {
        public final Predicate<ResourceKey<Level>> valid;
        public final Supplier<IWorldTickListener> data;

        public StaticData(Supplier<IWorldTickListener> data, Predicate<ResourceKey<Level>> valid) {
            this.data = data;
            this.valid = valid;
        }
    }

    private static class WorldData {
        private final List<IWorldTickListener> data = Lists.newArrayList();
        private final ServerLevel world;
        private final List<IWorldTickListener> pendingRemove = Lists.newArrayList();
        private final List<IWorldTickListener> pendingAdd = Lists.newArrayList();
        private boolean ticking = false;

        public WorldData(ServerLevel world) {
            this.world = world;
        }

        public void onWorldTickEnd() {
            this.ticking = true;
            for (IWorldTickListener data : this.data) {
                data.onTickEnd(this.world);
            }
            this.ticking = false;
            for (IWorldTickListener data : this.pendingRemove) {
                this.removeData(data);
            }
            for (IWorldTickListener data : this.pendingAdd) {
                this.addData(data);
            }
            this.pendingRemove.clear();
            this.pendingAdd.clear();
        }

        public void onWorldTickStart() {
            this.ticking = true;
            for (IWorldTickListener data : this.data) {
                data.onTickStart(this.world);
            }
            this.ticking = false;
            for (IWorldTickListener data : this.pendingRemove) {
                this.removeData(data);
            }
            for (IWorldTickListener data : this.pendingAdd) {
                this.addData(data);
            }
            this.pendingRemove.clear();
            this.pendingAdd.clear();
        }

        public void addData(IWorldTickListener data) {
            if (this.data.contains(data)) {
                return;
            }
            data.onAttach(this.world);
            if (!this.ticking) {
                this.data.add(data);
            } else {
                this.pendingAdd.add(data);
            }
        }

        public void removeData(IWorldTickListener data) {
            if (!this.ticking) {
                if (!this.data.remove(data)) {
                    return;
                }
                data.onDetach(this.world);
            } else {
                this.pendingRemove.add(data);
            }
        }

        public void detach() {
            for (IWorldTickListener data : this.data) {
                data.onDetach(this.world);
            }
        }
    }
}

