/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.nfunk.jep.JEP;
import thut.api.entity.animation.Animation;
import thut.api.entity.animation.AnimationComponent;
import thut.api.entity.animation.Animators;
import thut.core.client.render.animation.AnimationXML;
import thut.core.common.ThutCore;

public class AnimationBuilder {
    private static void addTo(Animation animation, int priority, String part, Animators.IAnimator parts) {
        if (animation.sets.containsKey(part) && animation.priority > priority) {
            ThutCore.LOGGER.warn("Already have " + part + ", Skipping.");
        } else {
            animation.sets.put(part, parts);
        }
    }

    public static Animation build(AnimationXML.Phase node, Set<String> valid_names, @Nullable Animation.IPartRenamer renamer) {
        Animation ret = null;
        if (node.type == null) {
            return null;
        }
        String animName = ThutCore.trim(node.type);
        ret = new Animation();
        ret.name = animName;
        ret.loops = true;
        if (AnimationBuilder.get(node, "loops") != null) {
            ret.loops = Boolean.parseBoolean(AnimationBuilder.get(node, "loops"));
        }
        for (AnimationXML.Part part : node.parts) {
            boolean regex = part.name.startsWith("*");
            ArrayList partNames = Lists.newArrayList();
            if (regex) {
                String key = part.name.substring(1).toLowerCase(Locale.ROOT).replace(" ", "_");
                for (String s : valid_names) {
                    if (!s.matches(key)) continue;
                    partNames.add(s);
                }
            } else {
                String[] subParts = part.name.split(":");
                for (String s : subParts) {
                    String partName = ThutCore.trim(s);
                    if (renamer != null) {
                        String[] names = new String[]{partName};
                        renamer.convertToIdents(names);
                        partName = names[0];
                    }
                    partNames.add(partName);
                }
            }
            block3: for (String partName : partNames) {
                ArrayList set = Lists.newArrayList();
                for (AnimationXML.Component component : part.components) {
                    String[] vals;
                    if (!(component.rotFuncs.isBlank() && component.posFuncs.isBlank() && component.scaleFuncs.isBlank())) {
                        JEP[] rots = new JEP[3];
                        JEP[] pos = new JEP[3];
                        JEP[] scale = new JEP[3];
                        if (!component.rotFuncs.isBlank()) {
                            Animators.FunctionAnimation.fillJEPs(rots, component.rotFuncs);
                        }
                        if (!component.posFuncs.isBlank()) {
                            Animators.FunctionAnimation.fillJEPs(rots, component.posFuncs);
                        }
                        if (!component.scaleFuncs.isBlank()) {
                            Animators.FunctionAnimation.fillJEPs(rots, component.scaleFuncs);
                        }
                        Animators.FunctionAnimation anim = new Animators.FunctionAnimation(rots, pos, scale);
                        anim.setHidden(component.hidden);
                        ret.sets.put(partName, anim);
                        continue block3;
                    }
                    AnimationComponent comp = new AnimationComponent();
                    if (component.name != null) {
                        comp.name = component.name;
                    }
                    if (component.rotChange != null) {
                        vals = component.rotChange.split(",");
                        comp.rotChange[0] = Double.parseDouble(vals[0]);
                        comp.rotChange[1] = Double.parseDouble(vals[1]);
                        comp.rotChange[2] = Double.parseDouble(vals[2]);
                    }
                    if (component.posChange != null) {
                        vals = component.posChange.split(",");
                        comp.posChange[0] = Double.parseDouble(vals[0]);
                        comp.posChange[1] = Double.parseDouble(vals[1]);
                        comp.posChange[2] = Double.parseDouble(vals[2]);
                    }
                    if (component.scaleChange != null) {
                        vals = component.scaleChange.split(",");
                        comp.scaleChange[0] = Double.parseDouble(vals[0]);
                        comp.scaleChange[1] = Double.parseDouble(vals[1]);
                        comp.scaleChange[2] = Double.parseDouble(vals[2]);
                    }
                    if (component.rotOffset != null) {
                        vals = component.rotOffset.split(",");
                        comp.rotOffset[0] = Double.parseDouble(vals[0]);
                        comp.rotOffset[1] = Double.parseDouble(vals[1]);
                        comp.rotOffset[2] = Double.parseDouble(vals[2]);
                    }
                    if (component.posOffset != null) {
                        vals = component.posOffset.split(",");
                        comp.posOffset[0] = Double.parseDouble(vals[0]);
                        comp.posOffset[1] = Double.parseDouble(vals[1]);
                        comp.posOffset[2] = Double.parseDouble(vals[2]);
                    }
                    if (component.scaleOffset != null) {
                        vals = component.scaleOffset.split(",");
                        comp.scaleOffset[0] = Double.parseDouble(vals[0]);
                        comp.scaleOffset[1] = Double.parseDouble(vals[1]);
                        comp.scaleOffset[2] = Double.parseDouble(vals[2]);
                    }
                    comp.length = component.length;
                    comp.startKey = component.startKey;
                    comp.opacityChange = component.opacityChange;
                    comp.opacityOffset = component.opacityOffset;
                    comp.hidden = component.hidden;
                    set.add(comp);
                }
                if (set.isEmpty()) continue;
                ret.sets.put(partName, new Animators.KeyframeAnimator(set));
            }
        }
        return ret;
    }

    private static String get(AnimationXML.Phase node, String string) {
        return node.values.get(new QName(string));
    }

    private static Animation mergeAnimations(List<Animation> list) {
        if (list.isEmpty()) {
            return null;
        }
        Animation newAnim = new Animation();
        newAnim.name = list.get((int)0).name;
        newAnim.identifier = list.get((int)0).identifier;
        newAnim.loops = list.get((int)0).loops;
        newAnim.priority = list.get((int)0).priority;
        for (Animation anim : list) {
            for (String part : anim.sets.keySet()) {
                AnimationBuilder.addTo(newAnim, anim.priority, part, anim.sets.get(part));
            }
        }
        return newAnim;
    }

    public static void processAnimations(List<Animation> list) {
        ArrayList oldList = Lists.newArrayList(list);
        HashMap splitAnims = Maps.newHashMap();
        for (Animation anim : oldList) {
            AnimationBuilder.splitAnimation(anim, splitAnims);
        }
        list.clear();
        for (List split : splitAnims.values()) {
            list.add(AnimationBuilder.mergeAnimations(split));
        }
    }

    private static void splitAnimation(Animation animIn, Map<Integer, List<Animation>> fill) {
        if (animIn == null) {
            return;
        }
        for (Map.Entry<String, Animators.IAnimator> entry : animIn.sets.entrySet()) {
            String key = entry.getKey();
            Animators.IAnimator comps = entry.getValue();
            int length = comps.getLength();
            ArrayList anims = fill.get(length);
            if (anims == null) {
                anims = Lists.newArrayList();
                fill.put(length, anims);
            }
            Animation newAnim = new Animation();
            newAnim.name = animIn.name;
            newAnim.identifier = animIn.identifier;
            newAnim.loops = animIn.loops;
            newAnim.priority = animIn.priority;
            newAnim.sets.put(key, comps);
            anims.add(newAnim);
        }
    }
}

