/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thut.api.ThutCaps;
import thut.api.entity.IAnimated;
import thut.api.entity.IMobColourable;
import thut.api.entity.IShearable;
import thut.api.entity.ShearableCaps;
import thut.api.entity.animation.Animation;
import thut.core.client.render.animation.IAnimationChanger;

public class AnimationChanger
implements IAnimationChanger {
    List<IAnimationChanger> children = Lists.newArrayList();
    public final Set<String> shearables = new ObjectOpenHashSet();
    public final Set<String> dyeables = new ObjectOpenHashSet();
    public final Map<String, Function<Integer, Integer>> colourOffsets = new Object2ObjectOpenHashMap();
    public final Map<String, IAnimationChanger.WornOffsets> wornOffsets = new Object2ObjectOpenHashMap();
    private final Set<String> checkWildCard = new ObjectOpenHashSet();
    IAnimated.IAnimationHolder currentHolder = null;

    @Override
    public void reset() {
        this.children.clear();
        this.shearables.clear();
        this.dyeables.clear();
        this.colourOffsets.clear();
        this.wornOffsets.clear();
        this.checkWildCard.clear();
    }

    @Override
    public void addChild(IAnimationChanger animationRandomizer) {
        this.children.add(animationRandomizer);
    }

    private void checkWildCard(String partIdentifier) {
        if (!this.checkWildCard.contains(partIdentifier)) {
            this.checkWildCard.add(partIdentifier);
            for (String s : this.dyeables) {
                if (!s.startsWith("*") || !partIdentifier.matches(s.substring(1))) continue;
                this.dyeables.add(partIdentifier);
                if (!this.colourOffsets.containsKey(s)) break;
                this.colourOffsets.put(partIdentifier, this.colourOffsets.get(s));
                break;
            }
            for (String s : this.shearables) {
                if (!s.startsWith("*") || !partIdentifier.matches(s.substring(1))) continue;
                this.dyeables.add(partIdentifier);
                break;
            }
        }
    }

    @Override
    public boolean modifyColourForPart(String partIdentifier, Entity entity, int[] rgba) {
        this.checkWildCard(partIdentifier);
        for (IAnimationChanger child : this.children) {
            if (!child.modifyColourForPart(partIdentifier, entity, rgba)) continue;
            return true;
        }
        int rgb = this.getColourForPart(partIdentifier, entity);
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        rgba[0] = r;
        rgba[1] = g;
        rgba[2] = b;
        rgba[3] = a;
        return true;
    }

    public int getColourForPart(String partIdentifier, Entity entity) {
        this.checkWildCard(partIdentifier);
        int rgba = -1;
        IMobColourable pokemob = (IMobColourable)entity.getCapability(ThutCaps.COLOURABLE).orElse(null);
        if (pokemob == null) {
            return rgba;
        }
        rgba = -16777216;
        if (this.dyeables.contains(partIdentifier)) {
            Function<Integer, Integer> offset = this.colourOffsets.get(partIdentifier);
            int colour = pokemob.getDyeColour() & 0xF;
            if (offset != null) {
                colour = offset.apply(colour);
            }
            return rgba += DyeColor.m_41053_((int)colour).m_41071_();
        }
        int[] arr = pokemob.getRGBA();
        rgba = (arr[3] & 0xFF) << 24 | (arr[0] & 0xFF) << 16 | (arr[1] & 0xFF) << 8 | (arr[2] & 0xFF) << 0;
        return rgba;
    }

    @Override
    public IAnimationChanger.WornOffsets getOffsets(String part) {
        return this.wornOffsets.get(part);
    }

    @Override
    public void init(Collection<Animation> existingAnimations) {
        for (IAnimationChanger child : this.children) {
            child.init(existingAnimations);
        }
    }

    @Override
    public boolean hasAnimation(String phase) {
        for (IAnimationChanger child : this.children) {
            if (!child.hasAnimation(phase)) continue;
            return true;
        }
        return IAnimationChanger.super.hasAnimation(phase);
    }

    @Override
    public boolean isPartHidden(String part, Entity entity, boolean default_) {
        this.checkWildCard(part);
        for (IAnimationChanger child : this.children) {
            if (!child.isPartHidden(part, entity, default_)) continue;
            return true;
        }
        IShearable shear = ShearableCaps.get((ICapabilityProvider)entity);
        if (this.shearables.contains(part) && shear != null) {
            return shear.isSheared();
        }
        return default_;
    }

    @Override
    public boolean getAlternates(List<String> toFill, Set<String> options, Entity mob, String phase) {
        boolean ret = false;
        for (IAnimationChanger child : this.children) {
            ret = child.getAlternates(toFill, options, mob, phase) || ret;
        }
        if (ret) {
            return true;
        }
        return IAnimationChanger.super.getAlternates(toFill, options, mob, phase);
    }

    @Override
    public void parseDyeables(Set<String> set) {
        this.dyeables.addAll(set);
    }

    @Override
    public void parseShearables(Set<String> set) {
        this.shearables.addAll(set);
    }

    @Override
    public void parseWornOffsets(Map<String, IAnimationChanger.WornOffsets> map) {
        this.wornOffsets.putAll(map);
    }

    @Override
    public IAnimated.IAnimationHolder getAnimationHolder() {
        return this.currentHolder;
    }

    @Override
    public void setAnimationHolder(IAnimated.IAnimationHolder holder) {
        this.currentHolder = holder;
        for (IAnimationChanger child : this.children) {
            child.setAnimationHolder(holder);
        }
    }
}

