/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import thut.api.ThutCaps;
import thut.api.entity.IAnimated;
import thut.api.entity.animation.Animation;
import thut.api.entity.animation.Animators;
import thut.api.entity.animation.CapabilityAnimation;
import thut.core.client.render.model.IExtendedModelPart;

public class AnimationHelper {
    private static final Map<UUID, IAnimated.IAnimationHolder> holderMap = Maps.newHashMap();

    public static boolean animate(Animation animation, IAnimated.IAnimationHolder animate, IExtendedModelPart part, float partialTick, float limbSwing, int tick) {
        Animators.IAnimator animator = animation.getComponents(part.getName());
        if (animator == null) {
            return false;
        }
        return animator.animate(animation, animate, part, partialTick, limbSwing, tick);
    }

    public static boolean doAnimation(List<Animation> list, Entity entity, IExtendedModelPart part, float partialTick, float limbSwing) {
        boolean animate = false;
        IAnimated.IAnimationHolder holder = part.getAnimationHolder();
        if (holder != null) {
            if (!entity.canUpdate()) {
                partialTick = 0.0f;
                limbSwing = 0.0f;
            }
            list = Lists.newArrayList(holder.getPlaying());
            for (Animation animation : list) {
                animate = AnimationHelper.animate(animation, holder, part, partialTick, limbSwing, entity.f_19797_) || animate;
            }
        }
        return animate;
    }

    public static IAnimated.IAnimationHolder getHolder(Entity mob) {
        IAnimated.IAnimationHolder cap = (IAnimated.IAnimationHolder)mob.getCapability(ThutCaps.ANIMCAP).orElse(null);
        if (cap != null) {
            return cap;
        }
        if (holderMap.containsKey(mob.m_20148_())) {
            return holderMap.get(mob.m_20148_());
        }
        CapabilityAnimation.DefaultImpl holder = new CapabilityAnimation.DefaultImpl();
        holderMap.put(mob.m_20148_(), holder);
        return holder;
    }
}

