/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.w3c.dom.Node;
import thut.api.ModelHolder;
import thut.api.entity.IAnimated;
import thut.api.entity.animation.Animation;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.AnimationBuilder;
import thut.core.client.render.animation.AnimationChanger;
import thut.core.client.render.animation.AnimationRandomizer;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.TextureHelper;
import thut.core.common.ThutCore;
import thut.lib.ResourceHelper;

public class AnimationLoader {
    public static void addStrings(String key, Set<String> toAddTo) {
        String[] names;
        if (key == null) {
            return;
        }
        for (String s : names = key.split(":")) {
            toAddTo.add(ThutCore.trim(s));
        }
    }

    public static Vector3 getVector3(String shift, Vector3 default_) {
        if (shift == null || shift.isEmpty()) {
            return default_;
        }
        Vector3 vect = new Vector3().set(default_);
        String[] r = shift.split(",");
        if (r.length == 1) {
            vect.set(Float.parseFloat(r[0].trim()), Float.parseFloat(r[0].trim()), Float.parseFloat(r[0].trim()));
        } else if (r.length == 3) {
            vect.set(Float.parseFloat(r[0].trim()), Float.parseFloat(r[1].trim()), Float.parseFloat(r[2].trim()));
        }
        return vect;
    }

    public static IModelRenderer.Vector5 getRotation(String rotation, String time, IModelRenderer.Vector5 default_) {
        if (rotation == null || rotation.isEmpty()) {
            return default_;
        }
        time = time == null ? "0" : time;
        Vector4 ro = new Vector4();
        int t = 0;
        String[] r = rotation.split(",");
        try {
            if (rotation.contains("x:") || rotation.contains("y:") || rotation.contains("z:")) {
                float x = 0.0f;
                float y = 0.0f;
                float z = 0.0f;
                for (String s : r) {
                    if ((s = s.trim()).contains("x:")) {
                        x = Float.parseFloat(s.replace("x:", ""));
                        continue;
                    }
                    if (s.contains("y:")) {
                        y = Float.parseFloat(s.replace("y:", ""));
                        continue;
                    }
                    if (!s.contains("z:")) continue;
                    z = Float.parseFloat(s.replace("z:", ""));
                }
                Quaternion quat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
                if (z != 0.0f) {
                    quat.m_80148_(Vector3f.f_122224_.m_122240_(z));
                }
                if (x != 0.0f) {
                    quat.m_80148_(Vector3f.f_122223_.m_122240_(x));
                }
                if (y != 0.0f) {
                    quat.m_80148_(Vector3f.f_122227_.m_122240_(y));
                }
                ro.set(quat);
            } else {
                t = Integer.parseInt(time);
                ro.set(Float.parseFloat(r[0].trim()), Float.parseFloat(r[1].trim()), Float.parseFloat(r[2].trim()), Float.parseFloat(r[3].trim()));
                ro.toQuaternion();
            }
        }
        catch (Exception e) {
            ro.set(0.0f, 0.0f, 0.0f, 1.0f);
        }
        return new IModelRenderer.Vector5(ro, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(@Nonnull InputStream stream, @Nonnull ModelHolder holder, @Nonnull IModel model, @Nullable IModelRenderer<?> renderer) {
        block47: {
            try {
                AnimationXML.XMLFile file = AnimationXML.load(stream);
                int headDir = 2;
                int headDir2 = 2;
                int headAxis = 2;
                int headAxis2 = 1;
                float[] headCaps = new float[]{-100.0f, 100.0f};
                float[] headCaps1 = new float[]{-30.0f, 70.0f};
                if (file.model.customTex != null) {
                    file.model.customTex.init();
                }
                IModelRenderer.Vector5 noRotation = new IModelRenderer.Vector5();
                Vector3 offset = new Vector3();
                IModelRenderer.Vector5 rotation = noRotation;
                Vector3 scale = new Vector3(1.0, 1.0, 1.0);
                HashSet headNames = Sets.newHashSet();
                HashSet shear = Sets.newHashSet();
                HashSet dye = Sets.newHashSet();
                ArrayList tblAnims = Lists.newArrayList();
                Object2ObjectOpenHashMap mergedAnimations = new Object2ObjectOpenHashMap();
                Object2ObjectOpenHashMap wornOffsets = new Object2ObjectOpenHashMap();
                Object2ObjectOpenHashMap phaseList = new Object2ObjectOpenHashMap();
                ArrayList texPhases = Lists.newArrayList();
                AnimationXML.Metadata meta = file.model.metadata;
                if (meta != null) {
                    AnimationLoader.addStrings(meta.head, headNames);
                    AnimationLoader.addStrings(meta.shear, shear);
                    AnimationLoader.addStrings(meta.dye, dye);
                    headDir = meta.headDir;
                    headDir2 = meta.headDir2;
                    headAxis = meta.headAxis;
                    headAxis2 = meta.headAxis2;
                    AnimationLoader.setHeadCaps(meta.headCap, headCaps);
                    AnimationLoader.setHeadCaps(meta.headCap1, headCaps1);
                }
                for (AnimationXML.Phase phase : file.model.phases) {
                    Animation anim;
                    if (phase.name != null) {
                        String name = ThutCore.trim(phase.name);
                        if (name.equals("global")) {
                            offset = AnimationLoader.getVector3(phase.values.get(new QName("offset")), offset);
                            scale = AnimationLoader.getVector3(phase.values.get(new QName("scale")), scale);
                            rotation = AnimationLoader.getRotation(phase.values.get(new QName("rotation")), null, rotation);
                            continue;
                        }
                        if (name.equals("textures")) {
                            texPhases.add(phase);
                            continue;
                        }
                        if (!AnimationRegistry.animations.containsKey(name)) continue;
                        if (ThutCore.conf.debug_models) {
                            ThutCore.LOGGER.debug("Loading " + name + " for " + holder.name);
                        }
                        try {
                            Animation anim2 = AnimationRegistry.make(phase, null);
                            if (anim2 == null) continue;
                            tblAnims.add(anim2);
                        }
                        catch (Exception e) {
                            ThutCore.LOGGER.error("Error with animation for model: " + holder.name + " Anim: " + name, (Throwable)e);
                        }
                        continue;
                    }
                    if (phase.type == null) continue;
                    if (ThutCore.conf.debug_models) {
                        ThutCore.LOGGER.debug("Building Animation " + phase.type + " for " + holder.name);
                    }
                    if ((anim = AnimationBuilder.build(phase, model.getParts().keySet(), null)) == null) continue;
                    tblAnims.add(anim);
                }
                for (AnimationXML.Merge merge : file.model.merges) {
                    String[] merges = merge.merge.split("->");
                    mergedAnimations.put(ThutCore.trim(merges[0]), ThutCore.trim(merges[1]));
                }
                for (AnimationXML.Worn worn : file.model.worn) {
                    Vector3 w_offset = AnimationLoader.getVector3(worn.offset, null);
                    Vector3 w_angles = AnimationLoader.getVector3(worn.angles, null);
                    Vector3 w_scale = AnimationLoader.getVector3(worn.scale, null);
                    String w_parent = worn.parent;
                    String w_ident = worn.id;
                    wornOffsets.put(w_ident, new IAnimationChanger.WornOffsets(w_parent, w_offset, w_scale, w_angles));
                }
                for (AnimationXML.Mat mat : file.model.materials) {
                    model.updateMaterial(mat);
                }
                if (renderer != null) {
                    Iterator<IExtendedModelPart> iterator = renderer;
                    synchronized (iterator) {
                        IPartTexturer texturer = renderer.getTexturer();
                        IAnimationChanger animator = renderer.getAnimationChanger();
                        if (texturer == null) {
                            texturer = new TextureHelper();
                            renderer.setTexturer(texturer);
                        } else {
                            texturer.reset();
                        }
                        if (animator == null) {
                            animator = new AnimationChanger();
                            renderer.setAnimationChanger(animator);
                        } else {
                            animator.reset();
                        }
                        IAnimated.IAnimationHolder animHolder = renderer.getAnimationHolder();
                        if (animHolder != null) {
                            animHolder.clean();
                        }
                        if (file.model.customTex != null) {
                            texturer.init(file.model.customTex);
                            if (file.model.customTex.defaults != null) {
                                holder.texture = new ResourceLocation(holder.texture.toString().replace(holder.name, file.model.customTex.defaults));
                            }
                        } else {
                            Iterator<Object> tex = new AnimationXML.CustomTex();
                            ((AnimationXML.CustomTex)((Object)tex)).defaults = holder.texture.toString();
                            texturer.init((AnimationXML.CustomTex)((Object)tex));
                        }
                        for (AnimationXML.Phase p : texPhases) {
                            texturer.applyTexturePhase(p);
                        }
                        if (!file.model.subanim.isEmpty()) {
                            animator.addChild(new AnimationRandomizer(file.model.subanim));
                        }
                        renderer.updateModel((Map<String, List<IModelRenderer.Vector5>>)phaseList, holder);
                        renderer.setRotationOffset(offset);
                        renderer.setScale(scale);
                        renderer.setRotations(rotation);
                        model.getHeadParts().addAll(headNames);
                        for (Animation anim : tblAnims) {
                            List<Animation> anims = renderer.getAnimations().get(anim.name);
                            if (anims == null) {
                                anims = Lists.newArrayList();
                                renderer.getAnimations().put(anim.name, anims);
                            }
                            anims.add(anim);
                        }
                        for (Object from : mergedAnimations.keySet()) {
                            if (!renderer.getAnimations().containsKey(from)) continue;
                            String to = (String)mergedAnimations.get(from);
                            if (!renderer.getAnimations().containsKey(to)) continue;
                            ArrayList fromSet = Lists.newArrayList();
                            List<Animation> toSet = renderer.getAnimations().get(to);
                            for (Animation anim : renderer.getAnimations().get(from)) {
                                Animation newAnim = new Animation();
                                newAnim.identifier = anim.identifier;
                                newAnim.name = to;
                                newAnim.loops = anim.loops;
                                newAnim.priority = 20;
                                newAnim.length = -1;
                                for (String s : anim.sets.keySet()) {
                                    newAnim.sets.put(s, anim.sets.get(s));
                                }
                                fromSet.add(newAnim);
                            }
                            toSet.addAll(fromSet);
                        }
                        ArrayList allAnims = Lists.newArrayList();
                        for (List<Animation> anims : renderer.getAnimations().values()) {
                            AnimationBuilder.processAnimations(anims);
                            allAnims.addAll(anims);
                        }
                        model.preProcessAnimations(allAnims);
                        animator.parseDyeables(dye);
                        animator.parseShearables(shear);
                        animator.init(allAnims);
                        animator.parseWornOffsets((Map<String, IAnimationChanger.WornOffsets>)wornOffsets);
                        renderer.setTexturer(texturer);
                        renderer.setAnimationChanger(animator);
                        if (headDir2 == 2) {
                            headDir2 = headDir;
                        }
                        if (headDir != 2) {
                            renderer.getHeadInfo().yawDirection = headDir;
                        }
                        if (headDir2 != 2) {
                            renderer.getHeadInfo().pitchDirection = headDir2;
                        }
                        renderer.getHeadInfo().yawAxis = headAxis;
                        renderer.getHeadInfo().pitchAxis = headAxis2;
                        renderer.getHeadInfo().yawCapMin = headCaps[0];
                        renderer.getHeadInfo().yawCapMax = headCaps[1];
                        renderer.getHeadInfo().pitchCapMin = headCaps1[0];
                        renderer.getHeadInfo().pitchCapMax = headCaps1[1];
                        break block47;
                    }
                }
                if (file.model.customTex != null && file.model.customTex.defaults != null) {
                    holder.texture = holder.texture != null ? new ResourceLocation(holder.texture.toString().replace(holder.name, file.model.customTex.defaults)) : new ResourceLocation(holder.model.m_135827_(), file.model.customTex.defaults);
                }
                for (IExtendedModelPart p : model.getParts().values()) {
                    if (file.model.customTex != null) {
                        if (file.model.customTex.defaults != null) {
                            holder.texture = holder.texture != null ? new ResourceLocation(holder.texture.toString().replace(holder.name, file.model.customTex.defaults)) : new ResourceLocation(holder.model.m_135827_(), file.model.customTex.defaults);
                        }
                        ArrayList matNames = Lists.newArrayList();
                        for (AnimationXML.TexPart part : file.model.customTex.parts) {
                            ResourceLocation tex = new ResourceLocation(holder.model.m_135827_(), part.tex);
                            if (p.getName().equals(part.name)) {
                                for (Material m3 : p.getMaterials()) {
                                    m3.tex = tex;
                                    matNames.add(m3.name);
                                }
                                continue;
                            }
                            Material m = new Material(part.name);
                            m.tex = tex;
                            AnimationXML.Mat m2 = new AnimationXML.Mat();
                            m2.name = part.name;
                            p.updateMaterial(m2, m);
                            matNames.add(part.name);
                        }
                        if (file.model.customTex.defaults != null) {
                            for (Material m : p.getMaterials()) {
                                if (matNames.contains(m.name)) continue;
                                m.tex = holder.texture;
                            }
                        }
                    }
                    if (p.getParent() != null) continue;
                    p.setPreScale(scale);
                    p.setPreTranslations(offset);
                    if (noRotation == rotation) continue;
                    p.setPreRotations(rotation.rotations);
                }
            }
            catch (Exception e) {
                ThutCore.LOGGER.debug("No Animation found for " + holder.name + " " + holder.model, (Throwable)e);
            }
        }
    }

    public static boolean parse(ModelHolder holder, IModel model, IModelRenderer<?> renderer, ResourceLocation animations) {
        try {
            InputStream stream = ResourceHelper.getStream(animations, Minecraft.m_91087_().m_91098_());
            if (stream == null) {
                throw new FileNotFoundException(animations.toString());
            }
            if (ThutCore.conf.debug_models) {
                ThutCore.LOGGER.debug("Loading " + animations + " for " + holder.name);
            }
            AnimationLoader.parse(stream, holder, model, renderer);
            stream.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void parse(ModelHolder holder, IModel model, IModelRenderer<?> renderer) {
        ResourceLocation anims = holder.animation;
        if (anims == null && holder.backupAnimations.isEmpty()) {
            return;
        }
        if (!AnimationLoader.parse(holder, model, renderer, anims)) {
            for (ResourceLocation loc : holder.backupAnimations) {
                if (!AnimationLoader.parse(holder, model, renderer, loc)) continue;
                return;
            }
        } else {
            return;
        }
        ThutCore.LOGGER.error("Error in parsing animation file {} for {}, also checked {}", (Object)holder.animation, (Object)holder.name, holder.backupAnimations);
    }

    public static void setHeadCaps(String toSplit, float[] toFill) {
        String[] r = toSplit.split(",");
        toFill[0] = Float.parseFloat(r[0]);
        toFill[1] = Float.parseFloat(r[1]);
    }

    public static void setHeadCaps(Node node, float[] toFill, float[] toFill1) {
        if (node.getAttributes() == null) {
            return;
        }
        if (node.getAttributes().getNamedItem("headCap") != null) {
            AnimationLoader.setHeadCaps(node.getAttributes().getNamedItem("headCap").getNodeValue(), toFill);
        }
        if (node.getAttributes().getNamedItem("headCap1") != null) {
            AnimationLoader.setHeadCaps(node.getAttributes().getNamedItem("headCap1").getNodeValue(), toFill1);
        }
    }
}

