/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation.prefab;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import thut.api.entity.animation.Animation;
import thut.api.entity.animation.AnimationComponent;
import thut.api.entity.animation.Animators;
import thut.core.client.render.animation.AnimationXML;
import thut.core.common.ThutCore;

public class AdvancedFlapAnimation
extends Animation {
    private static final QName duration = new QName("duration");

    public AdvancedFlapAnimation() {
        this.loops = true;
        this.name = "flying";
    }

    @Override
    public Animation init(AnimationXML.Phase map, @Nullable Animation.IPartRenamer renamer) {
        int flapdur = 0;
        float walkAngle2 = 20.0f;
        flapdur = Integer.parseInt(this.get(map, duration));
        for (int i = 1; i <= 255 && !this.get(map, "leftWing" + i).isEmpty(); ++i) {
            int flapaxis = 2;
            float[] walkAngle1 = new float[]{20.0f, 20.0f};
            HashSet<String> hl = new HashSet<String>();
            HashSet<String> hr = new HashSet<String>();
            String[] lh = this.get(map, "leftWing" + i).split(":");
            String[] rh = this.get(map, "rightWing" + i).split(":");
            if (renamer != null) {
                renamer.convertToIdents(lh);
                renamer.convertToIdents(rh);
            }
            for (String s : lh) {
                if (s == null) continue;
                hl.add(ThutCore.trim(s));
            }
            for (String s : rh) {
                if (s == null) continue;
                hr.add(ThutCore.trim(s));
            }
            if (this.get(map, "angle" + i) != null) {
                String[] args = this.get(map, "angle" + i).split(",");
                walkAngle1[0] = Float.parseFloat(args[0]);
                walkAngle1[1] = Float.parseFloat(args[1]);
            }
            if (!this.get(map, "start" + i).isEmpty()) {
                walkAngle2 = Float.parseFloat(this.get(map, "start" + i));
            }
            if (!this.get(map, "axis" + i).isEmpty()) {
                flapaxis = Integer.parseInt(this.get(map, "axis" + i));
            }
            this.init(hl, hr, flapdur, walkAngle1, walkAngle2, flapaxis, i > 1);
        }
        return this;
    }

    public AdvancedFlapAnimation init(Set<String> lw, Set<String> rw, int duration, float[] angle, float start, int axis, boolean reverse) {
        ArrayList set;
        AnimationComponent component3;
        AnimationComponent component2;
        AnimationComponent component1;
        String ident;
        duration += duration % 4;
        int dir = reverse ? -1 : 1;
        for (String s : rw) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "1";
            component1.identifier = "1";
            component1.startKey = 0;
            component1.rotOffset[axis] = -start;
            component1.rotChange[axis] = angle[0];
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "2";
            component2.identifier = "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = -(angle[1] + angle[0]);
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "3";
            component3.identifier = "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = angle[1];
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, new Animators.KeyframeAnimator(set));
        }
        for (String s : lw) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "1";
            component1.identifier = "1";
            component1.startKey = 0;
            component1.rotOffset[axis] = start;
            component1.rotChange[axis] = (float)dir * -angle[0];
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "2";
            component2.identifier = "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = (float)dir * (angle[1] + angle[0]);
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "3";
            component3.identifier = "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = (float)dir * -angle[1];
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, new Animators.KeyframeAnimator(set));
        }
        return this;
    }
}

