/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation.prefab;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import thut.api.entity.animation.Animation;
import thut.api.entity.animation.AnimationComponent;
import thut.api.entity.animation.Animators;
import thut.core.client.render.animation.AnimationXML;
import thut.core.common.ThutCore;

public class BasicFlapAnimation
extends Animation {
    private static final QName leftWing = new QName("leftWing");
    private static final QName rightWing = new QName("rightWing");
    private static final QName angle = new QName("angle");
    private static final QName start = new QName("start");
    private static final QName axis = new QName("axis");
    private static final QName duration = new QName("duration");

    public BasicFlapAnimation() {
        this.loops = true;
        this.name = "flying";
    }

    @Override
    public Animation init(AnimationXML.Phase map, @Nullable Animation.IPartRenamer renamer) {
        HashSet<String> hl = new HashSet<String>();
        HashSet<String> hr = new HashSet<String>();
        int flapdur = 0;
        int flapaxis = 2;
        float walkAngle1 = 20.0f;
        float walkAngle2 = 20.0f;
        flapdur = Integer.parseInt(this.get(map, duration));
        String[] lh = this.get(map, leftWing).split(":");
        String[] rh = this.get(map, rightWing).split(":");
        if (renamer != null) {
            renamer.convertToIdents(lh);
            renamer.convertToIdents(rh);
        }
        for (String s : lh) {
            if (s == null) continue;
            hl.add(ThutCore.trim(s));
        }
        for (String s : rh) {
            if (s == null) continue;
            hr.add(ThutCore.trim(s));
        }
        String angle = this.get(map, BasicFlapAnimation.angle);
        String start = this.get(map, BasicFlapAnimation.start);
        String axis = this.get(map, BasicFlapAnimation.axis);
        if (!angle.isEmpty()) {
            walkAngle1 = Float.parseFloat(angle);
        }
        if (!start.isEmpty()) {
            walkAngle2 = Float.parseFloat(start);
        }
        if (!axis.isEmpty()) {
            flapaxis = Integer.parseInt(axis);
        }
        this.init(hl, hr, flapdur, walkAngle1, walkAngle2, flapaxis);
        return this;
    }

    public BasicFlapAnimation init(Set<String> lw, Set<String> rw, int duration, float angle, float start, int axis) {
        ArrayList set;
        AnimationComponent component3;
        AnimationComponent component2;
        AnimationComponent component1;
        String ident;
        duration += duration % 4;
        for (String s : rw) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "1";
            component1.identifier = "1";
            component1.startKey = 0;
            component1.rotOffset[axis] = -start;
            component1.rotChange[axis] = angle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "2";
            component2.identifier = "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = -2.0f * angle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "3";
            component3.identifier = "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = angle;
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, new Animators.KeyframeAnimator(set));
        }
        for (String s : lw) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "1";
            component1.identifier = "1";
            component1.startKey = 0;
            component1.rotOffset[axis] = start;
            component1.rotChange[axis] = -angle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "2";
            component2.identifier = "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = 2.0f * angle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "3";
            component3.identifier = "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = -angle;
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, new Animators.KeyframeAnimator(set));
        }
        return this;
    }
}

