/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation.prefab;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import org.nfunk.jep.JEP;
import thut.api.entity.animation.Animation;
import thut.api.entity.animation.Animators;
import thut.core.client.render.animation.AnimationXML;
import thut.core.common.ThutCore;

public class BiWalkAnimation
extends Animation {
    public BiWalkAnimation() {
        this.loops = true;
        this.name = "walking";
    }

    @Override
    public Animation init(AnimationXML.Phase map, @Nullable Animation.IPartRenamer renamer) {
        HashSet<String> hl = new HashSet<String>();
        HashSet<String> hr = new HashSet<String>();
        HashSet<String> fl = new HashSet<String>();
        HashSet<String> fr = new HashSet<String>();
        int biwalkdur = 0;
        float walkAngle1 = 20.0f;
        float walkAngle2 = 20.0f;
        String[] lh = this.get(map, "leftLeg").split(":");
        String[] rh = this.get(map, "rightLeg").split(":");
        String[] lf = this.get(map, "leftArm").split(":");
        String[] rf = this.get(map, "rightArm").split(":");
        if (renamer != null) {
            renamer.convertToIdents(lh);
            renamer.convertToIdents(rh);
            renamer.convertToIdents(lf);
            renamer.convertToIdents(rf);
        }
        for (String s : lh) {
            if (s == null) continue;
            hl.add(ThutCore.trim(s));
        }
        for (String s : rh) {
            if (s == null) continue;
            hr.add(ThutCore.trim(s));
        }
        for (String s : rf) {
            if (s == null) continue;
            fr.add(ThutCore.trim(s));
        }
        for (String s : lf) {
            if (s == null) continue;
            fl.add(ThutCore.trim(s));
        }
        biwalkdur = Integer.parseInt(this.get(map, "duration"));
        int armAxis = 0;
        int legAxis = 0;
        if (!this.get(map, "legAngle").isEmpty()) {
            walkAngle1 = Float.parseFloat(this.get(map, "legAngle"));
        }
        if (!this.get(map, "armAngle").isEmpty()) {
            walkAngle2 = Float.parseFloat(this.get(map, "armAngle"));
        }
        if (!this.get(map, "legAxis").isEmpty()) {
            legAxis = Integer.parseInt(this.get(map, "legAxis"));
        }
        if (!this.get(map, "armAxis").isEmpty()) {
            armAxis = Integer.parseInt(this.get(map, "armAxis"));
        }
        this.init(hl, hr, fl, fr, biwalkdur, walkAngle1, walkAngle2, legAxis, armAxis);
        return this;
    }

    public BiWalkAnimation init(Set<String> hl, Set<String> hr, Set<String> fl, Set<String> fr, int duration, float legAngle, float armAngle, int legAxis, int armAxis) {
        String exp;
        JEP[] rots;
        String phase1 = "x:%f*cos(0.05*l*%d)";
        String phase2 = "x:-%f*cos(0.05*l*%d)";
        String phase3 = "x:%f*sin(0.05*l*%d)";
        String phase4 = "x:-%f*sin(0.05*l*%d)";
        for (String s : hr) {
            try {
                rots = new JEP[3];
                exp = String.format(Locale.ROOT, phase1, Float.valueOf(legAngle), duration);
                Animators.FunctionAnimation.fillJEPs(rots, exp);
                this.sets.put(s, new Animators.FunctionAnimation(rots));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String s : hl) {
            try {
                rots = new JEP[3];
                exp = String.format(Locale.ROOT, phase2, Float.valueOf(legAngle), duration);
                Animators.FunctionAnimation.fillJEPs(rots, exp);
                this.sets.put(s, new Animators.FunctionAnimation(rots));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String s : fr) {
            try {
                rots = new JEP[3];
                exp = String.format(Locale.ROOT, phase3, Float.valueOf(legAngle), duration);
                Animators.FunctionAnimation.fillJEPs(rots, exp);
                this.sets.put(s, new Animators.FunctionAnimation(rots));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String s : fl) {
            try {
                rots = new JEP[3];
                exp = String.format(Locale.ROOT, phase4, Float.valueOf(legAngle), duration);
                Animators.FunctionAnimation.fillJEPs(rots, exp);
                this.sets.put(s, new Animators.FunctionAnimation(rots));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Animators.IAnimator set : this.sets.values()) {
            set.setLimbBased();
        }
        return this;
    }
}

