/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation.prefab;

import java.util.ArrayList;
import java.util.Locale;
import org.nfunk.jep.JEP;
import thut.api.entity.animation.Animation;
import thut.api.entity.animation.Animators;
import thut.core.client.render.animation.AnimationXML;
import thut.core.common.ThutCore;

public class SnakeMovement
extends Animation {
    public SnakeMovement() {
        this.loops = true;
        this.name = "walking";
    }

    public SnakeMovement init(ArrayList<String> parts, int duration, float maxAngle, int axis) {
        int num = parts.size();
        int mod = num > 6 ? 3 : 2;
        double dphi = (double)mod * Math.PI / (double)num;
        String phase = "0.5*%f*sin(t*0.001*%d + %f)";
        for (int i = 0; i < parts.size(); ++i) {
            String s = parts.get(i);
            JEP[] rots = new JEP[3];
            rots[axis] = new JEP();
            rots[axis].addStandardFunctions();
            rots[axis].addStandardConstants();
            rots[axis].addVariable("t", 0.0);
            try {
                String exp = String.format(Locale.ROOT, phase, Float.valueOf(maxAngle), duration, dphi * (double)i);
                rots[axis].parseExpression(exp);
                this.sets.put(s, new Animators.FunctionAnimation(rots));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public Animation init(AnimationXML.Phase map, Animation.IPartRenamer renamer) {
        ArrayList<String> parts = new ArrayList<String>();
        int duration = 40;
        int axis = 1;
        float maxAngle = 10.0f;
        String[] partsArr = this.get(map, "parts").split(":");
        if (renamer != null) {
            renamer.convertToIdents(partsArr);
        }
        for (String s : partsArr) {
            if (s == null) continue;
            parts.add(ThutCore.trim(s));
        }
        if (!this.get(map, "angle").isEmpty()) {
            maxAngle = Float.parseFloat(this.get(map, "angle"));
        }
        if (!this.get(map, "axis").isEmpty()) {
            axis = Integer.parseInt(this.get(map, "axis"));
        }
        if (!this.get(map, "length").isEmpty()) {
            duration = Integer.parseInt(this.get(map, "length"));
        }
        if (!this.get(map, "duration").isEmpty()) {
            duration = Integer.parseInt(this.get(map, "duration"));
        }
        this.init(parts, duration, maxAngle, axis);
        return this;
    }
}

