/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.bbmodel;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import thut.api.entity.animation.Animation;
import thut.api.util.JsonUtil;
import thut.core.client.render.bbmodel.BBModelPart;
import thut.core.client.render.bbmodel.BBModelTemplate;
import thut.core.client.render.model.BaseModel;
import thut.core.common.ThutCore;
import thut.lib.ResourceHelper;

public class BBModel
extends BaseModel {
    public BBModel() {
    }

    public BBModel(ResourceLocation l) {
        super(l);
    }

    @Override
    protected void loadModel(ResourceLocation model) {
        block3: {
            try {
                this.last_loaded = model;
                BufferedReader reader = ResourceHelper.getReader(model, Minecraft.m_91087_().m_91098_());
                if (reader == null) {
                    this.valid = false;
                    return;
                }
                BBModelTemplate t = (BBModelTemplate)JsonUtil.gson.fromJson((Reader)reader, BBModelTemplate.class);
                reader.close();
                t.init();
                this.makeObjects(t);
            }
            catch (Exception e) {
                this.valid = false;
                if (e instanceof FileNotFoundException) break block3;
                ThutCore.LOGGER.error("error loading " + model, (Throwable)e);
            }
        }
    }

    private void makeObjects(BBModelTemplate t) {
        ArrayList parts = Lists.newArrayList();
        if (t.outliner.isEmpty()) {
            BBModelTemplate.JsonGroup main = new BBModelTemplate.JsonGroup();
            main.name = "root";
            main.origin = new float[]{0.0f, 0.0f, 0.0f};
            main.children.addAll(t.elements);
        }
        for (int i = 0; i < t.outliner.size(); ++i) {
            BBModelTemplate.JsonGroup b = t.outliner.get(i);
            float[] parentOffsets = new float[]{0.0f, 0.0f, 0.0f};
            BBModelPart.makeParts(t, b, parts, new ArrayList<BBModelPart>(), new HashSet<String>(), parentOffsets);
        }
        for (BBModelPart p : parts) {
            this.parts.put(p.getName(), p);
        }
    }

    @Override
    public void preProcessAnimations(Collection<Animation> collection) {
    }
}

