/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.bbmodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import thut.api.maths.Vector4;
import thut.core.client.render.bbmodel.BBModelTemplate;
import thut.core.client.render.json.JsonMesh;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.model.parts.Mesh;
import thut.core.client.render.model.parts.Part;
import thut.core.client.render.texturing.TextureCoordinate;
import thut.core.common.ThutCore;

public class BBModelPart
extends Part {
    public int index = 0;

    private static String nextName(Set<String> names, BBModelTemplate.IBBPart part) {
        Object nextName = part.getName();
        int i = 1;
        while (names.contains(nextName)) {
            nextName = part.getName() + "_" + i;
            ++i;
        }
        return nextName;
    }

    public static void makeParts(BBModelTemplate t, BBModelTemplate.JsonGroup group, List<BBModelPart> parts, List<BBModelPart> children, Set<String> names, float[] parentOffsets) {
        ArrayList<BBModelPart> ours = new ArrayList<BBModelPart>();
        ArrayList<Mesh> allShapes = new ArrayList<Mesh>();
        for (Object o : group.children) {
            if (!(o instanceof BBModelTemplate.Element)) continue;
            BBModelTemplate.Element b = (BBModelTemplate.Element)o;
            List<Mesh> shapes = BBModelPart.makeShapes(t, b, group.origin);
            allShapes.addAll(shapes);
        }
        BBModelPart root = BBModelPart.make(allShapes, BBModelPart.nextName(names, group), group, -1, parentOffsets);
        ours.add(root);
        parts.add(root);
        children.clear();
        for (int i = 0; i < 3; ++i) {
            parentOffsets[i] = -group.origin[i];
        }
        for (Object o : group.children) {
            if (!(o instanceof BBModelTemplate.JsonGroup)) continue;
            BBModelTemplate.JsonGroup g = (BBModelTemplate.JsonGroup)o;
            BBModelPart.makeParts(t, g, parts, children, names, (float[])parentOffsets.clone());
            children.forEach(root::addChild);
        }
        children.clear();
        children.addAll(ours);
    }

    private static BBModelPart make(List<Mesh> shapes, String name, BBModelTemplate.IBBPart b, int index, float[] parentOffsets) {
        BBModelPart part = new BBModelPart(name);
        part.index = index;
        shapes.forEach(part::addShape);
        float[] offsets = (float[])b.getOrigin().clone();
        for (int i = 0; i < 3; ++i) {
            int n = i;
            offsets[n] = offsets[n] + parentOffsets[i];
        }
        if (b.getRotation() != null) {
            float x = b.getRotation()[0];
            float y = b.getRotation()[2];
            float z = -b.getRotation()[1];
            Quaternion quat = new Quaternion(x, y, z, true);
            Vector4 rotations = new Vector4(quat);
            part.rotations.set(rotations.x, rotations.y, rotations.z, rotations.w);
        }
        offsets[0] = offsets[0] / 16.0f;
        offsets[1] = offsets[1] / 16.0f;
        offsets[2] = offsets[2] / 16.0f;
        float[] use = (float[])offsets.clone();
        use[0] = -offsets[0];
        use[1] = -offsets[2];
        use[2] = offsets[1];
        part.offset.set((Object)use);
        return part;
    }

    private static List<Mesh> makeShapes(BBModelTemplate t, BBModelTemplate.Element b, float[] origin) {
        ArrayList<Mesh> shapes = new ArrayList<Mesh>();
        HashMap materials = Maps.newHashMap();
        BBModelTemplate.BBModelBox box = new BBModelTemplate.BBModelBox(t, b);
        boolean bedrock = t.meta.model_format.equals("bedrock");
        for (BBModelTemplate.BBModelFace face : box.faces) {
            if (face == null) continue;
            List<Integer> order = Lists.newArrayList();
            List<Vertex> verts = Lists.newArrayList();
            List<TextureCoordinate> tex = Lists.newArrayList();
            String material = t.textures.get((int)face.texture).name;
            if (materials.containsKey(material)) {
                List lists2 = (List)materials.get(material);
                order = (List)lists2.get(0);
                verts = (List)lists2.get(1);
                tex = (List)lists2.get(2);
            }
            for (int i = 0; i < 4; ++i) {
                int index = i;
                if (bedrock) {
                    index = 3 - i;
                }
                Integer o = order.size();
                Vertex v = face.points[index];
                TextureCoordinate tx = face.tex[index];
                order.add(o);
                verts.add(v);
                tex.add(tx);
            }
            materials.put(material, Lists.newArrayList((Object[])new List[]{order, verts, tex}));
        }
        materials.forEach((key, lists) -> {
            List order = (List)lists.get(0);
            List verts = (List)lists.get(1);
            List tex = (List)lists.get(2);
            JsonMesh m = new JsonMesh(order.toArray(new Integer[0]), verts.toArray(new Vertex[0]), tex.toArray(new TextureCoordinate[0]));
            m.name = ThutCore.trim(key);
            Material mat = new Material(m.name);
            m.setMaterial(mat);
            shapes.add(m);
        });
        return shapes;
    }

    public BBModelPart(String name) {
        super(name);
    }

    @Override
    public String getType() {
        return "json";
    }
}

