/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.bbmodel;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import thut.api.maths.vecmath.Vec3f;
import thut.api.util.JsonUtil;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.texturing.TextureCoordinate;

public class BBModelTemplate {
    public String name = "";
    public Meta meta;
    public List<Element> elements = new ArrayList<Element>();
    public List<JsonGroup> outliner = new ArrayList<JsonGroup>();
    public List<Texture> textures = new ArrayList<Texture>();
    public Resolution resolution = new Resolution();
    public Map<String, Object> _by_uuid = new HashMap<String, Object>();

    public void init() {
        this.elements.forEach(e -> this._by_uuid.put(e.uuid, e));
        this.textures.forEach(e -> this._by_uuid.put(e.uuid, e));
        this.outliner.forEach(e -> e.init(this));
    }

    public String toString() {
        return this.name + " parts:" + this.elements + " groups:" + this.outliner;
    }

    public static class Resolution {
        float width = 16.0f;
        float height = 16.0f;
    }

    public static class JsonGroup
    implements IBBPart {
        public String name;
        public float[] origin;
        public float[] rotation;
        public int color;
        public String uuid;
        public List<Object> children = new ArrayList<Object>();
        public JsonGroup _parent = null;
        public boolean _empty = true;

        public String toString() {
            return this.name + " " + Arrays.toString(this.origin) + " " + this.color + " " + this.children;
        }

        public void init(BBModelTemplate template) {
            ArrayList<Object> newChildren = new ArrayList<Object>();
            for (Object o : this.children) {
                if (o instanceof String) {
                    Element b = (Element)template._by_uuid.get(o);
                    if (b.name.equals("cube")) {
                        b.name = this.name;
                    }
                    for (int i = 0; i < 3; ++i) {
                        int n = i;
                        b.origin[n] = b.origin[n] - this.origin[i];
                        int n2 = i;
                        b.from[n2] = b.from[n2] - this.origin[i];
                        int n3 = i;
                        b.to[n3] = b.to[n3] - this.origin[i];
                    }
                    newChildren.add(b);
                    this._empty = false;
                    continue;
                }
                String json = JsonUtil.gson.toJson(o);
                JsonGroup g = (JsonGroup)JsonUtil.gson.fromJson(json, JsonGroup.class);
                g._parent = this;
                g.init(template);
                newChildren.add(g);
            }
            this.children = newChildren;
        }

        @Override
        public float[] getOrigin() {
            return this.origin;
        }

        @Override
        public float[] getRotation() {
            return this.rotation;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class Texture {
        String name;
        String id;
        String render_mode;
        String uuid;
    }

    public static class Element
    implements IBBPart {
        public String name;
        public String type;
        public String uuid;
        public float[] from;
        public float[] to;
        public float[] origin;
        public float[] rotation;
        public int color;
        public float inflate = 0.0f;
        public JsonFaces faces;

        public String toString() {
            return this.name + " " + Arrays.toString(this.from) + " " + Arrays.toString(this.to) + " " + this.color + " " + this.faces;
        }

        @Override
        public float[] getOrigin() {
            return this.origin;
        }

        @Override
        public float[] getRotation() {
            return this.rotation;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class BBAnimation {
        public String uuid;
        public String name;
        public String loop;
        public boolean override;
        public double length;
        public int snapping;
        public Map<String, BBAnimator> animators = new HashMap<String, BBAnimator>();

        public static class BBDataPoint {
            Object x;
            Object y;
            Object z;
        }

        public static class BBKeyFrame {
            public String channel;
            public String uuid;
            public String interpolation;
            public double time;
            public List<BBDataPoint> data_points = new ArrayList<BBDataPoint>();
        }

        public static class BBAnimator {
            public String name;
            public String type;
            public List<BBKeyFrame> keyframes = new ArrayList<BBKeyFrame>();
        }
    }

    public static class JsonFace {
        public float[] uv;
        public int texture;
        public int rotation = 0;
    }

    public static class JsonFaces {
        public JsonFace north;
        public JsonFace east;
        public JsonFace south;
        public JsonFace west;
        public JsonFace up;
        public JsonFace down;
    }

    public static class BBModelBox {
        BBModelFace[] faces = new BBModelFace[6];

        public BBModelBox(BBModelTemplate template, Element b) {
            float[] from = new float[]{0.0f, 0.0f, 0.0f};
            float[] to = new float[]{0.0f, 0.0f, 0.0f};
            float[] origin_offset = new float[]{0.0f, 0.0f, 0.0f};
            float[] mid_offset = new float[]{0.0f, 0.0f, 0.0f};
            float f = 1.0f + b.inflate;
            for (int i = 0; i < 3; ++i) {
                float size = (b.to[i] - b.from[i]) * f;
                float mid = -(b.to[i] + b.from[i]) * f / 2.0f;
                origin_offset[i] = -b.origin[i] + b.from[i];
                to[i] = size;
                mid_offset[i] = -mid - size / 2.0f;
            }
            if (b.faces.down != null) {
                BBModelFace face = new BBModelFace();
                face.points[0] = new Vertex(from[0], from[1], to[2]);
                face.points[1] = new Vertex(from[0], from[1], from[2]);
                face.points[2] = new Vertex(to[0], from[1], from[2]);
                face.points[3] = new Vertex(to[0], from[1], to[2]);
                face.rotation = b.faces.down.rotation;
                face.texture = b.faces.down.texture;
                face.uvs = b.faces.down.uv;
                if (face.isValid()) {
                    this.faces[Direction.DOWN.ordinal()] = face;
                }
            }
            if (b.faces.up != null) {
                BBModelFace face = new BBModelFace();
                face.points[0] = new Vertex(from[0], to[1], from[2]);
                face.points[1] = new Vertex(from[0], to[1], to[2]);
                face.points[2] = new Vertex(to[0], to[1], to[2]);
                face.points[3] = new Vertex(to[0], to[1], from[2]);
                face.rotation = b.faces.up.rotation;
                face.texture = b.faces.up.texture;
                face.uvs = b.faces.up.uv;
                if (face.isValid()) {
                    this.faces[Direction.UP.ordinal()] = face;
                }
            }
            if (b.faces.west != null) {
                BBModelFace face = new BBModelFace();
                face.points[0] = new Vertex(from[0], to[1], from[2]);
                face.points[1] = new Vertex(from[0], from[1], from[2]);
                face.points[2] = new Vertex(from[0], from[1], to[2]);
                face.points[3] = new Vertex(from[0], to[1], to[2]);
                face.rotation = b.faces.west.rotation;
                face.texture = b.faces.west.texture;
                face.uvs = b.faces.west.uv;
                if (face.isValid()) {
                    this.faces[Direction.WEST.ordinal()] = face;
                }
            }
            if (b.faces.east != null) {
                BBModelFace face = new BBModelFace();
                face.points[0] = new Vertex(to[0], to[1], to[2]);
                face.points[1] = new Vertex(to[0], from[1], to[2]);
                face.points[2] = new Vertex(to[0], from[1], from[2]);
                face.points[3] = new Vertex(to[0], to[1], from[2]);
                face.rotation = b.faces.east.rotation;
                face.texture = b.faces.east.texture;
                face.uvs = b.faces.east.uv;
                if (face.isValid()) {
                    this.faces[Direction.EAST.ordinal()] = face;
                }
            }
            if (b.faces.north != null) {
                BBModelFace face = new BBModelFace();
                face.points[0] = new Vertex(to[0], to[1], from[2]);
                face.points[1] = new Vertex(to[0], from[1], from[2]);
                face.points[2] = new Vertex(from[0], from[1], from[2]);
                face.points[3] = new Vertex(from[0], to[1], from[2]);
                face.rotation = b.faces.north.rotation;
                face.texture = b.faces.north.texture;
                face.uvs = b.faces.north.uv;
                if (face.isValid()) {
                    this.faces[Direction.NORTH.ordinal()] = face;
                }
            }
            if (b.faces.south != null) {
                BBModelFace face = new BBModelFace();
                face.points[0] = new Vertex(from[0], to[1], to[2]);
                face.points[1] = new Vertex(from[0], from[1], to[2]);
                face.points[2] = new Vertex(to[0], from[1], to[2]);
                face.points[3] = new Vertex(to[0], to[1], to[2]);
                face.rotation = b.faces.south.rotation;
                face.texture = b.faces.south.texture;
                face.uvs = b.faces.south.uv;
                if (face.isValid()) {
                    this.faces[Direction.SOUTH.ordinal()] = face;
                }
            }
            float us = template.resolution.width;
            float vs = template.resolution.height;
            Quaternion quat = new Quaternion(0.0f, 0.0f, 0.0f, true);
            if (b.getRotation() != null) {
                float x = b.getRotation()[0];
                float y = b.getRotation()[1];
                float z = -b.getRotation()[2];
                quat = new Quaternion(x, y, z, true);
            }
            Vector3f origin = new Vector3f(origin_offset);
            Vector3f shift = new Vector3f(mid_offset);
            boolean bedrock = template.meta.model_format.equals("bedrock");
            int[][] tex_order = new int[][]{{0, 1}, {0, 3}, {2, 3}, {2, 1}};
            for (BBModelFace face : this.faces) {
                if (face == null) continue;
                for (int j = 0; j < 4; ++j) {
                    int index = j;
                    Vertex v = face.points[index];
                    Vector3f vec = new Vector3f(v.x, v.y, v.z);
                    vec.m_122253_(origin);
                    vec.m_122251_(quat);
                    vec.m_122267_(origin);
                    vec.m_122253_(shift);
                    if (bedrock) {
                        v.set(-vec.m_122239_() / 16.0f, -vec.m_122269_() / 16.0f, vec.m_122260_() / 16.0f);
                    } else {
                        v.set(vec.m_122239_() / 16.0f, -vec.m_122269_() / 16.0f, vec.m_122260_() / 16.0f);
                    }
                    int i = (index + face.rotation / 90) % 4;
                    int u0 = tex_order[i][0];
                    int v0 = tex_order[i][1];
                    face.tex[index] = new TextureCoordinate(face.uvs[u0] / us, face.uvs[v0] / vs);
                }
            }
        }
    }

    public static class BBModelFace {
        public Vertex[] points = new Vertex[4];
        public TextureCoordinate[] tex = new TextureCoordinate[4];
        public int texture;
        public int rotation = 0;
        public float[] uvs;

        public boolean isValid() {
            Vec3f v1 = new Vec3f(this.points[0]);
            Vec3f v2 = new Vec3f(this.points[1]);
            Vec3f v3 = new Vec3f(this.points[2]);
            v2.sub(v1);
            v3.sub(v1);
            return v2.dot(v3) != 0.0f;
        }
    }

    public static class Meta {
        boolean box_uv;
        String model_format;
    }

    public static interface IBBPart {
        public float[] getOrigin();

        public float[] getRotation();

        public String getName();
    }
}

