/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.json;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import thut.api.entity.animation.Animation;
import thut.api.util.JsonUtil;
import thut.core.client.render.json.JsonPart;
import thut.core.client.render.json.JsonTemplate;
import thut.core.client.render.model.BaseModel;
import thut.core.common.ThutCore;
import thut.lib.ResourceHelper;

public class JsonModel
extends BaseModel {
    public JsonModel() {
    }

    public JsonModel(ResourceLocation l) {
        super(l);
    }

    @Override
    protected void loadModel(ResourceLocation model) {
        block3: {
            try {
                this.last_loaded = model;
                BufferedReader reader = ResourceHelper.getReader(model, Minecraft.m_91087_().m_91098_());
                if (reader == null) {
                    this.valid = false;
                    return;
                }
                JsonTemplate t = (JsonTemplate)JsonUtil.gson.fromJson((Reader)reader, JsonTemplate.class);
                reader.close();
                t.init();
                this.makeObjects(t);
            }
            catch (Exception e) {
                this.valid = false;
                if (e instanceof FileNotFoundException) break block3;
                ThutCore.LOGGER.error("error loading " + model, (Throwable)e);
            }
        }
    }

    private void makeObjects(JsonTemplate t) {
        ArrayList parts = Lists.newArrayList();
        HashMap byIndex = Maps.newHashMap();
        for (int i = 0; i < t.elements.size(); ++i) {
            JsonTemplate.JsonBlock b = t.elements.get(i);
            parts.addAll(JsonPart.makeParts(t, b, i));
        }
        for (JsonPart p : parts) {
            this.parts.put(p.getName(), p);
            List<JsonPart> bit = Lists.newArrayList();
            if (byIndex.containsKey(p.index)) {
                bit = (List)byIndex.get(p.index);
            } else {
                byIndex.put(p.index, bit);
            }
            bit.add(p);
        }
    }

    @Override
    public void preProcessAnimations(Collection<Animation> collection) {
    }
}

