/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.json;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import thut.api.maths.Vector4;
import thut.core.client.render.json.JsonMesh;
import thut.core.client.render.json.JsonTemplate;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.model.parts.Mesh;
import thut.core.client.render.model.parts.Part;
import thut.core.client.render.texturing.TextureCoordinate;
import thut.core.common.ThutCore;

public class JsonPart
extends Part {
    public int index = 0;

    public static List<JsonPart> makeParts(JsonTemplate t, JsonTemplate.JsonBlock b, int index) {
        ArrayList<JsonPart> parts = new ArrayList<JsonPart>();
        float[] offsets = b.rotation == null ? new float[]{0.0f, 0.0f, 0.0f} : (float[])b.rotation.origin.clone();
        List<Mesh> shapes = JsonPart.makeShapes(t, b, offsets);
        JsonPart root = JsonPart.make(shapes.get(0), b.name + "_" + index, b, index);
        parts.add(root);
        if (shapes.size() > 1) {
            int i = 0;
            for (Mesh s : shapes) {
                JsonPart part = JsonPart.make(s, b.name + "_" + index + "_" + i++, b, index);
                parts.add(part);
            }
        }
        return parts;
    }

    private static JsonPart make(Mesh mesh, String name, JsonTemplate.JsonBlock b, int index) {
        JsonPart part = new JsonPart(name);
        part.index = index;
        part.addShape(mesh);
        float[] offsets = (float[])b.from.clone();
        if (b.rotation != null) {
            offsets[0] = offsets[0] - b.rotation.origin[0];
            offsets[1] = offsets[1] - b.rotation.origin[1];
            offsets[2] = offsets[2] - b.rotation.origin[2];
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            if (b.rotation.axis.equals("x")) {
                x = b.rotation.angle;
            }
            if (b.rotation.axis.equals("y")) {
                y = b.rotation.angle;
            }
            if (b.rotation.axis.equals("z")) {
                z = b.rotation.angle;
            }
            Quaternion quat = new Quaternion(x, y, z, true);
            Vector4 rotations = new Vector4(quat);
            part.rotations.set(rotations.x, rotations.y, rotations.z, rotations.w);
        }
        offsets[0] = offsets[0] / 16.0f;
        offsets[1] = offsets[1] / 16.0f;
        offsets[2] = offsets[2] / 16.0f;
        part.offset.set((Object)offsets);
        return part;
    }

    private static void addFace(Map<String, List<List<Object>>> materials, JsonTemplate template, JsonTemplate.JsonBlock b, JsonTemplate.JsonFace face, Direction dir, float[] offsets) {
        if (face == null || b == null) {
            return;
        }
        List<Object> order = Lists.newArrayList();
        List<Object> verts = Lists.newArrayList();
        List<Object> tex = Lists.newArrayList();
        String material = face.texture;
        if (materials.containsKey(material)) {
            List<List<Object>> lists = materials.get(material);
            order = lists.get(0);
            verts = lists.get(1);
            tex = lists.get(2);
        } else {
            materials.put(material, Lists.newArrayList((Object[])new List[]{order, verts, tex}));
        }
        float[] from = (float[])b.from.clone();
        float[] to = (float[])b.to.clone();
        from[0] = from[0] - b.from[0];
        from[1] = from[1] - b.from[1];
        from[2] = from[2] - b.from[2];
        to[0] = to[0] - b.from[0];
        to[1] = to[1] - b.from[1];
        to[2] = to[2] - b.from[2];
        if (b.rotation != null) {
            from[0] = from[0] + b.rotation.origin[0];
            from[1] = from[1] + b.rotation.origin[1];
            from[2] = from[2] + b.rotation.origin[2];
            to[0] = to[0] + b.rotation.origin[0];
            to[1] = to[1] + b.rotation.origin[1];
            to[2] = to[2] + b.rotation.origin[2];
        }
        float[][] coords = new float[4][3];
        switch (dir) {
            case DOWN: {
                coords[0][0] = to[0];
                coords[0][2] = from[2];
                coords[1][0] = to[0];
                coords[1][2] = to[2];
                coords[2][0] = from[0];
                coords[2][2] = to[2];
                coords[3][0] = from[0];
                coords[3][2] = from[2];
                coords[0][1] = from[1];
                coords[1][1] = from[1];
                coords[2][1] = from[1];
                coords[3][1] = from[1];
                break;
            }
            case UP: {
                coords[3][0] = to[0];
                coords[3][2] = from[2];
                coords[2][0] = to[0];
                coords[2][2] = to[2];
                coords[1][0] = from[0];
                coords[1][2] = to[2];
                coords[0][0] = from[0];
                coords[0][2] = from[2];
                coords[0][1] = to[1];
                coords[1][1] = to[1];
                coords[2][1] = to[1];
                coords[3][1] = to[1];
                break;
            }
            case EAST: {
                coords[0][1] = to[1];
                coords[0][2] = to[2];
                coords[1][1] = from[1];
                coords[1][2] = to[2];
                coords[2][1] = from[1];
                coords[2][2] = from[2];
                coords[3][1] = to[1];
                coords[3][2] = from[2];
                coords[0][0] = to[0];
                coords[1][0] = to[0];
                coords[2][0] = to[0];
                coords[3][0] = to[0];
                break;
            }
            case WEST: {
                coords[0][1] = to[1];
                coords[0][2] = from[2];
                coords[1][1] = from[1];
                coords[1][2] = from[2];
                coords[2][1] = from[1];
                coords[2][2] = to[2];
                coords[3][1] = to[1];
                coords[3][2] = to[2];
                coords[0][0] = from[0];
                coords[1][0] = from[0];
                coords[2][0] = from[0];
                coords[3][0] = from[0];
                break;
            }
            case NORTH: {
                coords[0][1] = to[1];
                coords[0][0] = to[0];
                coords[1][1] = from[1];
                coords[1][0] = to[0];
                coords[2][1] = from[1];
                coords[2][0] = from[0];
                coords[3][1] = to[1];
                coords[3][0] = from[0];
                coords[0][2] = from[2];
                coords[1][2] = from[2];
                coords[2][2] = from[2];
                coords[3][2] = from[2];
                break;
            }
            case SOUTH: {
                coords[0][1] = to[1];
                coords[0][0] = from[0];
                coords[1][1] = from[1];
                coords[1][0] = from[0];
                coords[2][1] = from[1];
                coords[2][0] = to[0];
                coords[3][1] = to[1];
                coords[3][0] = to[0];
                coords[0][2] = to[2];
                coords[1][2] = to[2];
                coords[2][2] = to[2];
                coords[3][2] = to[2];
                break;
            }
        }
        int[][] tex_order = new int[][]{{0, 1}, {0, 3}, {2, 3}, {2, 1}};
        float us = 16.0f;
        float vs = 16.0f;
        for (int i = 0; i < 4; ++i) {
            float[] c = coords[i];
            Vertex v = new Vertex(c[0] / 16.0f, c[1] / 16.0f, c[2] / 16.0f);
            Integer o = order.size();
            int u0 = tex_order[i][0];
            int v0 = tex_order[i][1];
            TextureCoordinate t = new TextureCoordinate(face.uv[u0] / us, face.uv[v0] / vs);
            order.add(o);
            verts.add(v);
            tex.add(t);
        }
    }

    private static List<Mesh> makeShapes(JsonTemplate t, JsonTemplate.JsonBlock b, float[] offsets) {
        ArrayList<Mesh> shapes = new ArrayList<Mesh>();
        HashMap materials = Maps.newHashMap();
        JsonPart.addFace(materials, t, b, b.faces.north, Direction.NORTH, offsets);
        JsonPart.addFace(materials, t, b, b.faces.east, Direction.EAST, offsets);
        JsonPart.addFace(materials, t, b, b.faces.south, Direction.SOUTH, offsets);
        JsonPart.addFace(materials, t, b, b.faces.west, Direction.WEST, offsets);
        JsonPart.addFace(materials, t, b, b.faces.up, Direction.UP, offsets);
        JsonPart.addFace(materials, t, b, b.faces.down, Direction.DOWN, offsets);
        materials.forEach((key, lists) -> {
            List order = (List)lists.get(0);
            List verts = (List)lists.get(1);
            List tex = (List)lists.get(2);
            JsonMesh m = new JsonMesh(order.toArray(new Integer[0]), verts.toArray(new Vertex[0]), tex.toArray(new TextureCoordinate[0]));
            m.name = key;
            Material mat = new Material((String)key);
            m.setMaterial(mat);
            if (t.textures != null && key.contains("#") && t.textures.has(key = key.replace("#", ""))) {
                try {
                    String texture = t.textures.get(key).getAsString();
                    mat.tex = new ResourceLocation(texture);
                    if (!mat.tex.toString().contains("textures/")) {
                        mat.tex = new ResourceLocation(mat.tex.m_135827_(), "textures/" + mat.tex.m_135815_());
                    }
                    if (!mat.tex.toString().contains(".png")) {
                        mat.tex = new ResourceLocation(mat.tex.m_135827_(), mat.tex.m_135815_() + ".png");
                    }
                }
                catch (Exception e) {
                    ThutCore.LOGGER.error("Error loading Json Model Texture!", (Throwable)e);
                    ThutCore.LOGGER.error((Object)t.textures);
                    ThutCore.LOGGER.error(key);
                }
            }
            shapes.add(m);
        });
        return shapes;
    }

    public JsonPart(String name) {
        super(name);
    }

    @Override
    public String getType() {
        return "json";
    }
}

