/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.json;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import thut.api.util.JsonUtil;

public class JsonTemplate {
    public String credit = "";
    public JsonObject textures = null;
    public int[] texture_size = new int[]{16, 16};
    public List<JsonBlock> elements = new ArrayList<JsonBlock>();
    public List<JsonGroup> groups = new ArrayList<JsonGroup>();

    public void init() {
        for (JsonGroup g : this.groups) {
            g.init();
        }
    }

    public String toString() {
        return this.credit + " parts:" + this.elements + " groups:" + this.groups;
    }

    public static class JsonGroup {
        public String name;
        public float[] origin;
        public int color;
        public List<Object> children = new ArrayList<Object>();

        public String toString() {
            return this.name + " " + Arrays.toString(this.origin) + " " + this.color + " " + this.children;
        }

        public void init() {
            ArrayList<Object> newChildren = new ArrayList<Object>();
            for (Object o : this.children) {
                if (o instanceof Double) {
                    newChildren.add((int)((Double)o).doubleValue());
                    continue;
                }
                JsonGroup g = (JsonGroup)JsonUtil.gson.fromJson(o.toString(), JsonGroup.class);
                g.init();
                newChildren.add(g);
            }
            this.children = newChildren;
        }
    }

    public static class JsonFace {
        public float[] uv;
        public String texture;
    }

    public static class JsonFaces {
        public JsonFace north;
        public JsonFace east;
        public JsonFace south;
        public JsonFace west;
        public JsonFace up;
        public JsonFace down;
    }

    public static class JsonRotation {
        public float angle;
        public String axis;
        public float[] origin;
    }

    public static class JsonBlock {
        public String name;
        public float[] from;
        public float[] to;
        public int color;
        public JsonFaces faces;
        public JsonRotation rotation;

        public String toString() {
            return this.name + " " + Arrays.toString(this.from) + " " + Arrays.toString(this.to) + " " + this.color + " " + this.faces;
        }
    }
}

