/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.mca;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import thut.core.client.render.mca.McaXML;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.x3d.X3dMesh;
import thut.core.client.render.x3d.X3dModel;
import thut.core.client.render.x3d.X3dPart;
import thut.core.common.ThutCore;
import thut.lib.ResourceHelper;

public class McaModel
extends X3dModel {
    public McaModel(ResourceLocation l) {
        this.loadModel(l);
    }

    private void addChildren(Set<McaXML.Children> set, McaXML.Children node) {
        if (node.geometry != null) {
            set.add(node);
        }
        Iterator<McaXML.SceneNode> iterator = node.scenes.iterator();
        while (iterator.hasNext()) {
            McaXML.SceneNode child;
            child.children.parent = child = iterator.next();
            this.addChildren(set, child.children);
        }
    }

    private Set<String> getChildren(McaXML.Children parent) {
        HashSet ret = Sets.newHashSet();
        for (McaXML.SceneNode child : parent.scenes) {
            if (child.children.geometry == null) continue;
            ret.add(child.name);
        }
        return ret;
    }

    @Override
    public void loadModel(ResourceLocation model) {
        block3: {
            this.valid = true;
            try {
                InputStream stream = ResourceHelper.getStream(model, Minecraft.m_91087_().m_91098_());
                this.last_loaded = model;
                if (stream == null) {
                    this.valid = false;
                    return;
                }
                McaXML xml = new McaXML(stream);
                stream.close();
                this.makeObjects(xml);
            }
            catch (Exception e) {
                this.valid = false;
                if (e instanceof FileNotFoundException) break block3;
                ThutCore.LOGGER.error("error loading " + model, (Throwable)e);
            }
        }
    }

    void makeObjects(McaXML xml) throws Exception {
        HashSet scenes = Sets.newHashSet();
        this.addChildren(scenes, xml.model.node.children);
        HashMap childMap = Maps.newHashMap();
        for (McaXML.Children children : scenes) {
            Set<String> children2;
            McaXML.GeometryNode geom = children.geometry;
            McaXML.Translation trans = children.parent.transform.translation;
            McaXML.Rot rot = children.parent.transform.rotation;
            McaXML.Buffers buffers = geom.mesh.buffers;
            String name = children.parent.name;
            X3dPart o = new X3dPart(name);
            ArrayList shapes = Lists.newArrayList();
            X3dMesh shape = new X3dMesh(buffers.getOrder(), buffers.getVerts(), buffers.getNormals(), buffers.getTex());
            shapes.add(shape);
            o.setShapes(shapes);
            if (trans != null) {
                o.offset.set(trans.x / 16.0f, trans.y / 16.0f, trans.z / 16.0f);
            }
            if (rot != null) {
                o.rotations.set(rot.x, rot.y, rot.z, rot.w);
            }
            if (!(children2 = this.getChildren(children)).isEmpty()) {
                childMap.put(name, children2);
            }
            this.parts.put(name, o);
        }
        for (Map.Entry entry : childMap.entrySet()) {
            String key = (String)entry.getKey();
            if (this.parts.get(key) == null) continue;
            IExtendedModelPart part = (IExtendedModelPart)this.parts.get(key);
            for (String s : (Set)entry.getValue()) {
                if (this.parts.get(s) == null || this.parts.get(s) == part) continue;
                part.addChild((IExtendedModelPart)this.parts.get(s));
            }
        }
    }
}

