/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.mca;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.texturing.TextureCoordinate;
import thut.core.client.render.x3d.ModelFormatException;
import thut.core.xml.bind.Factory;
import thut.core.xml.bind.annotation.XmlAttribute;
import thut.core.xml.bind.annotation.XmlElement;
import thut.core.xml.bind.annotation.XmlRootElement;

public class McaXML {
    public Mca model;

    public McaXML(InputStream stream) {
        try {
            this.model = Factory.make(stream, Mca.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @XmlRootElement(name="mca.project.MCStandard.data.ProjectSavable")
    public static class Mca {
        @XmlElement(name="modelNode")
        ModelNode node;
    }

    @XmlRootElement(name="world_bound")
    public static class WorldBound {
        @XmlAttribute(name="xExtent")
        float x = 0.0f;
        @XmlAttribute(name="yExtent")
        float y = 0.0f;
        @XmlAttribute(name="zExtent")
        float z = 0.0f;
        @XmlElement(name="center")
        Center center;
    }

    @XmlRootElement(name="translation")
    public static class Translation {
        @XmlAttribute(name="x")
        float x = 0.0f;
        @XmlAttribute(name="y")
        float y = 0.0f;
        @XmlAttribute(name="z")
        float z = 0.0f;
    }

    @XmlRootElement(name="transform")
    public static class Transform {
        @XmlElement(name="rot")
        Rot rotation;
        @XmlElement(name="translation")
        Translation translation;
    }

    @XmlRootElement(name="com.jme3.scene.Node")
    public static class SceneNode {
        @XmlAttribute(name="name")
        String name;
        @XmlElement(name="world_bound")
        WorldBound bound;
        @XmlElement(name="transform")
        Transform transform;
        @XmlElement(name="children")
        Children children;
    }

    @XmlRootElement(name="Savable")
    public static class Savable {
        @XmlAttribute(name="buffer_type")
        String type;
        @XmlElement(name="dataFloat")
        DataFloat data1;
        @XmlElement(name="dataUnsignedInt")
        DataUnsignedInt data2;

        private static Vertex[] parseVertices(String line, String type) throws ModelFormatException {
            ArrayList<Vertex> ret = new ArrayList<Vertex>();
            float scale = type.equals("Position") ? 0.0625f : 1.0f;
            String[] points = line.split(" ");
            if (points.length % 3 != 0) {
                throw new ModelFormatException("Invalid number of elements in the points string");
            }
            for (int i = 0; i < points.length; i += 3) {
                Vertex toAdd = new Vertex(Float.parseFloat(points[i]) * scale, Float.parseFloat(points[i + 1]) * scale, Float.parseFloat(points[i + 2]) * scale);
                ret.add(toAdd);
            }
            return ret.toArray(new Vertex[ret.size()]);
        }

        public Vertex[] getFloats() {
            return Savable.parseVertices(this.data1.data, this.type);
        }

        public TextureCoordinate[] getTexture(String point) {
            ArrayList<TextureCoordinate> ret = new ArrayList<TextureCoordinate>();
            String[] points = point.split(" ");
            if (points.length % 2 != 0) {
                throw new ModelFormatException("Invalid number of elements in the points string " + points.length);
            }
            for (int i = 0; i < points.length; i += 2) {
                TextureCoordinate toAdd = new TextureCoordinate(Float.parseFloat(points[i]), 1.0f - Float.parseFloat(points[i + 1]));
                ret.add(toAdd);
            }
            return ret.toArray(new TextureCoordinate[ret.size()]);
        }
    }

    @XmlRootElement(name="rot")
    public static class Rot {
        @XmlAttribute(name="x")
        float x = 0.0f;
        @XmlAttribute(name="y")
        float y = 0.0f;
        @XmlAttribute(name="z")
        float z = 0.0f;
        @XmlAttribute(name="w")
        float w = 0.0f;
    }

    @XmlRootElement(name="modelNode")
    public static class ModelNode {
        @XmlElement(name="world_bound")
        WorldBound bound;
        @XmlElement(name="children")
        Children children;
    }

    @XmlRootElement(name="modelBound")
    public static class ModelBound {
        @XmlAttribute(name="xExtent")
        float x = 0.0f;
        @XmlAttribute(name="yExtent")
        float y = 0.0f;
        @XmlAttribute(name="zExtent")
        float z = 0.0f;
        @XmlElement(name="center")
        Center center;
    }

    @XmlRootElement(name="mesh")
    public static class Mesh {
        @XmlElement(name="buffers")
        Buffers buffers;
        @XmlElement(name="modelBound")
        ModelBound bound;
    }

    @XmlRootElement(name="MapEntry")
    public static class MapEntry {
        @XmlAttribute(name="key")
        String key;
        @XmlElement(name="Savable")
        Savable savable;
    }

    @XmlRootElement(name="com.jme3.scene.Geometry")
    public static class GeometryNode {
        @XmlElement(name="mesh")
        Mesh mesh;
        @XmlElement(name="world_bound")
        WorldBound bound;
    }

    @XmlRootElement(name="dataUnsignedInt")
    public static class DataUnsignedInt {
        @XmlAttribute(name="data")
        String data;
        @XmlAttribute(name="size")
        int size;
    }

    @XmlRootElement(name="dataFloat")
    public static class DataFloat {
        @XmlAttribute(name="data")
        String data;
        @XmlAttribute(name="size")
        int size;
    }

    @XmlRootElement(name="children")
    public static class Children {
        @XmlAttribute(name="size")
        int size;
        @XmlElement(name="com.jme3.scene.Geometry")
        GeometryNode geometry;
        @XmlElement(name="com.jme3.scene.Node")
        List<SceneNode> scenes = Lists.newArrayList();
        SceneNode parent;
    }

    @XmlRootElement(name="center")
    public static class Center {
        @XmlAttribute(name="x")
        float x = 0.0f;
        @XmlAttribute(name="y")
        float y = 0.0f;
        @XmlAttribute(name="z")
        float z = 0.0f;
    }

    @XmlRootElement(name="buffers")
    public static class Buffers {
        @XmlElement(name="MapEntry")
        List<MapEntry> entries = Lists.newArrayList();

        public Vertex[] getNormals() {
            for (MapEntry entry : this.entries) {
                if (!entry.savable.type.equals("Normal")) continue;
                return entry.savable.getFloats();
            }
            return null;
        }

        public Integer[] getOrder() {
            for (MapEntry entry : this.entries) {
                if (!entry.savable.type.equals("Index")) continue;
                String[] offset = entry.savable.data2.data.split(" ");
                Integer[] order = new Integer[offset.length];
                for (int i = 0; i < offset.length; ++i) {
                    String s1 = offset[i];
                    order[i] = Integer.parseInt(s1);
                }
                return order;
            }
            return null;
        }

        public TextureCoordinate[] getTex() {
            for (MapEntry entry : this.entries) {
                if (!entry.savable.type.equals("TexCoord")) continue;
                return entry.savable.getTexture(entry.savable.data1.data);
            }
            return null;
        }

        public Vertex[] getVerts() {
            for (MapEntry entry : this.entries) {
                if (!entry.savable.type.equals("Position")) continue;
                return entry.savable.getFloats();
            }
            return null;
        }
    }

    @XmlRootElement(name="animations")
    public static class Animations {
    }

    @XmlRootElement(name="mca.project.MCStandard.animation.Animation")
    public static class Animation {
    }
}

