/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import thut.api.entity.IAnimated;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.AnimationHelper;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelCustom;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.IRetexturableModel;
import thut.core.common.ThutCore;
import thut.lib.ResourceHelper;

public abstract class BaseModel
implements IModelCustom,
IModel,
IRetexturableModel {
    public Map<String, IExtendedModelPart> parts;
    private final List<String> order;
    protected Map<String, Material> mats;
    Set<String> heads;
    public String name;
    protected boolean valid;
    protected boolean loaded;
    protected ResourceLocation last_loaded;
    protected IModel.IModelCallback callback;

    public BaseModel() {
        this.parts = new Object2ObjectOpenHashMap();
        this.order = Lists.newArrayList();
        this.mats = new Object2ObjectOpenHashMap();
        this.heads = Sets.newHashSet();
        this.valid = true;
        this.loaded = false;
        this.last_loaded = null;
        this.callback = null;
        this.valid = true;
    }

    public BaseModel(ResourceLocation l) {
        block3: {
            this();
            try {
                this.last_loaded = l;
                if (!ResourceHelper.exists(l, Minecraft.m_91087_().m_91098_())) {
                    this.valid = false;
                    return;
                }
                Loader loader = new Loader(this, l);
                loader.start();
            }
            catch (Exception e) {
                this.valid = false;
                if (e instanceof FileNotFoundException) break block3;
                ThutCore.LOGGER.error("error loading " + l, (Throwable)e);
            }
        }
    }

    protected abstract void loadModel(ResourceLocation var1);

    @Override
    public IModel init(IModel.IModelCallback callback) {
        if (this.loaded && this.isValid()) {
            callback.run(this);
        } else {
            this.callback = callback;
        }
        return this;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public Set<String> getHeadParts() {
        return this.heads;
    }

    @Override
    public List<String> getRenderOrder() {
        if (this.order.isEmpty() && this.loaded) {
            if (this.callback != null) {
                this.callback.run(this);
            }
            this.callback = null;
            try {
                IExtendedModelPart.sort(this.order, this.getParts());
            }
            catch (Exception e) {
                ThutCore.LOGGER.error("Error sorting parts for {} {}", (Object)this.last_loaded, (Object)this.name);
                ThutCore.LOGGER.error((Object)e);
            }
            for (String s : this.order) {
                IExtendedModelPart o = this.parts.get(s);
                o.preProcess();
            }
        }
        return this.order;
    }

    @Override
    public Map<String, IExtendedModelPart> getParts() {
        return this.parts;
    }

    private boolean isHead(String partName) {
        return this.getHeadParts().contains(partName);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void renderAll(PoseStack mat, VertexConsumer buffer) {
        for (String s : this.getRenderOrder()) {
            IExtendedModelPart o = this.parts.get(s);
            o.render(mat, buffer);
        }
    }

    @Override
    public void renderAllExcept(PoseStack mat, VertexConsumer buffer, Collection<String> excludedGroupNames) {
        for (String s : this.getRenderOrder()) {
            IExtendedModelPart o = this.parts.get(s);
            if (excludedGroupNames.contains(s)) continue;
            o.render(mat, buffer);
        }
    }

    @Override
    public void renderOnly(PoseStack mat, VertexConsumer buffer, Collection<String> groupNames) {
        for (String s : this.getRenderOrder()) {
            IExtendedModelPart o = this.parts.get(s);
            o.renderOnly(mat, buffer, groupNames);
        }
    }

    @Override
    public void renderPart(PoseStack mat, VertexConsumer buffer, String partName) {
        for (String s : this.getRenderOrder()) {
            IExtendedModelPart o = this.parts.get(s);
            if (o.getParent() != null) continue;
            o.renderPart(mat, buffer, partName);
        }
    }

    @Override
    public void applyAnimation(Entity entity, IModelRenderer<?> renderer, float partialTicks, float limbSwing) {
        if (this.getRenderOrder().isEmpty()) {
            return;
        }
        IAnimated.IAnimationHolder holder = renderer.getAnimationHolder();
        this.updateAnimation(entity, renderer, renderer.getAnimation(entity), partialTicks, holder.getHeadInfo().headYaw, holder.getHeadInfo().headYaw, limbSwing);
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        if (this.getRenderOrder().isEmpty()) {
            return;
        }
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            IRetexturableModel tex = (IRetexturableModel)((Object)part);
            tex.setAnimationChanger(changer);
        }
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        if (this.getRenderOrder().isEmpty()) {
            return;
        }
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            IRetexturableModel tex = (IRetexturableModel)((Object)part);
            tex.setTexturer(texturer);
        }
    }

    protected void updateAnimation(Entity entity, IModelRenderer<?> renderer, String currentPhase, float partialTicks, float headYaw, float headPitch, float limbSwing) {
        if (this.getRenderOrder().isEmpty()) {
            return;
        }
        for (String partName : this.getParts().keySet()) {
            IExtendedModelPart part = this.getParts().get(partName);
            this.updateSubParts(entity, renderer, currentPhase, partialTicks, part, headYaw, headPitch, limbSwing);
        }
    }

    private void updateSubParts(Entity entity, IModelRenderer<?> renderer, String currentPhase, float partialTick, IExtendedModelPart parent, float headYaw, float headPitch, float limbSwing) {
        if (this.getRenderOrder().isEmpty()) {
            return;
        }
        if (parent == null) {
            return;
        }
        parent.resetToInit();
        boolean anim = renderer.getAnimations().containsKey(currentPhase);
        ArrayList anims = Lists.newArrayList();
        IAnimated.IAnimationHolder animHolder = parent.getAnimationHolder();
        IAnimated.HeadInfo info = null;
        if (animHolder != null) {
            anims.addAll(animHolder.getPlaying());
            anim = !anims.isEmpty();
            info = animHolder.getHeadInfo();
        } else if (anim) {
            anims.addAll((Collection)renderer.getAnimations().get(currentPhase));
        }
        if (anim) {
            AnimationHelper.doAnimation(anims, entity, parent, partialTick, limbSwing);
        }
        if (this.isHead(parent.getName())) {
            float ang2 = -info.headPitch;
            float head = info.headYaw + 180.0f;
            float diff = 0.0f;
            if (info.yawDirection != -1) {
                head *= -1.0f;
            }
            diff = head % 360.0f;
            diff = (diff + 360.0f) % 360.0f;
            diff = (diff - 180.0f) % 360.0f;
            diff = Math.max(diff, info.yawCapMin);
            float ang = diff = Math.min(diff, info.yawCapMax);
            ang2 = Math.max(ang2, info.pitchCapMin);
            ang2 = Math.min(ang2, info.pitchCapMax);
            Vector4 dir = info.yawAxis == 0 ? new Vector4(info.yawDirection, 0.0, 0.0, ang) : (info.yawAxis == 2 ? new Vector4(0.0, 0.0, info.yawDirection, ang) : new Vector4(0.0, info.yawDirection, 0.0, ang));
            Vector4 dir2 = info.pitchAxis == 2 ? new Vector4(0.0, 0.0, info.pitchDirection, ang2) : (info.pitchAxis == 1 ? new Vector4(0.0, info.pitchDirection, 0.0, ang2) : new Vector4(info.yawDirection, 0.0, 0.0, ang2));
            Vector4 combined = new Vector4();
            combined.mul(dir.toQuaternion(), dir2.toQuaternion());
            parent.setPostRotations(combined);
        }
        for (String partName : parent.getSubParts().keySet()) {
            IExtendedModelPart part = (IExtendedModelPart)parent.getSubParts().get(partName);
            this.updateSubParts(entity, renderer, currentPhase, partialTick, part, headYaw, headPitch, limbSwing);
        }
    }

    public static class Loader
    implements Runnable {
        final BaseModel toLoad;
        final ResourceLocation res;

        public Loader(BaseModel model, ResourceLocation res) {
            this.toLoad = model;
            this.res = res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.toLoad.loadModel(this.res);
            BaseModel baseModel = this.toLoad;
            synchronized (baseModel) {
                this.toLoad.loaded = true;
                if (this.toLoad.callback != null) {
                    this.toLoad.callback.run(this.toLoad);
                }
                this.toLoad.callback = null;
            }
        }

        public void start() {
            String key = "ThutCore: Model Load: " + this.res;
            Thread loader = new Thread(this);
            loader.setName(key);
            if (ThutCore.conf.asyncModelLoads) {
                loader.start();
            } else {
                loader.run();
            }
        }
    }
}

