/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import thut.api.entity.IAnimated;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.model.IModelCustom;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.texturing.IPartTexturer;

public interface IExtendedModelPart
extends IModelCustom {
    public static void sort(List<String> order, Map<String, IExtendedModelPart> parts) {
        order.clear();
        order.addAll(parts.keySet());
        order.sort((s1, s2) -> {
            IExtendedModelPart o1 = (IExtendedModelPart)parts.get(s1);
            IExtendedModelPart o2 = (IExtendedModelPart)parts.get(s2);
            boolean transp1 = false;
            boolean transp2 = false;
            for (Material m : o1.getMaterials()) {
                if (m != null && (transp1 = m.transluscent || m.alpha < 1.0f)) break;
            }
            for (Material m : o2.getMaterials()) {
                if (m != null && (transp2 = m.transluscent || m.alpha < 1.0f)) break;
            }
            if (transp1 != transp2) {
                return transp1 ? 1 : -1;
            }
            return s1.compareTo((String)s2);
        });
    }

    public void addChild(IExtendedModelPart var1);

    public List<Material> getMaterials();

    public void applyTexture(MultiBufferSource var1, ResourceLocation var2, IPartTexturer var3);

    default public void addMaterial(Material material) {
        this.getMaterials().add(material);
    }

    default public void preProcess() {
        IExtendedModelPart child = this;
        child.getRecursiveChildNames().addAll(this.getSubParts().keySet());
        String name = child.getName();
        for (IExtendedModelPart parent = this.getParent(); parent != null; parent = parent.getParent()) {
            this.getParentNames().add(parent.getName());
            parent.getRecursiveChildNames().add(name);
            parent.getRecursiveChildNames().addAll(child.getRecursiveChildNames());
            child = parent;
            name = child.getName();
        }
        for (IExtendedModelPart o : this.getSubParts().values()) {
            o.preProcess();
        }
    }

    default public void sort(List<String> order) {
        IExtendedModelPart.sort(order, this.getSubParts());
    }

    default public void preRender(PoseStack mat) {
    }

    default public void postRender(PoseStack mat) {
    }

    public Vector3 minBound();

    public Vector3 maxBound();

    public Vector4 getDefaultRotations();

    public Vector3 getDefaultTranslations();

    public String getName();

    public IExtendedModelPart getParent();

    public <T extends IExtendedModelPart> Map<String, T> getSubParts();

    public List<String> getRenderOrder();

    public String getType();

    default public void removeChild(String name) {
        this.getSubParts().remove(name);
    }

    public void resetToInit();

    default public void setHidden(boolean hidden) {
    }

    default public boolean isHidden() {
        return false;
    }

    default public void setDisabled(boolean disabled) {
    }

    default public boolean isDisabled() {
        return false;
    }

    default public void updateMaterial(AnimationXML.Mat mat, Material material) {
    }

    default public Set<String> getParentNames() {
        return Sets.newHashSet();
    }

    default public Set<String> getRecursiveChildNames() {
        return Sets.newHashSet();
    }

    public void setAnimationHolder(IAnimated.IAnimationHolder var1);

    public IAnimated.IAnimationHolder getAnimationHolder();

    public void setParent(IExtendedModelPart var1);

    public void setPostRotations(Vector4 var1);

    public void setPostTranslations(Vector3 var1);

    public void setPreRotations(Vector4 var1);

    public void setPreScale(Vector3 var1);

    public void setPreTranslations(Vector3 var1);

    public void setRGBABrO(@Nullable Predicate<Material> var1, int var2, int var3, int var4, int var5, int var6, int var7);

    default public void setRGBABrO(int r, int g, int b, int a, int br, int o) {
        this.setRGBABrO(m -> true, r, g, b, a, br, o);
    }
}

