/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import thut.api.entity.IAnimated;
import thut.api.entity.animation.Animation;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vec3f;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.parts.Material;
import thut.core.common.ThutCore;

public interface IModel {
    public static final ImmutableSet<String> emptyAnims = ImmutableSet.of();

    public void applyAnimation(Entity var1, IModelRenderer<?> var2, float var3, float var4);

    default public Set<String> getBuiltInAnimations() {
        return emptyAnims;
    }

    public Set<String> getHeadParts();

    public Map<String, IExtendedModelPart> getParts();

    public List<String> getRenderOrder();

    default public void setAnimationHolder(IAnimated.IAnimationHolder holder) {
        this.getParts().forEach((s, p) -> p.setAnimationHolder(holder));
    }

    default public void globalFix(PoseStack mat, float dx, float dy, float dz) {
        mat.m_85845_(new Quaternion(90.0f, 0.0f, 180.0f, true));
        mat.m_85837_(0.0, 0.0, (double)(dy - 1.5f));
    }

    public boolean isValid();

    default public IModel init(IModelCallback callback) {
        if (this.isValid()) {
            callback.run(this);
        }
        return this;
    }

    default public boolean isLoaded() {
        return true;
    }

    public void preProcessAnimations(Collection<Animation> var1);

    default public void setOffset(Vector3 offset) {
    }

    default public void updateMaterial(AnimationXML.Mat mat) {
        mat.name = ThutCore.trim(mat.name);
        Material material = new Material(mat.name);
        material.diffuseColor = new Vec3f(1.0f, 1.0f, 1.0f);
        material.emissiveColor = new Vec3f(mat.light, mat.light, mat.light);
        material.emissiveMagnitude = Math.min(1.0f, (float)((double)material.emissiveColor.length() / Math.sqrt(3.0)) / 0.8f);
        material.specularColor = new Vec3f(1.0f, 1.0f, 1.0f);
        material.alpha = mat.alpha;
        material.flat = !mat.smooth;
        material.transluscent = mat.transluscent;
        material.cull = mat.cull;
        material.shader = mat.shader;
        for (IExtendedModelPart part : this.getParts().values()) {
            part.updateMaterial(mat, material);
        }
    }

    public static interface IModelCallback {
        public void run(IModel var1);
    }
}

