/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import thut.api.ModelHolder;
import thut.core.client.render.animation.AnimationLoader;
import thut.core.client.render.bbmodel.BBModel;
import thut.core.client.render.json.JsonModel;
import thut.core.client.render.model.IModel;
import thut.core.client.render.x3d.X3dModel;
import thut.core.common.ThutCore;

public class ModelFactory {
    private static final Map<String, IFactory<?>> modelFactories = Maps.newHashMap();
    public static final List<String> knownExtension = Lists.newArrayList();

    public static IModel create(ResourceLocation location, ModelHolder model, IModel.IModelCallback callback) {
        String ext;
        String path = location.m_135815_();
        String string = ext = path.contains(".") ? path.substring(path.lastIndexOf(".") + 1, path.length()) : "";
        if (ext.isEmpty()) {
            IModel ret = null;
            for (String ext1 : knownExtension) {
                IFactory<?> factory = modelFactories.get(ext1);
                ResourceLocation model1 = new ResourceLocation(location.m_135827_(), path + "." + ext1);
                if (ThutCore.conf.debug_models) {
                    ThutCore.LOGGER.debug("Checking " + model1);
                }
                ret = factory.create(model1);
                ext = ext1;
                if (ret == null || !ret.isValid()) continue;
                break;
            }
            if (ret == null) {
                ret = new X3dModel();
            }
            if (!ret.isValid()) {
                if (ThutCore.conf.debug_models) {
                    ThutCore.LOGGER.error("No Model found for " + location);
                }
            } else {
                if (ThutCore.conf.debug_models) {
                    ThutCore.LOGGER.debug("Successfully loaded model for " + location);
                }
                model.extension = ext;
            }
            return ret.init(callback);
        }
        IFactory<?> factory = modelFactories.get(ext);
        model.extension = ext;
        return factory.create(location).init(callback);
    }

    public static IModel create(ModelHolder model, IModel.IModelCallback callback) {
        IModel made = ModelFactory.create(model.model, model, callback);
        if (!made.isValid()) {
            for (ResourceLocation loc : model.backupModels) {
                made = ModelFactory.create(loc, model, callback);
                if (!made.isValid()) continue;
                return made;
            }
        }
        return made;
    }

    public static IModel create(ModelHolder model) {
        return ModelFactory.create(model, m -> AnimationLoader.parse(model, m, null));
    }

    public static Set<String> getValidExtensions() {
        return modelFactories.keySet();
    }

    public static void registerIModel(String extension, IFactory<?> clazz) {
        modelFactories.put(extension, clazz);
        if (!knownExtension.contains(extension)) {
            knownExtension.add(extension);
        }
    }

    static {
        ModelFactory.registerIModel("bbmodel", BBModel::new);
        ModelFactory.registerIModel("json", JsonModel::new);
        ModelFactory.registerIModel("x3d", X3dModel::new);
    }

    public static interface IFactory<T extends IModel> {
        public T create(ResourceLocation var1);
    }
}

